/*
 * $Header: /home/cvs/jakarta-slide/src/stores/org/apache/slide/store/mem/VersionedUriKey.java,v 1.3.2.1 2004/08/17 14:16:00 luetzkendorf Exp $
 * $Revision: 1.3.2.1 $
 * $Date: 2004/08/17 14:16:00 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.store.mem;

import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeRevisionNumber;


/**
 * Class to hold an URI and a version number to be used as key in maps.
 * 
 */
class VersionedUriKey {
   private String uri;
   private String version;
   VersionedUriKey(Uri uri, NodeRevisionNumber number) 
   {
      this.uri = uri.toString();
      if (number == null) {
          this.version = "null";
      } else {
          this.version = number.toString();
      }
   }
   public boolean equals(Object obj)
   {
      if (obj == this) return true;
      if (obj instanceof VersionedUriKey) {
         VersionedUriKey that = (VersionedUriKey)obj;
         return this.uri.equals(that.uri) && this.version.equals(that.version);
      }
      return false;
   }
   public int hashCode()
   {
      return (uri.hashCode() ^ version.hashCode());
   }
   public String toString()
   {
      return uri + " - " + version;
   }
}