/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.cas.client.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SimpleCASAuthorizationFilter
implements Filter {
    public static final String AUTHORIZED_USER_STRING = "edu.yale.its.tp.cas.client.filter.authorizedUsers";
    public static final String FILTER_NAME = "SimpleCASAuthorizationFilter";
    private String authorizedUsersString;
    private List authorizedUsers;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.authorizedUsersString = filterConfig.getInitParameter(AUTHORIZED_USER_STRING);
        StringTokenizer stringTokenizer = new StringTokenizer(this.authorizedUsersString);
        this.authorizedUsers = new ArrayList();
        while (stringTokenizer.hasMoreTokens()) {
            this.authorizedUsers.add(stringTokenizer.nextElement());
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            throw new ServletException("SimpleCASAuthorizationFilter: protects only HTTP resources");
        }
        HttpSession httpSession = ((HttpServletRequest)servletRequest).getSession();
        if (this.authorizedUsers.isEmpty()) {
            throw new ServletException("SimpleCASAuthorizationFilter: no authorized users set.");
        }
        if (!this.authorizedUsers.contains((String)httpSession.getAttribute("edu.yale.its.tp.cas.client.filter.user"))) {
            throw new ServletException("SimpleCASAuthorizationFilter: user " + httpSession.getAttribute("edu.yale.its.tp.cas.client.filter.user") + " not authorized.");
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

