 /*
  * ====================================================================
  *
  * Copyright 2004 The Apache Software Foundation
  *
  * Licensed under the Apache License, Version 2.0 (the "License");
  * you may not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  *     http://www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an "AS IS" BASIS,
  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  */
package org.apache.slide.event;

import org.apache.commons.lang.StringUtils;

/**
 * @author tbellemb
 * @version 1.0.0-RC1
 *
 */
public class QuotaConstants {

	// resource MD
	public static final String QUOTA_USED_BYTES = "quota-used-bytes";
	public static final String QUOTA_AVAILABLE_BYTES = "quota-available-bytes";
	public static final String VIRTUAL_ROOT = "virtual-root"; // optional
	public static final String NRD_CONTENT_LENGTH = "getcontentlength"; // resource content length
	public static final String TYPE_COLLECTION = "collection"; // resource content length
	public static final String NRD_COLLECTION_LENGTH = "getcollectionlength";
	// for old times sake; apple compatibility
	public static final String QUOTA_ASSIGNED_BYTES_APPLE = "quota"; // quota-assigned-bytes/512
	public static final String QUOTA_USED_BYTES_APPLE = "quotaused"; // quota-used-bytes/512
	
	// namespaces
	public static final String NAMESPACE_DAV = "DAV:";
	public static final String NAMESPACE_ESUP = "ESUP:"; // TODO choose a proper NS - for the wirtual-root MD
		
	// quota exceeded message
	public static final String QUOTA_EXCEEDED = "quota exceeded";
	
	// const. used to specify if the resource content length is in the request (ex: put request)
	// or in the NRD (ex: copy request)
	public static final Integer CONTENT_LENGTH_IN_NRD = new Integer(1);
	public static final Integer CONTENT_LENGTH_IN_REQUEST = new Integer(2);

	// quota operators
	public static final String SUBTRACT_QUOTA_USED_BYTES = "substractQuotaUsedBytes";
	public static final String ADD_QUOTA_USED_BYTES = "addQuotaUsedBytes";
	
	
	/**
	 * Get the parent uri of an uri
	 * 
	 * @param uri to process
	 * @return the parent uri
	 */
	public static String getParentUri (String uri) {
		uri = StringUtils.removeEnd(uri, "/");
		int indexLastSlash = uri.lastIndexOf("/");
		if (indexLastSlash == -1) return null;
		else if (indexLastSlash == 0) return "/";
		else return uri.substring(0, indexLastSlash);	
	}// getParentUri
	
}// QuotaConstants
