/**
 * Provides funtions to manage quotas on the server.
 * @author Thomas Bellembois
 * @version 1.0
 * creation date : 2005.07.05
 * last modification date : 2005.10.05
 * modifications :
 * */
package org.apache.util.quotaWS;


import java.util.Enumeration;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Status;
import javax.transaction.SystemException;

import org.apache.axis.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.slide.authenticate.CredentialsToken;
import org.apache.slide.authenticate.SecurityToken;
import org.apache.slide.common.Domain;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.SlideTokenImpl;
import org.apache.slide.content.Content;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.event.QuotaConstants;
import org.apache.slide.event.QuotaElement;
import org.apache.slide.event.VetoException;
import org.apache.slide.lock.ObjectLockedException;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.structure.LinkedObjectNotFoundException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.structure.Structure;
import org.apache.slide.util.logger.Logger;

import fr.univrennes1.cri.util.commonUtils.CommonUtils;


public class QuotaWS {
	
	
	private String userName;
	private static Log log;
	
	private NamespaceAccessToken namespaceAccessToken;
	private SlideToken token;
	//private SlideToken systemToken; // for security purposes, in case of...
	private Content content;
	private Structure structure;

	
	public QuotaWS(){
		log = LogFactory.getLog("org.apache.util.quotaWS.QuotaWS");
	}// constructor
	
	
	// generate spaces - for logs
	private String generateSpaces(Integer depth, String character) {
		String result = "";
		
		for(int i=0; i<=depth.intValue(); i++) {
			result += character+character;
		}// for(int i=0; i<=depth.intValue(); i++)
		
		return result;
	}// generateSpaces
	
	
	public String getChildren(String path, Boolean processFiles) {
		
		log.info("getChildren:path="+path);
		
		String result = "";
		
		try {
		if (namespaceAccessToken.getStatus() != Status.STATUS_ACTIVE) namespaceAccessToken.begin();
		
		//NodeRevisionDescriptors nrds = content.retrieve(token, path);
		//NodeRevisionDescriptor nrd = content.retrieve(token, nrds);
		
		// getting the current ObjectNode
		ObjectNode currentObjectNode = structure.retrieve(token, path);
		log.debug("getChildren:currentObjectNode="+currentObjectNode.toString());
		// getting the children of the current ObjectNode
		Enumeration childrenEnumeration = currentObjectNode.enumerateChildren();
		
		while (childrenEnumeration != null && childrenEnumeration.hasMoreElements()) {
						
			String childrenUri = (String) childrenEnumeration.nextElement();
			log.debug("getChildren:childrenUri="+childrenUri);
			
			//ObjectNode childrenObjectNode = structure.retrieve(token, childrenUri);
			NodeRevisionDescriptors childrenNrds = content.retrieve(token, childrenUri);
			NodeRevisionDescriptor childrenNrd = content.retrieve(token, childrenNrds);
						
			if ((childrenNrd.getResourceType()).indexOf("collection") != -1 || processFiles.booleanValue()) {
				log.debug("getChildren:processFiles=true or resource=directory");
				String childrenName = childrenNrd.getName();
				result += ":"+childrenName;
			}// if ((childrenNrd.getResourceType()).indexOf("collection") != -1 || processFiles.booleanValue())
			else {
				log.debug("getChildren:processFiles=false and resource=file");
			}// else ((childrenNrd.getResourceType()).indexOf("collection") != -1 || processFiles.booleanValue())
			
		}// while (childrenEnumeration.hasMoreElements()) {
		
		if (!result.equalsIgnoreCase("")) result = result.substring(1);
		
		namespaceAccessToken.commit();
		} catch (NotSupportedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalStateException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SecurityException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (HeuristicMixedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (HeuristicRollbackException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (RollbackException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SystemException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ObjectNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (AccessDeniedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (LinkedObjectNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ObjectLockedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ServiceAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (VetoException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (RevisionDescriptorNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		return result;
		
	}// getChildren
	
	
	/**
	 * Return a formatted representation of the tree with quota metadata and usefull information (not protected or wrong metadata)
	 * @param path path to process
	 * @param processFiles if true, shows files, else shows only directories
	 * @return the tree representation
	 */
	public String getTreeQuotaInformation(String path, Boolean processFiles, Integer maxDepth) {
		return getTreeQuotaInformation(path, processFiles, new Integer(0), maxDepth);
	}// getTreeQuotaInformation
	
	
	/**
	 * Return a formatted representation of the tree with quota metadata and usefull information (not protected or wrong metadata)
	 * @param path path to process
	 * @param processFiles if true, shows files, else shows only directories
	 * @param depth depth=0 the first time the function is called and then increases at each recursive call - needed for namespaceAccessToken.commit()
	 * @return the tree representation
	 */
	private String getTreeQuotaInformation(String path, Boolean processFiles, Integer depth, Integer maxDepth) {
		
		log.info("getTreeQuotaInformation:path="+path+" depth="+depth.toString());
		
		String result = "";
		
		try {
		if (namespaceAccessToken.getStatus() != Status.STATUS_ACTIVE) namespaceAccessToken.begin();
		
		NodeRevisionDescriptors nrds = content.retrieve(token, path);
		NodeRevisionDescriptor nrd = content.retrieve(token, nrds);
		
		String resourceType = nrd.getResourceType();
		log.debug("getTreeQuotaInformation:resourceType="+resourceType);
		if (resourceType.indexOf("collection") == -1 && !processFiles.booleanValue()) {
			log.debug("getTreeQuotaInformation:not a collection and processFiles=false");
			return "";
		}
		
		// getting the current ObjectNode
		ObjectNode currentObjectNode = structure.retrieve(token, path);
		log.debug("getTreeQuotaInformation:currentObjectNode="+currentObjectNode.toString());
		// getting the children of the current ObjectNode
		Enumeration childrenEnumeration = currentObjectNode.enumerateChildren();
		
		NodeProperty nodePropertyQAB = nrd.getProperty(QuotaConstants.QUOTA_AVAILABLE_BYTES, QuotaConstants.NAMESPACE_DAV);
		NodeProperty nodePropertyQUB = nrd.getProperty(QuotaConstants.QUOTA_USED_BYTES, QuotaConstants.NAMESPACE_DAV);
		NodeProperty nodePropertyVR = nrd.getProperty(QuotaConstants.VIRTUAL_ROOT, QuotaConstants.NAMESPACE_ESUP);
		
		String currentQuotaAvailableBytes;
		String currentQuotaUsedBytes;
		String currentVirtualRoot;
		
		if (nodePropertyVR != null) {
			currentVirtualRoot = nodePropertyVR.getValue().toString();
			if (!nodePropertyVR.isProtected()) currentVirtualRoot = currentVirtualRoot+"<-- NP!";
		}// if (nodeProperty != null)
		else {
			currentVirtualRoot = "null";
		}// else (nodeProperty != null
		
		if (nodePropertyQUB != null) {
			currentQuotaUsedBytes = nodePropertyQUB.getValue().toString();
			if (!nodePropertyQUB.isProtected()) currentQuotaUsedBytes = currentQuotaUsedBytes+"<-- NP!";
		}// if (nodeProperty != null)
		else {
			currentQuotaUsedBytes = "null";
		}// else (nodeProperty != null
		
		if (nodePropertyQAB != null) {
			currentQuotaAvailableBytes = nodePropertyQAB.getValue().toString();
			if (!nodePropertyQAB.isProtected()) currentQuotaAvailableBytes = currentQuotaAvailableBytes+"<-- NP!";
		}// if (nodeProperty != null)
		else {
			currentQuotaAvailableBytes = "null";
		}// else (nodeProperty != null
		
		log.debug("getTreeQuotaInformation:currentQuotaAvailableBytes="+currentQuotaAvailableBytes);
		log.debug("getTreeQuotaInformation:currentQuotaUsedBytes="+currentQuotaUsedBytes);
		log.debug("getTreeQuotaInformation:currentVirtualRoot="+currentVirtualRoot);
		
		if (currentVirtualRoot.equalsIgnoreCase("true")) currentVirtualRoot = ">>>"+currentVirtualRoot+"<<<";
		if (currentQuotaUsedBytes.equalsIgnoreCase("null") && !currentQuotaAvailableBytes.equalsIgnoreCase("null") ||
			!currentQuotaUsedBytes.equalsIgnoreCase("null") && currentQuotaAvailableBytes.equalsIgnoreCase("null")) {
			currentQuotaAvailableBytes = currentQuotaAvailableBytes + "<-- WRONG!";
			currentQuotaUsedBytes = currentQuotaUsedBytes + "<-- WRONG!";
		}// if ...
		
//		result += generateSpaces(depth, "-")+"uri="+path+"\n";
//		result += generateSpaces(depth, " ")+"QAB="+currentQuotaAvailableBytes+"\n";
//		result += generateSpaces(depth, " ")+"QUB="+currentQuotaUsedBytes+"\n";
//		result += generateSpaces(depth, " ")+"VR="+currentVirtualRoot+"\n";
//		result += generateSpaces(depth, "-")+"uri="+path+" [ QAB="+currentQuotaAvailableBytes+" QUB="+currentQuotaUsedBytes+" VR="+currentVirtualRoot+" ] \n";
		if (currentQuotaUsedBytes.equalsIgnoreCase("null") && currentQuotaAvailableBytes.equalsIgnoreCase("null") && currentVirtualRoot.equalsIgnoreCase("null"))
				result += "|"+generateSpaces(depth, " ")+CommonUtils.getResourceName(path)+"\n";
		else result += "|"+generateSpaces(depth, " ")+CommonUtils.getResourceName(path)+" [ QAB="+currentQuotaAvailableBytes+" QUB="+currentQuotaUsedBytes+" VR="+currentVirtualRoot+" ]\n";
		
		while (childrenEnumeration != null && childrenEnumeration.hasMoreElements() && depth.intValue() < maxDepth.intValue()) {
						
			String childrenUri = (String) childrenEnumeration.nextElement();
			log.debug("getTreeQuotaInformation:childrenUri="+childrenUri);
			
			result += getTreeQuotaInformation(childrenUri, processFiles, new Integer((depth.intValue())+1), maxDepth);
			
		}// while (childrenEnumeration.hasMoreElements()) {
		
		if (depth.intValue() == 0) namespaceAccessToken.commit();
		} catch (NotSupportedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalStateException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SecurityException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (HeuristicMixedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (HeuristicRollbackException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (RollbackException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SystemException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ObjectNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (AccessDeniedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (LinkedObjectNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ObjectLockedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ServiceAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (VetoException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (RevisionDescriptorNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		return result;
		
	}// getTreeQuotaInformation
	
	
	/**
	 * Initializes the WebService. Required before calling a method. Authenticate the user (TODO)
	 * @param object nothing to do here, but required TODO
	 * @return true if no error occured else false
	 */
	public String init(Object object) {
		
		log.info("init");

		MessageContext mc = MessageContext.getCurrentContext();
		userName = mc.getUsername(); //TODO authentication
		log.debug("init:userName="+userName);
		
		namespaceAccessToken = Domain.accessNamespace(new SecurityToken(""), Domain.getDefaultNamespace());
		token = new SlideTokenImpl(new CredentialsToken(userName));
		token.setForceStoreEnlistment(true);
		structure = namespaceAccessToken.getStructureHelper();
		content = namespaceAccessToken.getContentHelper();
		 
		// disabling security check
//		systemToken = new SlideTokenWrapper(token);
//		systemToken.setForceSecurity(false);
//		systemToken.setForceLock(false); 
		
		return "true";
		
		
//		SlideToken systemToken = new SlideTokenWrapper(slideToken);
//		systemToken.setForceSecurity(false);
//		systemToken.setForceLock(false); 
	}// init
	
	
	/**
	 * Get the resource DAV:quota-used-bytes metadata
	 * @param path path of the resource
	 * @return the resource DAV:quota-used-bytes metadata - "null" if it does not exist
	 */
	public String getQuotaUsedBytes(String path) {
		
		log.info("getQuotaUsedBytes:path="+path);
		
		String result = null;
		try {
			if (namespaceAccessToken.getStatus() != Status.STATUS_ACTIVE) namespaceAccessToken.begin();// TODO necessary ?
			
			NodeRevisionDescriptors nrds = content.retrieve(token, path);
			NodeRevisionDescriptor nrd = content.retrieve(token, nrds);
			NodeProperty nodeProperty = nrd.getProperty(QuotaConstants.QUOTA_USED_BYTES, QuotaConstants.NAMESPACE_DAV);
			if (nodeProperty != null) result = nodeProperty.getValue().toString();
			else result = "0";
			
			log.info("getQuotaUsedBytes:result="+result);
			
			namespaceAccessToken.commit();
		} catch (NotSupportedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SystemException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalStateException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SecurityException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (HeuristicMixedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (HeuristicRollbackException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (RollbackException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ObjectNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (AccessDeniedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (LinkedObjectNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (RevisionDescriptorNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ObjectLockedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ServiceAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (VetoException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return result;
		
	}// getQuotaUsedBytes
	
	
	/**
	 * Get the resource DAV:quota-available-bytes metadata
	 * @param path path of the resource
	 * @return the resource DAV:quota-available-bytes metadata - "null" if it does not exist
	 */
	public String getQuotaAvailableBytes(String path) {
		
		log.info("getQuotaAvailableBytes:path="+path);
		
		String result = null;
		try {
			if (namespaceAccessToken.getStatus() != Status.STATUS_ACTIVE) namespaceAccessToken.begin();// TODO necessary ?
			
			NodeRevisionDescriptors nrds = content.retrieve(token, path);
			NodeRevisionDescriptor nrd = content.retrieve(token, nrds);
			NodeProperty nodeProperty = nrd.getProperty(QuotaConstants.QUOTA_AVAILABLE_BYTES, QuotaConstants.NAMESPACE_DAV);
			if (nodeProperty != null) result = nodeProperty.getValue().toString();
			else result = "0";
			
			log.info("getQuotaAvailableBytes:result="+result);
			
			namespaceAccessToken.commit();
		} catch (NotSupportedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SystemException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalStateException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SecurityException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (HeuristicMixedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (HeuristicRollbackException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (RollbackException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ObjectNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (AccessDeniedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (LinkedObjectNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (RevisionDescriptorNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ObjectLockedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ServiceAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (VetoException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return result;
		
	}// getQuotaAvailableBytes
	
	
	/**
	 * Get the resource DAV:virtual-root metadata
	 * @param path path of the resource
	 * @return the resource DAV:virtual-root metadata - "null" if it does not exist
	 */
	public String getVirtualRoot(String path) {
		
		log.info("getVirtualRoot:path="+path);
		
		String result = "false";
		try {
			if (namespaceAccessToken.getStatus() != Status.STATUS_ACTIVE) namespaceAccessToken.begin();// TODO necessary ?
			
			NodeRevisionDescriptors nrds = content.retrieve(token, path);
			NodeRevisionDescriptor nrd = content.retrieve(token, nrds);
			NodeProperty nodeProperty = nrd.getProperty(QuotaConstants.VIRTUAL_ROOT, QuotaConstants.NAMESPACE_ESUP);
			if (nodeProperty != null ) result = nodeProperty.getValue().toString();
			else result = "false";
			
			log.info("getVirtualRoot:result="+result);
			
			namespaceAccessToken.commit();
		} catch (NotSupportedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SystemException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalStateException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SecurityException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (HeuristicMixedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (HeuristicRollbackException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (RollbackException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ObjectNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (AccessDeniedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (LinkedObjectNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (RevisionDescriptorNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ObjectLockedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ServiceAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (VetoException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return result;
		
	}// getVirtualRoot
	
	
	/**
	 * Patch the resource DAV:quota-used-bytes metadata with the given value
	 * @param path path of the resource to process
	 * @param value the new DAV:quota-used-bytes metadata
	 * @param overwrite if true overwrite the metadata, else do nothing if the resource already exists
	 * @return true if no error occured else false
	 */
	public String patchQuotaUsedBytes(String path, Long value, Boolean overwrite) {
		
		String result = "false";
		
		log.info("patchQuotaUsedBytes:path="+path+" value="+value+" overwrite="+overwrite.toString());
		
		try {
			if (namespaceAccessToken.getStatus() != Status.STATUS_ACTIVE) namespaceAccessToken.begin();// TODO necessary ?
			
			NodeRevisionDescriptors nrds = content.retrieve(token, path);
			NodeRevisionDescriptor nrd = content.retrieve(token, nrds);
			
			NodeProperty nodeProperty = nrd.getProperty(QuotaConstants.QUOTA_USED_BYTES, QuotaConstants.NAMESPACE_DAV);
			
			if (nodeProperty == null) {
				log.debug("patchQuotaUsedBytes:initializing "+QuotaConstants.QUOTA_USED_BYTES+" MD to 0");
				nrd.setProperty(new NodeProperty(QuotaConstants.QUOTA_USED_BYTES, String.valueOf("0"), true));
				content.store(token, path, nrd, null);
			}// if (overwrite.booleanValue())
			else if (overwrite.booleanValue()) {
				log.debug("patchQuotaUsedBytes:overwriting "+QuotaConstants.QUOTA_USED_BYTES+" MD to "+value.longValue());
				nrd.setProperty(new NodeProperty(QuotaConstants.QUOTA_USED_BYTES, String.valueOf(value.longValue()), true));
				content.store(token, path, nrd, null);
			}// else if (overwrite.booleanValue() && nodeProperty == null)
			else {
				log.debug("patchQuotaUsedBytes:"+QuotaConstants.QUOTA_USED_BYTES+" MD not modified");
			}// else (nodeProperty == null)
			
			result = "true";
			log.info("patchQuotaUsedBytes:result="+result);
			
			namespaceAccessToken.commit();
		} catch (NotSupportedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SystemException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalStateException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SecurityException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (HeuristicMixedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (HeuristicRollbackException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (RollbackException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ObjectNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (AccessDeniedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (LinkedObjectNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (RevisionDescriptorNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ObjectLockedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ServiceAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (VetoException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (RevisionNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return result;
		
	}// patchQuotaUsedBytes
	
	
	/**
	 * Patch the resource DAV:quota-available-bytes metadata to the given value
	 * @param path path of the resource to process
	 * @param value the new DAV:quota-available-bytes metadata
	 * @return true if no error occured else false
	 */
	public String patchQuotaAvailableBytes(String path, Long value) {
		
		String result = "false";
		
		log.info("patchQuotaAvailableBytes:path="+path+" value="+value);
		
		try {
			if (namespaceAccessToken.getStatus() != Status.STATUS_ACTIVE) namespaceAccessToken.begin();// TODO necessary ?
			
			NodeRevisionDescriptors nrds = content.retrieve(token, path);
			NodeRevisionDescriptor nrd = content.retrieve(token, nrds);
			nrd.setProperty(new NodeProperty(QuotaConstants.QUOTA_AVAILABLE_BYTES, String.valueOf(value.longValue()), true));
			content.store(token, path, nrd, null);
			
			result = "true";
			log.info("patchQuotaAvailableBytes:result="+result);
			
			namespaceAccessToken.commit();
		} catch (NotSupportedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SystemException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalStateException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SecurityException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (HeuristicMixedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (HeuristicRollbackException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (RollbackException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ObjectNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (AccessDeniedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (LinkedObjectNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (RevisionDescriptorNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ObjectLockedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ServiceAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (VetoException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (RevisionNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return result;
		
	}// patchQuotaUsedBytes
	
	public String setProperty (String path, String property, String value, String protectedProperty) {
		
		String result = "false";
		
		log.info("setProtectedMetadata:path="+path+" property="+property+" value="+value);
		
		try {
			if (namespaceAccessToken.getStatus() != Status.STATUS_ACTIVE) namespaceAccessToken.begin();// TODO necessary ?
			
			NodeRevisionDescriptors nrds = content.retrieve(token, path);
			NodeRevisionDescriptor nrd = content.retrieve(token, nrds);
			boolean _protectedProperty = Boolean.valueOf(protectedProperty).booleanValue();
			nrd.setProperty(new NodeProperty(property, value, _protectedProperty));
			content.store(token, path, nrd, null);
			
			result = "true";
			log.info("setProtectedMetadata:result="+result);
			
			namespaceAccessToken.commit();
		} catch (NotSupportedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SystemException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalStateException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SecurityException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (HeuristicMixedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (HeuristicRollbackException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (RollbackException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ObjectNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (AccessDeniedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (LinkedObjectNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (RevisionDescriptorNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ObjectLockedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ServiceAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (VetoException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (RevisionNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return result;
		
	}// changeOwner
	
	
	/**
	 * Calculate and patch the resource DAV:quota-used-bytes metadata - resource consuming process !
	 * @param path path of the resource to process
	 * @return the resource DAV:quota-used-bytes metadata
	 */
	public String calculateQuotaUsedBytes(String path) {
		return calculateQuotaUsedBytes(path, true);
	}// calculateQuotaUsedBytes
	
	
	/**
	 * Calculate and patch the resource DAV:quota-used-bytes metadata - resource consuming process !
	 * @param path path of the resource to process
	 * @param commitNAT if true then does a namespaceAccessToken.commit() at the end of the function
	 * @return the resource DAV:quota-used-bytes metadata
	 */
	private String calculateQuotaUsedBytes(String path, boolean commitNAT) {
		
		String result = "0";
		int quotaUsedBytes = 0;
		boolean isCollection = false;
		
		log.info("calculateQuotaUsedBytes:path="+path+" commitNAT="+commitNAT);
		
		try {
			if (namespaceAccessToken.getStatus() != Status.STATUS_ACTIVE) namespaceAccessToken.begin();
			
			NodeRevisionDescriptors nrds = content.retrieve(token, path);
			NodeRevisionDescriptor nrd = content.retrieve(token, nrds);
			
			// getting the current ObjectNode
			ObjectNode currentObjectNode = structure.retrieve(token, path);
			
			// is it a collection ?
			NodeProperty tmpPropertyIsCollection = nrd.getProperty(NodeRevisionDescriptor.RESOURCE_TYPE);
			if (tmpPropertyIsCollection != null) {
				String _isCollection = tmpPropertyIsCollection.getValue().toString();
				isCollection = _isCollection.indexOf(QuotaConstants.TYPE_COLLECTION) != -1;
			}// if (tmpPropertyCollectionLength != null)
			
			// is it a virtual root ?
			NodeProperty nodeProperty = nrd.getProperty(QuotaConstants.VIRTUAL_ROOT, QuotaConstants.NAMESPACE_ESUP);
			String currentVirtualRoot;
			if (nodeProperty != null) {
				currentVirtualRoot = nodeProperty.getValue().toString();
			}// if (nodeProperty != null)
			else {
				currentVirtualRoot = "false";
			}// else (nodeProperty != null
			log.debug("calculateQuotaUsedBytes:currentVirtualRoot="+currentVirtualRoot);
			
			// if the current resource is a virtual root and if it is not the first time the function is called
			// (calculateQuotaUsedBytes called directly on a virtual root) then return 0
			if (currentVirtualRoot.equalsIgnoreCase("true") && !commitNAT) {
				return "0";
			}// if (!currentVirtualRoot.equalsIgnoreCase("true"))
			
			// getting the children of the current ObjectNode
			Enumeration childrenEnumeration = currentObjectNode.enumerateChildren();
			
			while (childrenEnumeration != null && childrenEnumeration.hasMoreElements()) {
				
				String childrenQuotaUsedBytes = null;
				
				String childrenUri = (String) childrenEnumeration.nextElement();
				log.debug("calculateQuotaUsedBytes:childrenUri="+childrenUri);
				
				childrenQuotaUsedBytes = calculateQuotaUsedBytes(childrenUri, false);
				log.debug("calculateQuotaUsedBytes:quotaUsedBytes for "+childrenUri+"="+childrenQuotaUsedBytes);									
				
				quotaUsedBytes += (Integer.decode(childrenQuotaUsedBytes)).intValue();
				
			}// while (childrenEnumeration.hasMoreElements()) {
			
			quotaUsedBytes += nrd.getContentLength();
			result = String.valueOf(quotaUsedBytes);
			
			// checking that the DAV:quota-available-bytes and DAV:quota-used-bytes are present and protected
			NodeProperty nodePropertyQAB = nrd.getProperty(QuotaConstants.QUOTA_USED_BYTES, QuotaConstants.NAMESPACE_DAV);
			NodeProperty nodePropertyQUB = nrd.getProperty(QuotaConstants.QUOTA_USED_BYTES, QuotaConstants.NAMESPACE_DAV);
			if (nodePropertyQAB == null) {
				log.debug("calculateQuotaUsedBytes:"+QuotaConstants.QUOTA_AVAILABLE_BYTES+" not present for "+path+" > do not calculate");
			}// if (nodePropertyQAB == null)
			else if (!nodePropertyQAB.isProtected()) {
				log.debug("calculateQuotaUsedBytes:"+QuotaConstants.QUOTA_AVAILABLE_BYTES+" not protected for "+path+"!!! > do not calculate");
			}// if (!nodePropertyQAB.isProtected())
			else if (nodePropertyQUB == null) {
				log.debug("calculateQuotaUsedBytes:"+QuotaConstants.QUOTA_USED_BYTES+" not present for "+path+" > do not calculate");
			}// if (nodePropertyQAB == null)
			else if (!nodePropertyQUB.isProtected()) {
				log.debug("calculateQuotaUsedBytes:"+QuotaConstants.QUOTA_USED_BYTES+" not protected for "+path+"!!! > do not calculate");
			}// if (!nodePropertyQAB.isProtected())		
			else {
				// patching the DAV:quota-used-bytes
				log.debug("calculateQuotaUsedBytes:updating "+QuotaConstants.QUOTA_USED_BYTES+" MD for "+path+" to "+result);
				nrd.setProperty(new NodeProperty(QuotaConstants.QUOTA_USED_BYTES, result, true));
				content.store(token, path, nrd, null);
			}// else (nodePropertyQAB == null)
			
			if (isCollection) {
				log.debug("calculateQuotaUsedBytes:updating "+QuotaConstants.NRD_COLLECTION_LENGTH+" MD for "+path+" to "+result);
				nrd.setProperty(new NodeProperty(QuotaConstants.NRD_COLLECTION_LENGTH, String.valueOf(result), QuotaConstants.NAMESPACE_ESUP, NodeRevisionDescriptor.COLLECTION_TYPE, true));
				content.store(token, path, nrd, null);
			}// if (isCollection)
			
			log.info("calculateQuotaUsedBytes:result="+result);
			
			if (commitNAT) namespaceAccessToken.commit();
		} catch (NotSupportedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SystemException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalStateException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SecurityException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (HeuristicMixedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (HeuristicRollbackException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (RollbackException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ObjectNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (AccessDeniedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (LinkedObjectNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (RevisionDescriptorNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ObjectLockedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ServiceAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (VetoException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (RevisionNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return result;
		
	}// calculateQuotaUsedBytes
	
	
	/**
	 * Set (and overwrite) the resource quota
	 * If calculateQuotaUsedBytes=true calculate the resource DAV:quota-used-bytes metadata
	 * If calculateQuotaUsedBytes=false and if the DAV:quota-used-bytes metadata does not exist, initializes it to zero
	 * If calculateQuotaUsedBytes=false and if the DAV:quota-used-bytes metadata already exists, does not overwrite it
	 * @param path path of the resource to process
	 * @param availableBytes the new DAV:quota-available-bytes metadata
	 * @param calculateQuotaUsedBytes if true calculate the DAV:quota-used-bytes metadata
	 * @return true if no error occured else false
	 */
	public String setQuota(String path, Long quota, Boolean calculateQuotaUsedBytes) {
		
		log.info("setQuota:path="+path+" quota="+quota+" calculateQuotaUsedBytes="+calculateQuotaUsedBytes);
						
		// we need to initialize the quota-used-bytes MD - required by the calculateQuotaUsedBytes method
		patchQuotaUsedBytes(path, new Long(0), new Boolean(true));
		
		String quotaUsedBytes ="0";
		if (calculateQuotaUsedBytes.booleanValue()) {
			quotaUsedBytes = calculateQuotaUsedBytes(path);
		}// if (calculateQuotaUsedBytes)
		log.debug("setQuota:quotaUsedBytes for "+path+" = "+quotaUsedBytes);
		
		long _quota = quota.longValue();
		long _quotaUsedBytes = Long.valueOf(quotaUsedBytes).longValue();
		long newQuotaAvailableBytes = _quota - _quotaUsedBytes;
		// NO !!
		//if (newQuotaAvailableBytes < 0) newQuotaAvailableBytes = 0;
		log.debug("setQuota:newQuotaAvailableBytes for "+path+" = "+newQuotaAvailableBytes);
				
		String resultpatchQAB = patchQuotaAvailableBytes(path, new Long(newQuotaAvailableBytes));
	
		String resultpatchQUB = patchQuotaUsedBytes(path, new Long(quotaUsedBytes), new Boolean(true));
		
		String resultcalculateQUB = "true";
				
		if (resultpatchQAB.equalsIgnoreCase("true") && resultpatchQUB.equalsIgnoreCase("true") && resultcalculateQUB.equalsIgnoreCase("true")) {
			return "true";
		}
		else {
			return "false";
		}// if (resultpatchQAB.equalsIgnoreCase("true") && resultpatchQUB.equalsIgnoreCase("true") && resultcalculateQUB.equalsIgnoreCase("true"))
		
	}// setQuota
	
	
	/**
	 * Set (and overwrite) the resource NAMESPACE:virtual-root metadata
	 * (Re)-calculate the DAV:quota-used-bytes metadata of the parent resources up to the root node or first vitual root :
	 * > Modified from "true" to "false" : quota-used-bytes(PR) = quota-used-bytes(PR) + quota-used-bytes(CR)
	 * > Modified from "false" to "true" : quota-used-bytes(PR) = quota-used-bytes(PR) - quota-used-bytes(CR)
	 * PR = parent resources
	 * CR = current resource 
	 * @param path path of the resource to process
	 * @param value the new DAV:virtual-root metadata
	 * @return true if no error occured else false
	 */
	public String setVirtualRoot(String path, String value) {
		
		String result = "false";
		
		log.info("setVirtualRoot:path="+path+" value="+value);
		
		try {
			if (namespaceAccessToken.getStatus() != Status.STATUS_ACTIVE) namespaceAccessToken.begin();// TODO necessary ?
						
			// getting the current virtual-root MD
			String currentVirtualRoot;
			
			NodeRevisionDescriptors nrds = content.retrieve(token, path);
			NodeRevisionDescriptor nrd = content.retrieve(token, nrds);
			
			NodeProperty nodePropertyQUB = nrd.getProperty(QuotaConstants.QUOTA_USED_BYTES, QuotaConstants.NAMESPACE_DAV);
			NodeProperty nodePropertyQAB = nrd.getProperty(QuotaConstants.QUOTA_AVAILABLE_BYTES, QuotaConstants.NAMESPACE_DAV);
			if (nodePropertyQUB == null || nodePropertyQAB == null) {
				log.debug("setVirtualRoot:"+QuotaConstants.QUOTA_USED_BYTES+" and-or "+QuotaConstants.QUOTA_AVAILABLE_BYTES+" property does not exist");
				log.debug("setVirtualRoot:Can not define the "+QuotaConstants.VIRTUAL_ROOT+" property");
				return "false";
			}// if (nodePropertyQUB == null || nodePropertyQAB == null)
			
			NodeProperty nodePropertyVR = nrd.getProperty(QuotaConstants.VIRTUAL_ROOT, QuotaConstants.NAMESPACE_ESUP);
			if (nodePropertyVR != null ) {
				currentVirtualRoot = nodePropertyVR.getValue().toString();
				log.debug("setVirtualRoot:currentVirtualRoot="+currentVirtualRoot);
			}// if (nodeProperty != null )
			else {
				log.debug("setVirtualRoot:"+QuotaConstants.VIRTUAL_ROOT+" property does not exist");
				currentVirtualRoot = "false";
			}//else (nodeProperty != null )
			
			// finding the operator
			String operator = null;
			
			if (currentVirtualRoot.equalsIgnoreCase(value)) {
				log.info("setVirtualRoot:"+QuotaConstants.VIRTUAL_ROOT+" from "+currentVirtualRoot+" to "+value+" > do nothing");
				namespaceAccessToken.commit();
				log.info("setVirtualRoot:result=true");
				return "true";
			}// if (value.equalsIgnoreCase(currentVirtualRoot))
			else if (currentVirtualRoot.equalsIgnoreCase("false") && value.equalsIgnoreCase("true")) {
				operator = QuotaConstants.SUBTRACT_QUOTA_USED_BYTES;
				log.debug("setVirtualRoot:"+QuotaConstants.VIRTUAL_ROOT+" from "+currentVirtualRoot+" to "+value+" > operator="+operator);
			}// if (currentVirtualRoot.equalsIgnoreCase("false") && value.equalsIgnoreCase("true"))
			else if (currentVirtualRoot.equalsIgnoreCase("true") && value.equalsIgnoreCase("false")) {
				operator = QuotaConstants.ADD_QUOTA_USED_BYTES;
				log.debug("setVirtualRoot:"+QuotaConstants.VIRTUAL_ROOT+" from "+currentVirtualRoot+" to "+value+" > operator="+operator);
			}// if (currentVirtualRoot.equalsIgnoreCase("false") && value.equalsIgnoreCase("true"))
						
			// setting the new virtual-root MD
			log.debug("setVirtualRoot:"+QuotaConstants.VIRTUAL_ROOT+"="+value);
			nrd.setProperty(new NodeProperty(QuotaConstants.VIRTUAL_ROOT, value, QuotaConstants.NAMESPACE_ESUP, "", true));
			content.store(token, path, nrd, null);
			
			// getting the current quota-used-bytes MD
			//NodeProperty nodePropertyQUB = nrd.getProperty(QuotaConstants.QUOTA_USED_BYTES, QuotaConstants.NAMESPACE_DAV);
			if (nodePropertyQUB == null) {// should never happened
				log.error("setVirtualRoot:"+QuotaConstants.QUOTA_USED_BYTES+" not present !");
				namespaceAccessToken.commit();
				log.error("setVirtualRoot:result=false");
				return "false";
			}// if (nodePropertyQUB == null)
			String currentQuotaUsedBytes = nodePropertyQUB.getValue().toString();
			log.debug("setVirtualRoot:currentQuotaUsedBytes="+currentQuotaUsedBytes);
			
			// updating quota-used-bytes for parents resources (up to the root node or first virtual root)
			// getting parent
			String parent = QuotaConstants.getParentUri(path);
			QuotaElement quotaElement = new QuotaElement(parent, this.token, this.content, currentQuotaUsedBytes);
			log.debug("setVirtualRoot:changing "+QuotaConstants.QUOTA_USED_BYTES+" MD for "+parent+" - operator="+operator);
			quotaElement.updateQuotaMetadata(operator, true);
			
			result = "true";
			log.info("setVirtualRoot:result="+result);
			
			namespaceAccessToken.commit();
		} catch (NotSupportedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SystemException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalStateException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SecurityException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (HeuristicMixedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (HeuristicRollbackException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (RollbackException e) {
			// TODO Auto-generated catch block
			e.printStackTrace(); 
		} catch (ObjectNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (AccessDeniedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (LinkedObjectNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (RevisionDescriptorNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ObjectLockedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ServiceAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (VetoException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (RevisionNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return result;
		
	}// setVirtualRoot
	
	
	/**
	 * Remove all of the resource quota metadata
	 * @param path resource to process
	 * @param processChildren if true process children resources
	 * @return true if no error occured else false
	 */
	public String removeQuota(String path, Boolean processChildren) {
		return removeQuota(path, processChildren, new Boolean(true));
	}// removeQuota
		
	
	/**
	 * Remove all of the resource quota MD
	 * @param path resource to process
	 * @param processChildren if true process children resources
	 * @param firstCall firstCall=true the first time the function is called and then false - needed for namespaceAccessToken.commit()
	 * @return true if no error occured else false
	 */
	private String removeQuota(String path, Boolean processChildren, Boolean firstCall) {
		
		String result = "false";
		
		log.info("removeQuota:path="+path);
		
		try {
			if (namespaceAccessToken.getStatus() != Status.STATUS_ACTIVE) namespaceAccessToken.begin();// TODO necessary ?
			
			NodeRevisionDescriptors nrds = content.retrieve(token, path);
			NodeRevisionDescriptor nrd = content.retrieve(token, nrds);
			NodeProperty nodePropertyVR = nrd.getProperty(QuotaConstants.VIRTUAL_ROOT, QuotaConstants.NAMESPACE_ESUP);
			NodeProperty nodePropertyQAB = nrd.getProperty(QuotaConstants.QUOTA_AVAILABLE_BYTES, QuotaConstants.NAMESPACE_DAV);
			NodeProperty nodePropertyQUB = nrd.getProperty(QuotaConstants.QUOTA_USED_BYTES, QuotaConstants.NAMESPACE_DAV);
			
			if (nodePropertyVR != null ) {
				log.debug("removeQuota:removing "+QuotaConstants.VIRTUAL_ROOT+" MD");
				nrd.removeProperty(nodePropertyVR);
			}// if (nodePropertyVR != null )
			if (nodePropertyQAB != null ) {
				log.debug("removeQuota:removing "+QuotaConstants.QUOTA_AVAILABLE_BYTES+" MD");
				nrd.removeProperty(nodePropertyQAB);
			}// if (nodePropertyQAB != null )
			if (nodePropertyQUB != null ) {
				log.debug("removeQuota:removing "+QuotaConstants.QUOTA_USED_BYTES+" MD");
				nrd.removeProperty(nodePropertyQUB);
			}// if (nodePropertyQUB != null )
			
			content.store(token, path, nrd, null);
			
			if (processChildren.booleanValue()){
				// getting the current ObjectNode
				ObjectNode currentObjectNode = structure.retrieve(token, path);
				
				// getting the children of the current ObjectNode
				Enumeration childrenEnumeration = currentObjectNode.enumerateChildren();
				
				while (childrenEnumeration != null && childrenEnumeration.hasMoreElements()) {
					String childrenUri = (String) childrenEnumeration.nextElement();
					log.debug("removeQuota:childrenUri="+childrenUri);
					removeQuota(childrenUri, new Boolean(true), new Boolean(false));
				}// while (childrenEnumeration != null && childrenEnumeration.hasMoreElements())
			}// if (processChildren.booleanValue())
			
			result = "true";
			log.info("removeQuota:result="+result);
			
			if (firstCall.booleanValue()) namespaceAccessToken.commit();
		} catch (NotSupportedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SystemException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalStateException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SecurityException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (HeuristicMixedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (HeuristicRollbackException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (RollbackException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ObjectNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (AccessDeniedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (LinkedObjectNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (RevisionDescriptorNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ObjectLockedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ServiceAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (VetoException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (RevisionNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return result;
	}// removeQuota
	
// ==== NOTES ====	
	
//	SlideToken systemToken = new SlideTokenWrapper(slideToken);
//	systemToken.setForceSecurity(false);
//	systemToken.setForceLock(false); 
	
	
//		Principal principal = new TestPrincipal("tbellemb");
//		CredentialsToken credentials = new CredentialsToken(principal);
//		SlideToken token = new SlideTokenImpl(credentials);
//		
//		 NamespaceAccessToken namespaceAccessToken = Domain.accessNamespace(new SecurityToken(""), Domain.getDefaultNamespace());
//		 token = new SlideTokenImpl(new CredentialsToken("tbellemb"));
//		 token.setForceStoreEnlistment(true);
//		 Structure structure = namespaceAccessToken.getStructureHelper();
//		 Content content = namespaceAccessToken.getContentHelper();
//		 namespaceAccessToken.begin();
		 
//		 Security security = namespaceAccessToken.getSecurityHelper();
//		 ObjectNode objectNode = structure.retrieve(token, "/files/quotas");
//		 result = objectNode.getUri();
//	     Enumeration e1 = objectNode.getChildren().elements();
//	     while (e1.hasMoreElements()) {
//			ObjectNode element = (ObjectNode) e1.nextElement();
//			result += " "+element.getUri();
//		}

		
//		System.out.println("1");
//		SimpleAuthenticationHandler simpleAuthenticationHandler = new SimpleAuthenticationHandler();
//		System.out.println("2");
//		MessageContext messageContext = new MessageContext(new AxisServer(new NullProvider()));
//		System.out.println("3");
//		System.out.println("--> "+messageContext.getUsername());
//		messageContext.setUsername("tbellemb");
//		messageContext.setPassword("trusted");
//		simpleAuthenticationHandler.invoke(messageContext);
//		
//		result = result +"-"+ messageContext.getUsername();
				
		
//		MessageContext mc = MessageContext.getCurrentContext();
//		HttpServletRequest httpServletRequest = ((HttpServletRequest)mc.getProperty(org.apache.axis.transport.http.HTTPConstants.MC_HTTP_SERVLETREQUEST));
//		result += " mc="+mc.getUsername();
//		result += " mc="+mc.getPassword();
//		result += " path="+httpServletRequest.getContextPath();
//		result += " requestURI="+httpServletRequest.getRequestURI();
		
//		result += " remoteUser="+httpServletRequest.getRemoteUser();
//		result += " userPrincipal="+httpServletRequest.getUserPrincipal().toString();
//		result += " host="+httpServletRequest.getRemoteHost();
		
		
//		} catch (Exception e){System.out.println("Exception handled !!"); e.printStackTrace();}
		
//	you need to be into a transaction to call create/store/retrieve method of 
//	Structure or Content.
//
//	[code]
//	NamespaceAccessToken nat;
//
//	...
//
//	Structure structure = nat.getStructureHelper();
//
//	nat.begin();
//	structure.create(slideToken, new SubjectNode("/content"), folder);
//	nat.commit();
//	[/code]
	
//Principal principal = request.getUserPrincipal();
//CredentialsToken credentials;
//if (principal == null) {
//	credentials = new CredentialsToken("");
//} else {
//	credentials = new CredentialsToken(principal);
//	}
//SlideToken token = new SlideTokenImpl(credentials);

//this.getClass().getResource("/quotaWSConfig.xml").toString()
}// QuotaWS
