/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.contract;

import java.io.InputStream;
import java.util.Map;
import org.apache.commons.contract.Context;
import org.apache.commons.contract.ContractViolationException;
import org.apache.commons.contract.EnvironmentConsumer;
import org.apache.commons.contract.Processor;
import org.apache.commons.contract.Result;
import org.apache.commons.contract.Store;
import org.apache.commons.contract.StoreException;
import org.apache.commons.contract.constraints.Constraints;
import org.apache.commons.contract.constraints.ValidationException;
import org.apache.commons.contract.descriptor.ParameterDescriptor;
import org.apache.commons.contract.descriptor.RequiredEnvironmentDescriptor;
import org.apache.commons.contract.descriptor.ResultDescriptor;
import org.apache.commons.contract.descriptor.ResultEntryDescriptor;
import org.apache.commons.i18n.LocalizedError;
import org.apache.commons.i18n.XMLMessageProvider;

public class Executor {
    public static void init() {
    }

    public static Result process(Processor processor, Map parameters, Context context) throws Exception {
        Executor.prepareValues(processor.getParameterDescriptors(), parameters, context);
        if (processor instanceof EnvironmentConsumer) {
            Executor.checkRequirements((EnvironmentConsumer)((Object)processor), context);
        }
        Result result = processor.process(parameters, context);
        Executor.validateResult(processor.getResultDescriptors(), result, context);
        return result;
    }

    public static void prepareValues(ParameterDescriptor[] parameterDescriptors, Map parameters, Context context) throws ContractViolationException {
        for (int i = 0; i < parameterDescriptors.length; ++i) {
            String parameterName = parameterDescriptors[i].getName();
            Object parameterValue = parameters.get(parameterName);
            Object preparedValue = Executor.prepareValue(parameterDescriptors[i], parameterValue, context);
            parameters.put(parameterName, preparedValue);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Object prepareValue(ParameterDescriptor parameterDescriptor, Object value, Context context) throws ContractViolationException {
        void var3_3;
        Object preparedValue;
        if (value == null) {
            if (parameterDescriptor.isRequired()) {
                throw new ContractViolationException(new LocalizedError("requiredParameterMissing", (Object[])new String[]{parameterDescriptor.getName()}));
            }
            preparedValue = parameterDescriptor.getDefaultValue();
        } else {
            try {
                preparedValue = parameterDescriptor.getConstraints().cast(value, context);
                parameterDescriptor.getConstraints().validate(preparedValue, context);
            }
            catch (ContractViolationException exception) {
                throw new ContractViolationException(new LocalizedError("invalidParameter", new Object[]{parameterDescriptor.getName()}), (Throwable)((Object)exception));
            }
        }
        return var3_3;
    }

    public static void checkRequirements(EnvironmentConsumer processor, Context context) throws ContractViolationException {
        RequiredEnvironmentDescriptor[] requirementDescriptor = processor.getRequiredEnvironmentDescriptors();
        for (int i = 0; i < requirementDescriptor.length; ++i) {
            Store store = context.getStore(requirementDescriptor[i].getStore());
            try {
                Object value = store.get(requirementDescriptor[i].getName(), context);
                if (value == null) {
                    if (requirementDescriptor[i].isRequired()) {
                        throw new ValidationException(new LocalizedError("requiredContextMissing", new Object[]{requirementDescriptor[i].getName(), requirementDescriptor[i].getStore()}));
                    }
                    value = requirementDescriptor[i].getDefaultValue();
                    store.put(requirementDescriptor[i].getName(), value, context);
                }
                Object castedValue = requirementDescriptor[i].getConstraints().cast(value, context);
                requirementDescriptor[i].getConstraints().validate(castedValue, context);
                if (castedValue == value) continue;
                store.put(requirementDescriptor[i].getName(), castedValue, context);
                continue;
            }
            catch (StoreException exception) {
                throw new ContractViolationException(new LocalizedError("storeUnaccessable", new Object[]{requirementDescriptor[i].getName(), requirementDescriptor[i].getStore()}));
            }
        }
    }

    public static void validateResult(ResultDescriptor[] resultDescriptors, Result result, Context context) throws ContractViolationException {
        ResultEntryDescriptor[] entryDescriptors = Executor.getResultDescriptorByState(resultDescriptors, result.getState()).getResultEntryDescriptors();
        Map resultEntries = result.getResultEntries();
        String name = null;
        Object value = null;
        try {
            for (int i = 0; i < entryDescriptors.length; ++i) {
                ResultEntryDescriptor entryDescriptor = entryDescriptors[i];
                name = entryDescriptor.getName();
                value = resultEntries.get(name);
                if (value == null) {
                    throw new ContractViolationException(new LocalizedError("missingResultEntry", (Object[])new String[]{name}));
                }
                Constraints constraints = entryDescriptor.getConstraints();
                if (constraints == null) {
                    throw new ContractViolationException(new LocalizedError("undefinedResultEntryConstraints", (Object[])new String[]{name}));
                }
                value = constraints.cast(value, context);
                entryDescriptor.getConstraints().validate(value, context);
                resultEntries.put(name, value);
            }
        }
        catch (ValidationException exception) {
            throw new ContractViolationException(new LocalizedError("invalidResultEntry", new Object[]{name, value}), (Throwable)((Object)exception));
        }
    }

    public static ResultDescriptor getResultDescriptorByState(ResultDescriptor[] resultDescriptors, String state) throws ContractViolationException {
        for (int i = 0; i < resultDescriptors.length; ++i) {
            if (!resultDescriptors[i].getStateDescriptor().getState().equals(state)) continue;
            return resultDescriptors[i];
        }
        throw new ContractViolationException(new LocalizedError("stateNotDefined", new Object[]{state}));
    }

    static {
        XMLMessageProvider.install((String)"contract/exceptions", (InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream("exceptions.xml"));
        XMLMessageProvider.install((String)"contract/constraints", (InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream("constraints.xml"));
    }
}

