/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.contract.constraints;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.contract.Context;
import org.apache.commons.contract.constraints.CastException;
import org.apache.commons.contract.constraints.Constraints;
import org.apache.commons.contract.constraints.Evaluatable;
import org.apache.commons.contract.constraints.Unconstrained;
import org.apache.commons.contract.constraints.ValidationException;
import org.apache.commons.i18n.LocalizedError;
import org.apache.commons.i18n.LocalizedText;

public class ArrayConstraints
implements Constraints {
    public static final ArrayConstraints UNCONSTRAINED = new ArrayConstraints();
    protected Constraints entryValueDescriptor;

    public ArrayConstraints() {
        this.entryValueDescriptor = Unconstrained.UNCONSTRAINED;
    }

    public ArrayConstraints(Constraints entryValueDescriptor) {
        this.entryValueDescriptor = entryValueDescriptor;
    }

    public void setEntryValueDescriptor(Constraints entryValueDescriptor) {
        this.entryValueDescriptor = entryValueDescriptor;
    }

    public Constraints getEntryValueDescriptor() {
        return this.entryValueDescriptor;
    }

    public Object cast(Object value, Context context) throws CastException {
        Object[] array = null;
        if (value instanceof String[]) {
            array = new Object[((String[])value).length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = this.entryValueDescriptor.cast(((String[])value)[i], context);
            }
        } else if (value instanceof List) {
            array = new Object[((List)value).size()];
            int counter = 0;
            Iterator i = ((List)value).iterator();
            while (i.hasNext()) {
                Object entry = i.next();
                if (entry instanceof Evaluatable) {
                    try {
                        entry = ((Evaluatable)entry).evaluate(context);
                    }
                    catch (Exception e) {
                        throw new CastException(new LocalizedError("evaluatingAnyFailed"), e);
                    }
                }
                array[counter] = this.entryValueDescriptor.cast(entry, context);
                ++counter;
            }
        } else if (value instanceof Object[]) {
            array = new Object[((Object[])value).length];
            for (int i = 0; i < array.length; ++i) {
                Object entry = ((Object[])value)[i];
                if (entry instanceof Evaluatable) {
                    try {
                        entry = ((Evaluatable)entry).evaluate(context);
                    }
                    catch (Exception e) {
                        throw new CastException(new LocalizedError("evaluatingAnyFailed"), e);
                    }
                }
                array[i] = this.entryValueDescriptor.cast(entry, context);
            }
        } else {
            throw new CastException(new LocalizedError("uncastableArray", new Object[]{value}));
        }
        return array;
    }

    public void validate(Object value, Context context) throws ValidationException {
        try {
            Object[] array = (Object[])value;
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == null) continue;
                this.entryValueDescriptor.validate(array[i], context);
            }
        }
        catch (ValidationException exception) {
            throw new ValidationException(new LocalizedError("invalidArrayEntry", new Object[]{value}), (Throwable)((Object)exception));
        }
    }

    public LocalizedText verboseConstraints() {
        if (this.entryValueDescriptor == Unconstrained.UNCONSTRAINED) {
            return new LocalizedText("unconstrainedArray");
        }
        LocalizedText verbosedEntryContrstaints = this.entryValueDescriptor.verboseConstraints();
        return new LocalizedText("constrainedArray", (Object[])new String[]{verbosedEntryContrstaints.getText()});
    }
}

