/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.contract.constraints;

import org.apache.commons.contract.Context;
import org.apache.commons.contract.constraints.CastException;
import org.apache.commons.contract.constraints.Constraints;
import org.apache.commons.contract.constraints.StringConstraints;
import org.apache.commons.contract.constraints.ValidationException;
import org.apache.commons.i18n.LocalizedError;
import org.apache.commons.i18n.LocalizedText;

public class BooleanConstraints
implements Constraints {
    public static final String TRUE = Boolean.toString(true);
    public static final String FALSE = Boolean.toString(false);

    public Object cast(Object value, Context context) throws CastException {
        if (value instanceof Boolean) {
            return value;
        }
        try {
            return Boolean.valueOf(StringConstraints.UNCONSTRAINED.cast(value, null).toString());
        }
        catch (CastException exception) {
            throw new CastException(new LocalizedError("uncastableBooleanValue", new Object[]{value}));
        }
    }

    public void validate(Object value, Context context) throws ValidationException {
    }

    public LocalizedText verboseConstraints() {
        return new LocalizedText("unconstrainedBoolean");
    }
}

