/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.contract.constraints;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.contract.Context;
import org.apache.commons.contract.constraints.CastException;
import org.apache.commons.contract.constraints.Constraints;
import org.apache.commons.contract.constraints.StringConstraints;
import org.apache.commons.contract.constraints.ValidationException;
import org.apache.commons.i18n.LocalizedError;
import org.apache.commons.i18n.LocalizedText;

public class DateConstraints
implements Constraints {
    public static final DateConstraints UNCONSTRAINED = new DateConstraints();
    protected boolean constrained;
    protected List allowedValues = new ArrayList();
    protected Date earliest;
    protected Date latest;
    protected String formatPattern;

    public DateConstraints() {
        this.constrained = false;
    }

    public DateConstraints(String formatPattern) {
        this.constrained = false;
        this.formatPattern = formatPattern;
    }

    public DateConstraints(Date earliest, Date latest) {
        this.constrained = true;
        this.earliest = earliest;
        this.latest = latest;
    }

    public boolean isConstrained() {
        return this.constrained;
    }

    public void setEarliest(Date earliest) {
        this.earliest = earliest;
    }

    public void setLatest(Date latest) {
        this.latest = latest;
    }

    public void setFormatPattern(String dateFormat) {
        this.formatPattern = dateFormat;
    }

    public Object cast(Object value, Context context) throws CastException {
        Date date = null;
        if (value instanceof Date) {
            return value;
        }
        try {
            String valueAsString = (String)StringConstraints.UNCONSTRAINED.cast(value, null);
            try {
                date = new Date(Long.valueOf(valueAsString));
            }
            catch (NumberFormatException exception) {
                try {
                    date = this.formatPattern == null ? DateFormat.getInstance().parse(valueAsString) : new SimpleDateFormat(this.formatPattern).parse(valueAsString);
                }
                catch (ParseException e) {
                    throw new CastException(new LocalizedError("uncastableDateValue", new Object[]{value}), e);
                }
            }
        }
        catch (CastException exception) {
            throw new CastException(new LocalizedError("uncastableDateValue", new Object[]{value}), (Throwable)((Object)exception));
        }
        return date;
    }

    public void validate(Object value, Context context) throws ValidationException {
        Date date = (Date)value;
        if (this.constrained && (date.after(this.latest) || date.before(this.earliest))) {
            throw new ValidationException(new LocalizedError("invalidDate", new Object[]{date, this.earliest, this.latest}));
        }
    }

    public LocalizedText verboseConstraints() {
        if (this.constrained) {
            return new LocalizedText("constrainedDateRange", new Object[]{this.earliest, this.latest});
        }
        return new LocalizedText("unconstrainedDate");
    }
}

