/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.contract.constraints;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.contract.Context;
import org.apache.commons.contract.constraints.CastException;
import org.apache.commons.contract.constraints.Constraints;
import org.apache.commons.contract.constraints.Evaluatable;
import org.apache.commons.contract.constraints.Unconstrained;
import org.apache.commons.contract.constraints.ValidationException;
import org.apache.commons.i18n.LocalizedError;
import org.apache.commons.i18n.LocalizedText;

public class ListConstraints
implements Constraints {
    protected Constraints entryValueDescriptor;

    public ListConstraints() {
        this.entryValueDescriptor = Unconstrained.UNCONSTRAINED;
    }

    public ListConstraints(Constraints entryValueDescriptor) {
        this.entryValueDescriptor = entryValueDescriptor;
    }

    public void setEntryValueDescriptor(Constraints entryValueDescriptor) {
        this.entryValueDescriptor = entryValueDescriptor;
    }

    public Constraints getEntryValueDescriptor() {
        return this.entryValueDescriptor;
    }

    public Object cast(Object value, Context context) throws CastException {
        ArrayList<Object> list = new ArrayList<Object>();
        if (value instanceof String[]) {
            for (int i = 0; i < ((String[])value).length; ++i) {
                list.add(this.entryValueDescriptor.cast(((String[])value)[i], context));
            }
        } else if (value instanceof List) {
            Iterator i = ((List)value).iterator();
            while (i.hasNext()) {
                Object entry = i.next();
                if (entry instanceof Evaluatable) {
                    try {
                        entry = ((Evaluatable)entry).evaluate(context);
                    }
                    catch (Exception e) {
                        throw new CastException(new LocalizedError("evaluatingAnyFailed"), e);
                    }
                }
                list.add(this.entryValueDescriptor.cast(entry, context));
            }
        } else if (value instanceof Object[]) {
            for (int i = 0; i < ((Object[])value).length; ++i) {
                Object entry = ((Object[])value)[i];
                if (entry instanceof Evaluatable) {
                    try {
                        entry = ((Evaluatable)entry).evaluate(context);
                    }
                    catch (Exception e) {
                        throw new CastException(new LocalizedError("evaluatingAnyFailed"), e);
                    }
                }
                list.add(this.entryValueDescriptor.cast(entry, context));
            }
        } else {
            throw new CastException(new LocalizedError("uncastableList", new Object[]{value}));
        }
        return list;
    }

    public void validate(Object value, Context context) throws ValidationException {
        try {
            List list = (List)value;
            Iterator i = list.iterator();
            while (i.hasNext()) {
                Object entry = i.next();
                if (entry == null) continue;
                this.entryValueDescriptor.validate(entry, context);
            }
        }
        catch (ValidationException exception) {
            throw new ValidationException(new LocalizedError("invalidListEntry", new Object[]{value}), (Throwable)((Object)exception));
        }
    }

    public LocalizedText verboseConstraints() {
        if (this.entryValueDescriptor == Unconstrained.UNCONSTRAINED) {
            return new LocalizedText("unconstrainedList");
        }
        LocalizedText verbosedEntryContrstaints = this.entryValueDescriptor.verboseConstraints();
        return new LocalizedText("constrainedList", (Object[])new String[]{verbosedEntryContrstaints.getText()});
    }
}

