/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.contract.constraints;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.contract.Context;
import org.apache.commons.contract.constraints.CastException;
import org.apache.commons.contract.constraints.Constraints;
import org.apache.commons.contract.constraints.Evaluatable;
import org.apache.commons.contract.constraints.Unconstrained;
import org.apache.commons.contract.constraints.ValidationException;
import org.apache.commons.contract.descriptor.ParameterDescriptor;
import org.apache.commons.contract.i18n.ParameterMessage;
import org.apache.commons.i18n.LocalizedError;
import org.apache.commons.i18n.LocalizedText;

public class MapConstraints
implements Constraints {
    public static final MapConstraints UNCONSTRAINED = new MapConstraints(new ParameterDescriptor("*", new ParameterMessage("mapEntry/any"), Unconstrained.UNCONSTRAINED));
    public static final String ALL = "*";
    protected List entryConstraints = new ArrayList();

    public MapConstraints() {
    }

    public MapConstraints(List entryDescriptors) {
        this.entryConstraints = entryDescriptors;
    }

    public MapConstraints(ParameterDescriptor parameterDescriptor) {
        this.entryConstraints.add(parameterDescriptor);
    }

    public MapConstraints(ParameterDescriptor[] parameterDescriptors) {
        for (int i = 0; i < parameterDescriptors.length; ++i) {
            this.entryConstraints.add(parameterDescriptors[i]);
        }
    }

    public void addEntryDescriptor(ParameterDescriptor parameterDescriptor) {
        this.entryConstraints.add(parameterDescriptor);
    }

    public List getEntryDescriptors() {
        return this.entryConstraints;
    }

    public Object cast(Object value, Context context) throws CastException {
        if (this.entryConstraints.isEmpty()) {
            throw new CastException(new LocalizedError("noMapEntryDescriptorsFound"));
        }
        if (value instanceof Map) {
            return this.castedMap((Map)value, context);
        }
        if (value instanceof Map) {
            return this.castedMap((Map)value, context);
        }
        throw new CastException(new LocalizedError("uncastableMapValue", new Object[]{value}));
    }

    protected Map castedMap(Map map, Context context) throws CastException {
        HashMap castedMap = new HashMap(map);
        Iterator i = this.entryConstraints.iterator();
        while (i.hasNext()) {
            ParameterDescriptor parameterDescriptor = (ParameterDescriptor)i.next();
            Constraints entryDescriptor = parameterDescriptor.getConstraints();
            String key = parameterDescriptor.getName();
            if (key.equals(ALL)) {
                Iterator j = castedMap.entrySet().iterator();
                while (j.hasNext()) {
                    Map.Entry entry = j.next();
                    Object value = entry.getValue();
                    if (value instanceof Evaluatable) {
                        try {
                            value = ((Evaluatable)value).evaluate(context);
                        }
                        catch (Exception e) {
                            throw new CastException(new LocalizedError("evaluatingAnyFailed"), e);
                        }
                    }
                    castedMap.put(entry.getKey(), entryDescriptor.cast(value, context));
                }
                continue;
            }
            if (!castedMap.containsKey(key)) {
                if (parameterDescriptor.isRequired()) continue;
                castedMap.put(key, parameterDescriptor.getDefaultValue());
                continue;
            }
            Object object = castedMap.get(key);
            if (object == null && parameterDescriptor.getDefaultValue() == null || object.equals(parameterDescriptor.getDefaultValue())) {
                castedMap.put(key, object);
                continue;
            }
            if (object instanceof Evaluatable) {
                try {
                    object = ((Evaluatable)object).evaluate(context);
                }
                catch (Exception e) {
                    throw new CastException(new LocalizedError("evaluatingAnyFailed"), e);
                }
            }
            castedMap.put(key, entryDescriptor.cast(object, context));
        }
        return castedMap;
    }

    public void validate(Object value, Context context) throws ValidationException {
        Map map = (Map)value;
        Iterator i = this.entryConstraints.iterator();
        while (i.hasNext()) {
            ParameterDescriptor parameterDescriptor = (ParameterDescriptor)i.next();
            Constraints entryDescriptor = parameterDescriptor.getConstraints();
            String key = parameterDescriptor.getName();
            if (key.equals(ALL)) {
                Iterator j = map.values().iterator();
                while (j.hasNext()) {
                    Object entryValue = j.next();
                    if (entryValue == null) continue;
                    entryDescriptor.validate(entryValue, context);
                }
                continue;
            }
            if (!map.containsKey(key)) {
                if (!parameterDescriptor.isRequired()) continue;
                throw new ValidationException(new LocalizedError("mapEntryMissing", (Object[])new String[]{key}));
            }
            Object entryValue = map.get(key);
            if (entryValue == null) continue;
            entryDescriptor.validate(entryValue, context);
        }
    }

    public LocalizedText verboseConstraints() {
        if (this.entryConstraints.isEmpty()) {
            return new LocalizedText("invalidMapConstraints");
        }
        return new LocalizedText("unconstrainedMap");
    }
}

