/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.contract.constraints;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.contract.Context;
import org.apache.commons.contract.constraints.CastException;
import org.apache.commons.contract.constraints.Constraints;
import org.apache.commons.contract.constraints.StringConstraints;
import org.apache.commons.contract.constraints.ValidationException;
import org.apache.commons.i18n.LocalizedError;
import org.apache.commons.i18n.LocalizedText;

public class NumberConstraints
implements Constraints {
    public static final NumberConstraints UNCONSTRAINED = new NumberConstraints();
    public static final NumberConstraints POSITIVE = new NumberConstraints(new Integer(0), null, false);
    public static final NumberConstraints NEGATIVE = new NumberConstraints(null, new Integer(0), false);
    protected boolean constrained;
    protected boolean inclusive;
    protected List allowedValues = new ArrayList();
    protected Number minimum;
    protected Number maximum;

    public NumberConstraints() {
        this.constrained = false;
    }

    public NumberConstraints(Number minimum, Number maximum) {
        this(minimum, maximum, true);
    }

    public NumberConstraints(Number minimum, Number maximum, boolean inclusive) {
        this.constrained = true;
        this.minimum = minimum;
        this.maximum = maximum;
        this.inclusive = inclusive;
    }

    public NumberConstraints(Number[] allowedValues) {
        this.constrained = true;
        this.allowedValues = new ArrayList<Number>(Arrays.asList(allowedValues));
    }

    public boolean isConstrained() {
        return this.constrained;
    }

    public void addAllowedValue(Number value) {
        this.allowedValues.add(value);
    }

    public Number[] getAllowedValues() {
        if (this.allowedValues.isEmpty()) {
            return null;
        }
        return this.allowedValues.toArray(new Number[0]);
    }

    public void setMinimum(Number minimum) {
        this.constrained = true;
        this.minimum = minimum;
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public void setMaximum(Number maximum) {
        this.constrained = true;
        this.maximum = maximum;
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public Object cast(Object value, Context context) throws CastException {
        if (value instanceof Number) {
            return (Number)value;
        }
        try {
            return new BigDecimal(StringConstraints.UNCONSTRAINED.cast(value, null).toString());
        }
        catch (NumberFormatException exception) {
            throw new CastException(new LocalizedError("uncastableNumber", new Object[]{value}), exception);
        }
        catch (CastException exception) {
            throw new CastException(new LocalizedError("uncastableNumber", new Object[]{value}), (Throwable)((Object)exception));
        }
    }

    public void validate(Object value, Context context) throws ValidationException {
        if (this.constrained) {
            Number number = (Number)value;
            if (this.getAllowedValues() != null) {
                Iterator i = this.allowedValues.iterator();
                while (i.hasNext()) {
                    Number allowedNumber = (Number)i.next();
                    if (!allowedNumber.equals(number)) continue;
                    return;
                }
                throw new ValidationException(new LocalizedError("invalidNumber", new Object[]{value}));
            }
            if (this.inclusive && this.minimum != null && this.minimum.doubleValue() > number.doubleValue()) {
                throw new ValidationException(new LocalizedError("numberMustBeGreater", new Object[]{number, this.minimum}));
            }
            if (!this.inclusive && this.minimum != null && this.minimum.doubleValue() >= number.doubleValue()) {
                throw new ValidationException(new LocalizedError("numberMustBeGreaterOrEqual", new Object[]{number, this.minimum}));
            }
            if (this.inclusive && this.maximum != null && this.maximum.doubleValue() < number.doubleValue()) {
                throw new ValidationException(new LocalizedError("numberMustBeLess", new Object[]{number, this.minimum}));
            }
            if (!this.inclusive && this.maximum != null && this.maximum.doubleValue() >= number.doubleValue()) {
                throw new ValidationException(new LocalizedError("numberMustBeLessOrEqual", new Object[]{number, this.minimum}));
            }
        }
    }

    public LocalizedText verboseConstraints() {
        if (this.constrained) {
            if (this.inclusive && this.maximum != null && this.minimum == null) {
                return new LocalizedText("lessOrEqual", new Object[]{this.maximum});
            }
            if (!this.inclusive && this.maximum != null && this.minimum == null) {
                return new LocalizedText("less", new Object[]{this.maximum});
            }
            if (this.inclusive && this.minimum != null && this.maximum == null) {
                return new LocalizedText("greaterOrEqual", new Object[]{this.minimum});
            }
            if (!this.inclusive && this.minimum != null && this.maximum == null) {
                return new LocalizedText("greater", new Object[]{this.minimum});
            }
            if (this.inclusive && this.maximum != null && this.minimum != null) {
                return new LocalizedText("rangeIncluding", new Object[]{this.minimum, this.maximum});
            }
            return new LocalizedText("rangeExcluding", new Object[]{this.minimum, this.maximum});
        }
        return new LocalizedText("numbers");
    }
}

