/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.contract.constraints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.contract.Context;
import org.apache.commons.contract.constraints.CastException;
import org.apache.commons.contract.constraints.Castable;
import org.apache.commons.contract.constraints.Constraints;
import org.apache.commons.contract.constraints.ValidationException;
import org.apache.commons.i18n.LocalizedError;
import org.apache.commons.i18n.LocalizedText;

public class StringConstraints
implements Constraints,
Castable {
    public static final StringConstraints UNCONSTRAINED = new StringConstraints();
    public static final StringConstraints EMPTY = new StringConstraints(0);
    public static final StringConstraints NOT_EMPTY = new StringConstraints(1, Integer.MAX_VALUE);
    protected boolean constrained;
    protected List allowedValues = new ArrayList();
    protected int minimumLength = -1;
    protected int maximumLength = -1;
    protected Object defaultValue;

    public StringConstraints() {
        this.constrained = false;
    }

    public StringConstraints(String[] allowedValues) {
        this.constrained = true;
        this.allowedValues = new ArrayList<String>(Arrays.asList(allowedValues));
    }

    public StringConstraints(int maximumLength) {
        this.maximumLength = maximumLength;
        this.constrained = true;
    }

    public StringConstraints(int minimumLength, int maximumLength) {
        this.minimumLength = minimumLength;
        this.maximumLength = maximumLength;
        this.constrained = true;
    }

    public int getMinimumLength() {
        return this.minimumLength;
    }

    public void setMinimumLength(int minimumLength) {
        this.minimumLength = minimumLength;
        this.constrained = true;
    }

    public int getMaximumLength() {
        return this.maximumLength;
    }

    public void setMaximumLength(int maximumLength) {
        this.maximumLength = maximumLength;
        this.constrained = true;
    }

    public void addAllowedValue(String value) {
        this.constrained = true;
        this.allowedValues.add(value);
    }

    public boolean isConstrained() {
        return this.constrained;
    }

    public boolean isEnumerable() {
        return this.allowedValues.size() > 0;
    }

    public String[] getAllowedValues() {
        return this.allowedValues.toArray(new String[0]);
    }

    public Object cast(Object value, Context context) throws CastException {
        if (value instanceof String) {
            return value;
        }
        if (value instanceof String[]) {
            return ((String[])value)[0];
        }
        return value.toString();
    }

    public void validate(Object value, Context context) throws ValidationException {
        if (this.constrained) {
            if (this.isEnumerable()) {
                Iterator i = this.allowedValues.iterator();
                while (i.hasNext()) {
                    if (!value.equals((String)i.next())) continue;
                    return;
                }
                throw new ValidationException(new LocalizedError("invalidString", (Object[])new String[]{(String)value, this.getEnumeratedValues()}));
            }
            if (this.minimumLength != -1 && ((String)value).length() < this.minimumLength) {
                throw new ValidationException(new LocalizedError("stringTooShort", new Object[]{new Integer(this.minimumLength)}));
            }
            if (this.maximumLength != -1 && ((String)value).length() > this.maximumLength) {
                throw new ValidationException(new LocalizedError("stringTooLong", new Object[]{new Integer(this.maximumLength)}));
            }
        }
    }

    public LocalizedText verboseConstraints() {
        if (this.constrained) {
            if (this.isEnumerable()) {
                return new LocalizedText("enumeratedStrings", new Object[]{this.getEnumeratedValues()});
            }
            if (this.minimumLength != -1 && this.maximumLength == -1) {
                return new LocalizedText("stringLengthBetween", new Object[]{new Integer(this.minimumLength), new Integer(this.maximumLength)});
            }
            if (this.minimumLength != -1) {
                return new LocalizedText("stringLengthGreater", new Object[]{new Integer(this.minimumLength)});
            }
            return new LocalizedText("stringLengthLess", new Object[]{new Integer(this.maximumLength)});
        }
        return new LocalizedText("strings");
    }

    private String getEnumeratedValues() {
        StringBuffer buffer = new StringBuffer(256);
        for (int i = 0; i < this.getAllowedValues().length; ++i) {
            if (i > 0 && i < this.getAllowedValues().length) {
                buffer.append(", ");
            }
            buffer.append(this.getAllowedValues()[i]);
        }
        return buffer.toString();
    }
}

