/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.contract.constraints;

import org.apache.commons.contract.Context;
import org.apache.commons.contract.constraints.ArrayConstraints;
import org.apache.commons.contract.constraints.CastException;
import org.apache.commons.contract.constraints.Constraints;
import org.apache.commons.contract.constraints.ValidationException;
import org.apache.commons.i18n.LocalizedText;

public class TreeConstraints
implements Constraints {
    private Constraints entryConstraints;
    private Constraints arrayConstraints;

    public TreeConstraints() {
        this.entryConstraints = null;
        this.arrayConstraints = new ArrayConstraints(this);
    }

    public TreeConstraints(Constraints entryValueDescriptor) {
        this.entryConstraints = entryValueDescriptor;
        this.arrayConstraints = new ArrayConstraints(this);
    }

    public Object cast(Object value, Context context) throws CastException {
        try {
            return this.arrayConstraints.cast(value, context);
        }
        catch (CastException exception) {
            return this.entryConstraints.cast(value, context);
        }
    }

    public void validate(Object value, Context context) throws ValidationException {
        if (value instanceof Object[]) {
            this.arrayConstraints.validate(value, context);
        } else {
            this.entryConstraints.validate(value, context);
        }
    }

    public LocalizedText verboseConstraints() {
        return new LocalizedText("booleansOnly");
    }
}

