/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.contract.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.apache.commons.contract.ContractViolationException;
import org.apache.commons.contract.Executor;
import org.apache.commons.contract.Processor;
import org.apache.commons.contract.Result;
import org.apache.commons.contract.context.VMContext;
import org.apache.commons.contract.descriptor.ParameterDescriptor;
import org.apache.commons.contract.i18n.ParameterMessage;
import org.apache.commons.contract.util.MainWrapper;

public class InteractiveMainWrapper
extends MainWrapper {
    public static Result main(String[] args, Processor processor) {
        Executor.init();
        InteractiveMainWrapper.printUsage(processor);
        VMContext context = new VMContext();
        ParameterDescriptor[] parameterDescriptors = processor.getParameterDescriptors();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        for (int i = 0; i < parameterDescriptors.length; ++i) {
            Object value = null;
            do {
                System.out.print(parameterDescriptors[i].getName() + " - ");
                InteractiveMainWrapper.printParameterInfo(parameterDescriptors[i]);
                System.out.print(((ParameterMessage)parameterDescriptors[i].getDescription()).getPrompt());
                try {
                    String userInput = in.readLine();
                    value = Executor.prepareValue(parameterDescriptors[i], userInput, context);
                }
                catch (IOException e) {
                    value = null;
                }
                catch (ContractViolationException e) {
                    InteractiveMainWrapper.printException(e);
                    value = null;
                }
            } while (value == null);
            parameters.put(parameterDescriptors[i].getName(), value);
        }
        try {
            Result result = Executor.process(processor, parameters, context);
            InteractiveMainWrapper.printInformations(context.getInformations());
            return result;
        }
        catch (ContractViolationException exception) {
            InteractiveMainWrapper.printException(exception);
            System.out.println();
            InteractiveMainWrapper.printUsage(processor);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }
}

