/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.contract.util;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.contract.ContractViolationException;
import org.apache.commons.contract.Executor;
import org.apache.commons.contract.Information;
import org.apache.commons.contract.Processor;
import org.apache.commons.contract.Result;
import org.apache.commons.contract.context.VMContext;
import org.apache.commons.contract.descriptor.ParameterDescriptor;
import org.apache.commons.i18n.LocalizedException;
import org.apache.commons.i18n.LocalizedMessage;
import org.apache.commons.i18n.XMLMessageProvider;

public class MainWrapper {
    private static LocalizedMessage usage;

    public static Result main(String[] args, Processor processor) {
        VMContext context = new VMContext();
        ParameterDescriptor[] parameterDescriptors = processor.getParameterDescriptors();
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (int i = 0; i < parameterDescriptors.length; ++i) {
            if (i >= args.length) continue;
            parameters.put(parameterDescriptors[i].getName(), args[i]);
        }
        try {
            return Executor.process(processor, parameters, context);
        }
        catch (ContractViolationException exception) {
            System.out.println(exception.getErrorMessage().getTitle());
            System.out.print(exception.getErrorMessage().getDetails());
            Object throwable = exception;
            while (((Throwable)throwable).getCause() != null) {
                if ((throwable = ((Throwable)throwable).getCause()) instanceof LocalizedException) {
                    System.out.print(" " + ((LocalizedException)throwable).getErrorMessage().getDetails());
                    continue;
                }
                System.out.print(" " + ((Throwable)throwable).getMessage());
            }
            System.out.println();
            System.out.println();
            MainWrapper.printUsage(processor);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static void printUsage(Processor processor) {
        System.out.println(usage.getTitle());
        System.out.println(usage.getText());
        ParameterDescriptor[] parameterDescriptors = processor.getParameterDescriptors();
        for (int i = 0; i < parameterDescriptors.length; ++i) {
            System.out.print(i + 1 + ". ");
            MainWrapper.printParameterInfo(parameterDescriptors[i]);
        }
    }

    public static void printParameterInfo(ParameterDescriptor parameterDescriptor) {
        System.out.println(parameterDescriptor.getDescription().getTitle());
        System.out.println(parameterDescriptor.getDescription().getText());
        System.out.println(parameterDescriptor.getConstraints().verboseConstraints().getText());
    }

    public static void printException(ContractViolationException exception) {
        System.out.println(exception.getErrorMessage().getTitle());
        System.out.print(exception.getErrorMessage().getDetails());
        Object throwable = exception;
        while (((Throwable)throwable).getCause() != null) {
            if ((throwable = ((Throwable)throwable).getCause()) instanceof LocalizedException) {
                System.out.print(" " + ((LocalizedException)throwable).getErrorMessage().getDetails());
                continue;
            }
            System.out.print(" " + ((Throwable)throwable).getMessage());
        }
        System.out.println();
    }

    public static void printInformations(List informations) {
        Iterator i = informations.iterator();
        while (i.hasNext()) {
            Information information = (Information)i.next();
            System.out.println("Folgendes: " + information.getLocalizedError().getText());
        }
    }

    static {
        XMLMessageProvider.install((String)"contract/util", (InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream("util.xml"));
        usage = new LocalizedMessage("usage");
    }
}

