/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.i18n;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.i18n.MessageNotFoundException;
import org.apache.commons.i18n.MessageProvider;
import org.apache.commons.i18n.ResourceBundleMessageProvider;
import org.apache.commons.i18n.XMLMessageProvider;

public class MessageManager {
    private static List messageProviders = new ArrayList();

    public static void addMessageProvider(MessageProvider messageProvider) {
        messageProviders.add(messageProvider);
    }

    public static String getText(String id, String entry, Object[] arguments, Locale locale) throws MessageNotFoundException {
        MessageNotFoundException exception = null;
        Iterator i = messageProviders.iterator();
        while (i.hasNext()) {
            try {
                String text = ((MessageProvider)i.next()).getText(id, entry, locale);
                return MessageFormat.format(text, arguments);
            }
            catch (MessageNotFoundException e) {
                exception = e;
            }
        }
        throw exception;
    }

    public static String getText(String id, String entry, Object[] arguments, Locale locale, String defaultText) {
        try {
            String text = MessageManager.getText(id, entry, arguments, locale);
            return MessageFormat.format(text, arguments);
        }
        catch (MessageNotFoundException e) {
            return defaultText;
        }
    }

    public static Map getEntries(String id, Locale locale) throws MessageNotFoundException {
        MessageNotFoundException exception = null;
        Iterator i = messageProviders.iterator();
        while (i.hasNext()) {
            try {
                Map entries = ((MessageProvider)i.next()).getEntries(id, locale);
                return entries;
            }
            catch (MessageNotFoundException e) {
                exception = e;
            }
        }
        throw exception;
    }

    static {
        messageProviders.add(new XMLMessageProvider());
        messageProviders.add(new ResourceBundleMessageProvider());
    }
}

