/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.i18n;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.i18n.MessageNotFoundException;
import org.apache.commons.i18n.MessageProvider;

public class ResourceBundleMessageProvider
implements MessageProvider {
    private static Logger logger = Logger.getLogger((class$org$apache$commons$i18n$ResourceBundleMessageProvider == null ? (class$org$apache$commons$i18n$ResourceBundleMessageProvider = ResourceBundleMessageProvider.class$("org.apache.commons.i18n.ResourceBundleMessageProvider")) : class$org$apache$commons$i18n$ResourceBundleMessageProvider).getName());
    private static List installedResourceBundles = new ArrayList();
    static /* synthetic */ Class class$org$apache$commons$i18n$ResourceBundleMessageProvider;

    public String getText(String id, String entry, Locale locale) throws MessageNotFoundException {
        Object text = null;
        Iterator i = installedResourceBundles.iterator();
        while (i.hasNext()) {
            String baseName = (String)i.next();
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(baseName, locale);
                try {
                    return resourceBundle.getString(id + "." + entry);
                }
                catch (ClassCastException e) {
                }
                catch (MissingResourceException e) {
                }
            }
            catch (MissingResourceException e) {
                logger.log(Level.WARNING, "Could not find resource bundle with base name '" + baseName + "', uninstalling it...");
                i.remove();
            }
        }
        throw new MessageNotFoundException("Message with id " + id + " not found");
    }

    public Map getEntries(String id, Locale locale) {
        String messageIdentifier = id + ".";
        HashMap<String, String> entries = null;
        Iterator i = installedResourceBundles.iterator();
        while (i.hasNext()) {
            String baseName = (String)i.next();
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(baseName, locale);
                Enumeration<String> keys = resourceBundle.getKeys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    if (!key.startsWith(messageIdentifier)) continue;
                    if (entries == null) {
                        entries = new HashMap<String, String>();
                    }
                    entries.put(key.substring(messageIdentifier.length()), resourceBundle.getString(key));
                }
            }
            catch (MissingResourceException e) {
                logger.log(Level.WARNING, "Could not find resource bundle with base name '" + baseName + "', uninstalling it...");
                i.remove();
            }
        }
        if (entries == null) {
            throw new MessageNotFoundException("No entries found for message with id " + id);
        }
        return entries;
    }

    public static void install(String baseName) {
        logger.log(Level.FINE, "Installing bundle with base name '" + baseName + "'");
        installedResourceBundles.add(baseName);
    }

    public static void uninstall(String baseName) {
        logger.log(Level.FINE, "Uninstalling bundle with base name '" + baseName + "'");
        installedResourceBundles.remove(baseName);
    }

    public static void update(String baseName) {
        ResourceBundleMessageProvider.uninstall(baseName);
        ResourceBundleMessageProvider.install(baseName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

