/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.i18n;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.i18n.MessageNotFoundException;
import org.apache.commons.i18n.MessageProvider;
import org.apache.commons.xmlio.in.DefaultSimpleImportHandler;
import org.apache.commons.xmlio.in.SimpleImportHandler;
import org.apache.commons.xmlio.in.SimpleImporter;
import org.apache.commons.xmlio.in.SimplePath;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.AttributesImpl;

public class XMLMessageProvider
implements MessageProvider {
    private static Logger logger = Logger.getLogger((class$org$apache$commons$i18n$XMLMessageProvider == null ? (class$org$apache$commons$i18n$XMLMessageProvider = XMLMessageProvider.class$("org.apache.commons.i18n.XMLMessageProvider")) : class$org$apache$commons$i18n$XMLMessageProvider).getName());
    private static Map installedMessages = new HashMap();
    private static Map messages = new HashMap();
    static /* synthetic */ Class class$org$apache$commons$i18n$XMLMessageProvider;

    public String getText(String id, String entry, Locale locale) throws MessageNotFoundException {
        Message message = XMLMessageProvider.findMessage(id, locale);
        return message.getEntry(entry);
    }

    public Map getEntries(String id, Locale locale) throws MessageNotFoundException {
        Message message = XMLMessageProvider.findMessage(id, locale);
        return message.getEntries();
    }

    public static void install(String id, InputStream inputStream) {
        logger.log(Level.FINE, "Installing messages '" + id + "'");
        try {
            HashMap applicationMessages = new HashMap();
            SimpleImporter importer = new SimpleImporter();
            importer.setIncludeLeadingCDataIntoStartElementCallback(true);
            ConfigurationHandler handler = new ConfigurationHandler();
            importer.addSimpleImportHandler((SimpleImportHandler)handler);
            importer.parse(new InputSource(inputStream));
            Map parsedMessages = handler.getMessages();
            applicationMessages.putAll(parsedMessages);
            messages.putAll(applicationMessages);
            installedMessages.put(id, applicationMessages.keySet());
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Error while parsing messages", exception);
        }
    }

    public static void uninstall(String id) {
        logger.log(Level.FINE, "Uninstalling messages '" + id + "'");
        Collection messageKeys = (Collection)installedMessages.get(id);
        Iterator i = messageKeys.iterator();
        while (i.hasNext()) {
            String messageKey = (String)i.next();
            messages.remove(messageKey);
            logger.log(Level.FINE, "Removing message with key '" + messageKey + "'");
        }
        installedMessages.remove(id);
    }

    public static void update(String id, InputStream inputStream) {
        XMLMessageProvider.uninstall(id);
        XMLMessageProvider.install(id, inputStream);
    }

    private static Message findMessage(String id, Locale locale) {
        Message message = XMLMessageProvider.lookupMessage(id, locale);
        if (message == null) {
            message = XMLMessageProvider.lookupMessage(id, Locale.getDefault());
        }
        if (message == null) {
            throw new MessageNotFoundException("Message with id " + id + " not found");
        }
        return message;
    }

    private static Message lookupMessage(String id, Locale locale) {
        String key;
        StringBuffer keyBuffer = new StringBuffer(64);
        keyBuffer.append(id);
        if (locale.getLanguage() != null) {
            keyBuffer.append("_" + locale.getLanguage());
        }
        if (locale.getCountry() != null) {
            keyBuffer.append("_" + locale.getCountry());
        }
        if (locale.getVariant() != null) {
            keyBuffer.append("_" + locale.getVariant());
        }
        if (messages.containsKey(key = keyBuffer.toString())) {
            return (Message)messages.get(key);
        }
        while (key.lastIndexOf(95) > 0) {
            if (!messages.containsKey(key = key.substring(0, key.lastIndexOf(95)))) continue;
            return (Message)messages.get(key);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class Message {
        private String id;
        private String language;
        private String country;
        private String variant;
        private Map entries = new HashMap();

        public Message(String id) {
            this.id = id;
        }

        public void addEntry(String key, String value) {
            this.entries.put(key, value);
        }

        public String getEntry(String key) {
            return (String)this.entries.get(key);
        }

        public Map getEntries() {
            return this.entries;
        }

        public void setLanguage(String language) {
            this.language = language;
        }

        public void setCountry(String country) {
            this.country = country;
        }

        public void setVariant(String variant) {
            this.variant = variant;
        }

        public String getKey() {
            StringBuffer key = new StringBuffer(64);
            key.append(this.id);
            if (this.language != null) {
                key.append("_" + this.language);
            }
            if (this.country != null) {
                key.append("_" + this.country);
            }
            if (this.variant != null) {
                key.append("_" + this.variant);
            }
            return key.toString();
        }
    }

    static class ConfigurationHandler
    extends DefaultSimpleImportHandler {
        private Map messages = new HashMap();
        private String id;
        private Message message;

        ConfigurationHandler() {
        }

        public void startElement(SimplePath path, String name, AttributesImpl attributes, String leadingCDdata) {
            if (path.matches("message")) {
                this.id = attributes.getValue("id");
            } else if (path.matches("message/locale")) {
                this.message = new Message(this.id);
                this.message.setLanguage(attributes.getValue("language"));
                this.message.setCountry(attributes.getValue("country"));
                this.message.setVariant(attributes.getValue("variant"));
            } else if (path.matches("message/locale/entry")) {
                String key = attributes.getValue("key");
                this.message.addEntry(key, leadingCDdata);
            }
        }

        public void endElement(SimplePath path, String name) {
            if (path.matches("message/locale")) {
                this.messages.put(this.message.getKey(), this.message);
            }
        }

        Map getMessages() {
            return this.messages;
        }
    }
}

