/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.blocking;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import net.sf.ehcache.constructs.blocking.UpdatingCacheEntryFactory;

public class SelfPopulatingCollectionCache
extends SelfPopulatingCache {
    public SelfPopulatingCollectionCache(String name, CacheEntryFactory factory) throws CacheException {
        super(name, factory);
        if (!(factory instanceof UpdatingCacheEntryFactory)) {
            throw new IllegalArgumentException("The factory must be an instance of UpdatingCacheEntryFactory");
        }
    }

    public void put(Serializable key, Serializable value) throws IllegalArgumentException {
        if (!(value instanceof Collection)) {
            throw new IllegalArgumentException("value must be an instance of Collection");
        }
        super.put(key, value);
    }

    public Serializable get(Serializable key) throws CacheException, ClassCastException {
        Collection collection = (Collection)((Object)super.get(key));
        return (Serializable)((Object)Collections.unmodifiableCollection(collection));
    }
}

