/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Document;

public class Transform {
    private final Source inputSource;
    private final Transformer transformer;

    public Transform(String string, String string2) throws TransformerConfigurationException {
        this(new StringReader(string), new StringReader(string2));
    }

    public Transform(String string, File file) throws TransformerConfigurationException, FileNotFoundException {
        this(new StringReader(string), new FileReader(file));
    }

    public Transform(DOMSource dOMSource) throws TransformerConfigurationException {
        this.inputSource = dOMSource;
        this.transformer = this.getIdentityTransform();
    }

    private Transform(Reader reader, Reader reader2) throws TransformerConfigurationException {
        this.inputSource = new StreamSource(reader);
        this.transformer = this.getTransformer(new StreamSource(reader2));
    }

    private Transformer getIdentityTransform() throws TransformerConfigurationException {
        return this.getTransformer(null);
    }

    private Transformer getTransformer(Source source) throws TransformerConfigurationException {
        TransformerFactory transformerFactory = XMLUnit.getTransformerFactory();
        if (source == null) {
            return transformerFactory.newTransformer();
        }
        return transformerFactory.newTransformer(source);
    }

    protected void transformTo(Result result) throws TransformerException {
        this.transformer.transform(this.inputSource, result);
    }

    public String getResultString() throws TransformerException {
        StringWriter stringWriter = new StringWriter();
        this.transformTo(new StreamResult(stringWriter));
        return stringWriter.toString();
    }

    public Document getResultDocument() throws TransformerException {
        DOMResult dOMResult = new DOMResult();
        this.transformTo(dOMResult);
        return (Document)dOMResult.getNode();
    }

    public void setOutputProperty(String string, String string2) {
        Properties properties = new Properties();
        properties.setProperty(string, string2);
        this.setOutputProperties(properties);
    }

    public void setOutputProperties(Properties properties) {
        this.transformer.setOutputProperties(properties);
    }
}

