/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.custommonkey.xmlunit.Diff;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLUnit {
    private static DocumentBuilderFactory controlBuilderFactory;
    private static DocumentBuilderFactory testBuilderFactory;
    private static TransformerFactory transformerFactory;
    private static boolean ignoreWhitespace;

    private XMLUnit() {
    }

    public static void setControlParser(String string) throws FactoryConfigurationError {
        System.setProperty("javax.xml.parsers.DocumentBuilderFactory", string);
        controlBuilderFactory = DocumentBuilderFactory.newInstance();
    }

    public static DocumentBuilder getControlParser() throws ParserConfigurationException {
        if (controlBuilderFactory == null) {
            controlBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        return controlBuilderFactory.newDocumentBuilder();
    }

    public static void setTestParser(String string) throws FactoryConfigurationError {
        System.setProperty("javax.xml.parsers.DocumentBuilderFactory", string);
        testBuilderFactory = DocumentBuilderFactory.newInstance();
    }

    public static DocumentBuilder getTestParser() throws ParserConfigurationException {
        if (testBuilderFactory == null) {
            testBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        return testBuilderFactory.newDocumentBuilder();
    }

    public static void setIgnoreWhitespace(boolean bl) {
        ignoreWhitespace = bl;
    }

    public static boolean getIgnoreWhitespace() {
        return ignoreWhitespace;
    }

    public static Diff compare(Reader reader, Reader reader2) throws SAXException, IOException, ParserConfigurationException {
        return new Diff(reader, reader2);
    }

    public static Diff compare(String string, Reader reader) throws SAXException, IOException, ParserConfigurationException {
        return new Diff(new StringReader(string), reader);
    }

    public static Diff compare(Reader reader, String string) throws SAXException, IOException, ParserConfigurationException {
        return new Diff(reader, new StringReader(string));
    }

    public static Diff compare(String string, String string2) throws SAXException, IOException, ParserConfigurationException {
        return new Diff(string, string2);
    }

    public static Document buildControlDocument(String string) throws SAXException, IOException, ParserConfigurationException {
        return XMLUnit.buildDocument(XMLUnit.getControlParser(), new StringReader(string));
    }

    public static Document buildTestDocument(String string) throws SAXException, IOException, ParserConfigurationException {
        return XMLUnit.buildDocument(XMLUnit.getTestParser(), new StringReader(string));
    }

    protected static Document buildDocument(DocumentBuilder documentBuilder, Reader reader) throws SAXException, IOException {
        return documentBuilder.parse(new InputSource(reader));
    }

    public static void setTransformerFactory(String string) throws TransformerFactoryConfigurationError {
        System.setProperty("javax.xml.transform.TransformerFactory", string);
        transformerFactory = null;
        XMLUnit.getTransformerFactory();
    }

    public static TransformerFactory getTransformerFactory() throws TransformerFactoryConfigurationError {
        if (transformerFactory == null) {
            transformerFactory = TransformerFactory.newInstance();
        }
        return transformerFactory;
    }

    public static void setSAXParserFactory(String string) {
        System.setProperty("javax.xml.parsers.SAXParserFactory", string);
        XMLUnit.getSAXParserFactory();
    }

    public static SAXParserFactory getSAXParserFactory() {
        return SAXParserFactory.newInstance();
    }

    public static String getVersion() {
        return "0.5";
    }

    static {
        ignoreWhitespace = false;
    }
}

