/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text.regex;

import java.util.Vector;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Substitution;

public final class Util {
    public static final int SUBSTITUTE_ALL = -1;
    public static final int SPLIT_ALL = 0;

    private Util() {
    }

    public static Vector split(PatternMatcher patternMatcher, Pattern pattern, String string) {
        return Util.split(patternMatcher, pattern, string, 0);
    }

    public static Vector split(PatternMatcher patternMatcher, Pattern pattern, String string, int n) {
        Vector<String> vector = new Vector<String>(20);
        PatternMatcherInput patternMatcherInput = new PatternMatcherInput(string);
        int n2 = 0;
        while (--n != 0 && patternMatcher.contains(patternMatcherInput, pattern)) {
            MatchResult matchResult = patternMatcher.getMatch();
            vector.addElement(string.substring(n2, matchResult.beginOffset(0)));
            n2 = matchResult.endOffset(0);
        }
        vector.addElement(string.substring(n2, string.length()));
        return vector;
    }

    public static String substitute(PatternMatcher patternMatcher, Pattern pattern, Substitution substitution, String string) {
        return Util.substitute(patternMatcher, pattern, substitution, string, 1);
    }

    public static String substitute(PatternMatcher patternMatcher, Pattern pattern, Substitution substitution, String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        PatternMatcherInput patternMatcherInput = new PatternMatcherInput(string);
        int n2 = 0;
        int n3 = 0;
        while (n != 0 && patternMatcher.contains(patternMatcherInput, pattern)) {
            --n;
            MatchResult matchResult = patternMatcher.getMatch();
            stringBuffer.append(string.substring(n3, matchResult.beginOffset(0)));
            substitution.appendSubstitution(stringBuffer, matchResult, ++n2, string, patternMatcher, pattern);
            n3 = matchResult.endOffset(0);
        }
        if (n2 == 0) {
            return string;
        }
        stringBuffer.append(string.substring(n3, string.length()));
        return stringBuffer.toString();
    }
}

