/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.log4j.Logger;
import org.pdfbox.cos.COSDocument;
import org.pdfbox.encryption.DecryptDocument;
import org.pdfbox.exceptions.InvalidPasswordException;
import org.pdfbox.pdfparser.PDFParser;
import org.pdfbox.util.PDFTextStripper;

public class ExtractText {
    private static final Logger LOG = Logger.getLogger((Class)(class$org$pdfbox$ExtractText == null ? (class$org$pdfbox$ExtractText = ExtractText.class$("org.pdfbox.ExtractText")) : class$org$pdfbox$ExtractText));
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static final String PASSWORD = "-password";
    private static final String ENCODING = "-encoding";
    private static final String CONSOLE = "-console";
    private static final String START_PAGE = "-startPage";
    private static final String END_PAGE = "-endPage";
    static /* synthetic */ Class class$org$pdfbox$ExtractText;

    public static void main(String[] args) throws Exception {
        COSDocument document;
        Writer output;
        block30: {
            boolean toConsole = false;
            boolean currentArgumentIndex = false;
            String password = "";
            String encoding = DEFAULT_ENCODING;
            PDFTextStripper stripper = new PDFTextStripper();
            String pdfFile = null;
            String textFile = null;
            int startPage = 1;
            int endPage = Integer.MAX_VALUE;
            int i = 0;
            while (i < args.length) {
                if (args[i].equals(PASSWORD)) {
                    if (++i >= args.length) {
                        ExtractText.usage();
                    }
                    password = args[i];
                } else if (args[i].equals(ENCODING)) {
                    if (++i >= args.length) {
                        ExtractText.usage();
                    }
                    encoding = args[i];
                } else if (args[i].equals(START_PAGE)) {
                    if (++i >= args.length) {
                        ExtractText.usage();
                    }
                    startPage = Integer.parseInt(args[i]);
                } else if (args[i].equals(END_PAGE)) {
                    if (++i >= args.length) {
                        ExtractText.usage();
                    }
                    endPage = Integer.parseInt(args[i]);
                } else if (args[i].equals(CONSOLE)) {
                    toConsole = true;
                } else if (pdfFile == null) {
                    pdfFile = args[i];
                } else {
                    textFile = args[i];
                }
                ++i;
            }
            if (pdfFile == null) {
                ExtractText.usage();
            }
            if (textFile == null && pdfFile.length() > 4) {
                textFile = pdfFile.substring(0, pdfFile.length() - 4) + ".txt";
            }
            FileInputStream input = null;
            output = null;
            document = null;
            try {
                input = new FileInputStream(pdfFile);
                long start = System.currentTimeMillis();
                document = ExtractText.parseDocument(input);
                long stop = System.currentTimeMillis();
                LOG.info((Object)("Time to parse time=" + (stop - start)));
                if (document.isEncrypted()) {
                    try {
                        DecryptDocument decryptor = new DecryptDocument(document);
                        decryptor.decryptDocument(password);
                    }
                    catch (InvalidPasswordException e) {
                        if (args.length == 4) {
                            System.err.println("Error: The supplied password is incorrect.");
                            System.exit(2);
                        }
                        System.err.println("Error: The document is encrypted.");
                        ExtractText.usage();
                    }
                }
                output = toConsole ? new OutputStreamWriter(System.out) : new OutputStreamWriter((OutputStream)new FileOutputStream(textFile), encoding);
                start = System.currentTimeMillis();
                stripper.setStartPage(startPage);
                stripper.setEndPage(endPage);
                stripper.writeText(document, output);
                stop = System.currentTimeMillis();
                LOG.info((Object)("Time to extract text time=" + (stop - start)));
                Object var20_18 = null;
                if (input == null) break block30;
            }
            catch (Throwable throwable) {
                Object var20_19 = null;
                if (input != null) {
                    ((InputStream)input).close();
                }
                if (output != null) {
                    output.close();
                }
                if (document != null) {
                    document.close();
                }
                throw throwable;
            }
            ((InputStream)input).close();
        }
        if (output != null) {
            output.close();
        }
        if (document != null) {
            document.close();
        }
    }

    private static COSDocument parseDocument(InputStream input) throws IOException {
        PDFParser parser = new PDFParser(input);
        parser.parse();
        return parser.getDocument();
    }

    private static void usage() {
        System.err.println("Usage: java org.pdfbox.ExtractText [OPTIONS] <PDF file> [Text File]\n  -password  <password>        Password to decrypt document\n  -encoding  <output encoding> (ISO-8859-1(default),UTF-16BE,UTF-16LE,...)\n  -console                     Send text to console instead of file\n  -startPage <number>          The first page to start extraction(1 based)\n  -endPage <number>            The last page to extract(inclusive)\n  <PDF file>                   The PDF document to use\n  [Text File]                  The file to write the text to\n");
        System.exit(1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

