/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSString;
import org.pdfbox.pdmodel.common.COSArrayList;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.pdmodel.interactive.annotation.PDWidget;
import org.pdfbox.pdmodel.interactive.form.PDAcroForm;

public abstract class PDField
implements COSObjectable {
    private PDAcroForm acroForm;
    private COSDictionary dictionary;

    public PDField(PDAcroForm theAcroForm) {
        this.acroForm = theAcroForm;
        this.dictionary = new COSDictionary();
    }

    public PDField(PDAcroForm theAcroForm, COSDictionary field) {
        this.acroForm = theAcroForm;
        this.dictionary = field;
    }

    public String getName() {
        return ((COSString)this.getDictionary().getDictionaryObject(COSName.getPDFName("T"))).getString();
    }

    public void setName(String name) {
        this.getDictionary().setItem(COSName.getPDFName("T"), new COSString(name));
    }

    public abstract void setValue(String var1) throws IOException;

    public void setReadonly(boolean readonly) {
        this.setFfFlag(1, readonly);
    }

    public boolean isReadonly() {
        return this.getFfFlag(1);
    }

    public int getFieldFlags() {
        int retval = 0;
        COSInteger ff = (COSInteger)this.getDictionary().getDictionaryObject(COSName.getPDFName("Ff"));
        if (ff != null) {
            retval = ff.intValue();
        }
        return retval;
    }

    public void setFieldFlags(int flags) {
        COSInteger ff = new COSInteger(flags);
        this.getDictionary().setItem(COSName.getPDFName("Ff"), ff);
    }

    protected void setFfFlag(int bitPos, boolean value) {
        long ffval = this.getFieldFlags();
        char[] bits = Long.toBinaryString(ffval).toCharArray();
        bits[bits.length - bitPos] = value ? 49 : 48;
        String s = new String(bits);
        COSInteger ff = new COSInteger(Integer.parseInt(s, 2));
        this.getDictionary().setItem(COSName.getPDFName("Ff"), ff);
    }

    protected boolean getFfFlag(int bitPos) {
        COSInteger ff = (COSInteger)this.getDictionary().getDictionaryObject(COSName.getPDFName("Ff"));
        if (ff != null) {
            int bitMask = (int)Math.pow(2.0, bitPos - 1);
            return (ff.intValue() & bitMask) == bitMask;
        }
        return false;
    }

    public void importFDF(COSDictionary fdfField) throws IOException {
        COSInteger ff;
        COSBase fieldValue = fdfField.getDictionaryObject(COSName.getPDFName("V"));
        int fieldFlags = this.getFieldFlags();
        if (fieldValue != null) {
            if (fieldValue instanceof COSString) {
                COSString string = (COSString)fieldValue;
                this.setValue(string.getString());
            } else if (fieldValue instanceof COSName) {
                COSName name = (COSName)fieldValue;
                this.setValue(name.getName());
            } else {
                throw new IOException("Uknown field type:" + fieldValue.getClass().getName());
            }
        }
        if ((ff = (COSInteger)fdfField.getDictionaryObject(COSName.getPDFName("Ff"))) != null) {
            this.setFieldFlags(ff.intValue());
        } else {
            COSInteger clrFf;
            COSInteger setFf = (COSInteger)fdfField.getDictionaryObject(COSName.getPDFName("SetFf"));
            if (setFf != null) {
                int setFfInt = setFf.intValue();
                this.setFieldFlags(fieldFlags |= setFfInt);
            }
            if ((clrFf = (COSInteger)fdfField.getDictionaryObject(COSName.getPDFName("ClrFf"))) != null) {
                int clrFfValue = clrFf.intValue();
                this.setFieldFlags(fieldFlags &= (clrFfValue ^= 0xFFFFFFFF));
            }
        }
        PDWidget widget = this.getWidget();
        if (widget != null) {
            int annotFlags = widget.getAnnotationFlags();
            COSInteger f = (COSInteger)fdfField.getDictionaryObject(COSName.getPDFName("F"));
            if (f != null && widget != null) {
                widget.setAnnotationFlags(f.intValue());
            } else {
                COSInteger clrF;
                COSInteger setF = (COSInteger)fdfField.getDictionaryObject(COSName.getPDFName("SetF"));
                if (setF != null) {
                    widget.setAnnotationFlags(annotFlags |= setF.intValue());
                }
                if ((clrF = (COSInteger)fdfField.getDictionaryObject(COSName.getPDFName("ClrF"))) != null) {
                    int clrFValue = clrF.intValue();
                    clrFValue = (int)((long)clrFValue ^ 0xFFFFFFFFL);
                    widget.setAnnotationFlags(annotFlags &= clrFValue);
                }
            }
        }
    }

    public PDWidget getWidget() {
        PDWidget retval = null;
        List kids = this.getKids();
        if (kids == null) {
            retval = new PDWidget(this.getDictionary());
        }
        return retval;
    }

    public List getKids() {
        COSArrayList retval = null;
        COSArray kids = (COSArray)this.getDictionary().getDictionaryObject(COSName.KIDS);
        if (kids != null) {
            ArrayList<PDWidget> kidsList = new ArrayList<PDWidget>();
            int i = 0;
            while (i < kids.size()) {
                kidsList.add(new PDWidget((COSDictionary)kids.getObject(i)));
                ++i;
            }
            retval = new COSArrayList(kidsList, kids);
        }
        return retval;
    }

    public void setKids(List kids) {
        COSArray kidsArray = COSArrayList.converterToCOSArray(kids);
        this.getDictionary().setItem(COSName.KIDS, kidsArray);
    }

    public String toString() {
        return "" + this.getDictionary().getDictionaryObject(COSName.getPDFName("V"));
    }

    public PDAcroForm getAcroForm() {
        return this.acroForm;
    }

    public void setAcroForm(PDAcroForm value) {
        this.acroForm = value;
    }

    public COSDictionary getDictionary() {
        return this.dictionary;
    }

    public COSBase getCOSObject() {
        return this.dictionary;
    }
}

