/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.ojb.constraints;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import xdoclet.modules.ojb.CommaListIterator;
import xdoclet.modules.ojb.constraints.ConstraintException;
import xdoclet.modules.ojb.constraints.ConstraintsBase;
import xdoclet.modules.ojb.constraints.InheritanceHelper;
import xdoclet.modules.ojb.model.ClassDescriptorDef;
import xdoclet.modules.ojb.model.FeatureDescriptorDef;
import xdoclet.modules.ojb.model.ObjectCacheDef;
import xdoclet.modules.ojb.model.ProcedureArgumentDef;
import xdoclet.modules.ojb.model.ProcedureDef;
import xdoclet.modules.ojb.model.PropertyHelper;

public class ClassDescriptorConstraints
extends ConstraintsBase {
    private static final String ROW_READER_INTERFACE = "org.apache.ojb.broker.accesslayer.RowReader";
    private static final String OBJECT_CACHE_INTERFACE = "org.apache.ojb.broker.cache.ObjectCache";

    public void check(ClassDescriptorDef classDef, String checkLevel) throws ConstraintException {
        this.checkModifications(classDef, checkLevel);
        this.checkExtents(classDef, checkLevel);
        this.ensureTableIfNecessary(classDef, checkLevel);
        this.checkFactoryClassAndMethod(classDef, checkLevel);
        this.checkInitializationMethod(classDef, checkLevel);
        this.checkProxyPrefetchingLimit(classDef, checkLevel);
        this.checkRowReader(classDef, checkLevel);
        this.checkObjectCache(classDef, checkLevel);
        this.checkProcedures(classDef, checkLevel);
    }

    private void checkModifications(ClassDescriptorDef classDef, String checkLevel) throws ConstraintException {
        FeatureDescriptorDef def;
        if ("none".equals(checkLevel)) {
            return;
        }
        HashMap<String, FeatureDescriptorDef> features = new HashMap<String, FeatureDescriptorDef>();
        Iterator it = classDef.getFields();
        while (it.hasNext()) {
            def = (FeatureDescriptorDef)it.next();
            features.put(def.getName(), def);
        }
        it = classDef.getReferences();
        while (it.hasNext()) {
            def = (FeatureDescriptorDef)it.next();
            features.put(def.getName(), def);
        }
        it = classDef.getCollections();
        while (it.hasNext()) {
            def = (FeatureDescriptorDef)it.next();
            features.put(def.getName(), def);
        }
        Iterator it2 = classDef.getModificationNames();
        while (it2.hasNext()) {
            String modName = (String)it2.next();
            if (!features.containsKey(modName)) {
                throw new ConstraintException("Class " + classDef.getName() + " contains a modification for an unknown feature " + modName);
            }
            def = (FeatureDescriptorDef)features.get(modName);
            if (def.getOriginal() == null) {
                throw new ConstraintException("Class " + classDef.getName() + " contains a modification for a feature " + modName + " that is not inherited but defined in the same class");
            }
            Properties mods = classDef.getModification(modName);
            Iterator<Object> propIt = mods.keySet().iterator();
            while (propIt.hasNext()) {
                String propName = (String)propIt.next();
                if (PropertyHelper.isPropertyAllowed(def.getClass(), propName)) continue;
                throw new ConstraintException("The modification of attribute " + propName + " in class " + classDef.getName() + " is not applicable to the feature " + modName);
            }
        }
    }

    private void checkExtents(ClassDescriptorDef classDef, String checkLevel) throws ConstraintException {
        if ("none".equals(checkLevel)) {
            return;
        }
        HashMap processedClasses = new HashMap();
        InheritanceHelper helper = new InheritanceHelper();
        Iterator it = classDef.getExtentClasses();
        while (it.hasNext()) {
            ClassDescriptorDef curExtent = (ClassDescriptorDef)it.next();
            boolean canBeRemoved = false;
            if (classDef.getName().equals(curExtent.getName())) {
                throw new ConstraintException("The class " + classDef.getName() + " specifies itself as an extent-class");
            }
            if (processedClasses.containsKey(curExtent)) {
                canBeRemoved = true;
            } else {
                try {
                    if (!helper.isSameOrSubTypeOf(curExtent, classDef.getName(), false)) {
                        throw new ConstraintException("The class " + classDef.getName() + " specifies an extent-class " + curExtent.getName() + " that is not a sub-type of it");
                    }
                    Iterator processedIt = processedClasses.keySet().iterator();
                    while (processedIt.hasNext()) {
                        if (!helper.isSameOrSubTypeOf(curExtent, ((ClassDescriptorDef)processedIt.next()).getName(), false)) continue;
                        canBeRemoved = true;
                        break;
                    }
                }
                catch (ClassNotFoundException ex) {
                    // empty catch block
                }
            }
            if (canBeRemoved) {
                it.remove();
            }
            processedClasses.put(curExtent, null);
        }
    }

    private void ensureTableIfNecessary(ClassDescriptorDef classDef, String checkLevel) {
        if (classDef.getBooleanProperty("ojb-persistent", false) && !classDef.hasProperty("table")) {
            String name = classDef.getName();
            classDef.setProperty("table", name.substring(name.lastIndexOf(46) + 1));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkFactoryClassAndMethod(ClassDescriptorDef classDef, String checkLevel) throws ConstraintException {
        if ("none".equals(checkLevel)) {
            return;
        }
        String factoryClassName = classDef.getProperty("factory-class");
        String factoryMethodName = classDef.getProperty("factory-method");
        if (factoryClassName == null && factoryMethodName == null) {
            return;
        }
        if (factoryClassName != null && factoryMethodName == null) {
            throw new ConstraintException("Class " + classDef.getName() + " has a factory-class but no factory-method.");
        }
        if (factoryClassName == null && factoryMethodName != null) {
            throw new ConstraintException("Class " + classDef.getName() + " has a factory-method but no factory-class.");
        }
        if ("strict".equals(checkLevel)) {
            void var6_12;
            Method factoryMethod;
            Class factoryClass;
            try {
                factoryClass = InheritanceHelper.getClass(factoryClassName);
            }
            catch (ClassNotFoundException ex) {
                throw new ConstraintException("The class " + factoryClassName + " specified as factory-class of class " + classDef.getName() + " was not found on the classpath");
            }
            try {
                factoryMethod = factoryClass.getDeclaredMethod(factoryMethodName, new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                factoryMethod = null;
            }
            catch (Exception ex) {
                throw new ConstraintException("Exception while checking the factory-class " + factoryClassName + " of class " + classDef.getName() + ": " + ex.getMessage());
            }
            if (factoryMethod == null) {
                try {
                    factoryMethod = factoryClass.getMethod(factoryMethodName, new Class[0]);
                }
                catch (NoSuchMethodException ex) {
                    throw new ConstraintException("No suitable factory-method " + factoryMethodName + " found in the factory-class " + factoryClassName + " of class " + classDef.getName());
                }
                catch (Exception ex) {
                    throw new ConstraintException("Exception while checking the factory-class " + factoryClassName + " of class " + classDef.getName() + ": " + ex.getMessage());
                }
            }
            Class<?> returnType = var6_12.getReturnType();
            InheritanceHelper helper = new InheritanceHelper();
            if ("void".equals(returnType.getName())) {
                throw new ConstraintException("The factory-method " + factoryMethodName + " in factory-class " + factoryClassName + " of class " + classDef.getName() + " must return a value");
            }
            try {
                if (!helper.isSameOrSubTypeOf(returnType.getName(), classDef.getName())) {
                    throw new ConstraintException("The method " + factoryMethodName + " in factory-class " + factoryClassName + " of class " + classDef.getName() + " must return the type " + classDef.getName() + " or a subtype of it");
                }
            }
            catch (ClassNotFoundException ex) {
                throw new ConstraintException("Could not find the class " + ex.getMessage() + " on the classpath while checking the factory-method " + factoryMethodName + " in the factory-class " + factoryClassName + " of class " + classDef.getName());
            }
            if (!Modifier.isStatic(var6_12.getModifiers())) {
                throw new ConstraintException("The factory-method " + factoryMethodName + " in factory-class " + factoryClassName + " of class " + classDef.getName() + " must be static");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkInitializationMethod(ClassDescriptorDef classDef, String checkLevel) throws ConstraintException {
        void var5_11;
        int mods;
        Method initMethod;
        Class initClass;
        if (!"strict".equals(checkLevel)) {
            return;
        }
        String initMethodName = classDef.getProperty("initialization-method");
        if (initMethodName == null) {
            return;
        }
        try {
            initClass = InheritanceHelper.getClass(classDef.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new ConstraintException("The class " + classDef.getName() + " was not found on the classpath");
        }
        try {
            initMethod = initClass.getDeclaredMethod(initMethodName, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            initMethod = null;
        }
        catch (Exception ex) {
            throw new ConstraintException("Exception while checking the class " + classDef.getName() + ": " + ex.getMessage());
        }
        if (initMethod == null) {
            try {
                initMethod = initClass.getMethod(initMethodName, new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                throw new ConstraintException("No suitable initialization-method " + initMethodName + " found in class " + classDef.getName());
            }
            catch (Exception ex) {
                throw new ConstraintException("Exception while checking the class " + classDef.getName() + ": " + ex.getMessage());
            }
        }
        if (Modifier.isStatic(mods = var5_11.getModifiers()) || Modifier.isAbstract(mods)) {
            throw new ConstraintException("The initialization-method " + initMethodName + " in class " + classDef.getName() + " must be a concrete instance method");
        }
    }

    private void checkRowReader(ClassDescriptorDef classDef, String checkLevel) throws ConstraintException {
        if (!"strict".equals(checkLevel)) {
            return;
        }
        String rowReaderName = classDef.getProperty("row-reader");
        if (rowReaderName == null) {
            return;
        }
        try {
            InheritanceHelper helper = new InheritanceHelper();
            if (!helper.isSameOrSubTypeOf(rowReaderName, ROW_READER_INTERFACE)) {
                throw new ConstraintException("The class " + rowReaderName + " specified as row-reader of class " + classDef.getName() + " does not implement the interface " + ROW_READER_INTERFACE);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new ConstraintException("Could not find the class " + ex.getMessage() + " on the classpath while checking the row-reader class " + rowReaderName + " of class " + classDef.getName());
        }
    }

    private void checkObjectCache(ClassDescriptorDef classDef, String checkLevel) throws ConstraintException {
        if (!"strict".equals(checkLevel)) {
            return;
        }
        ObjectCacheDef objCacheDef = classDef.getObjectCache();
        if (objCacheDef == null) {
            return;
        }
        String objectCacheName = objCacheDef.getName();
        if (objectCacheName == null || objectCacheName.length() == 0) {
            throw new ConstraintException("No class specified for the object-cache of class " + classDef.getName());
        }
        try {
            InheritanceHelper helper = new InheritanceHelper();
            if (!helper.isSameOrSubTypeOf(objectCacheName, OBJECT_CACHE_INTERFACE)) {
                throw new ConstraintException("The class " + objectCacheName + " specified as object-cache of class " + classDef.getName() + " does not implement the interface " + OBJECT_CACHE_INTERFACE);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new ConstraintException("Could not find the class " + ex.getMessage() + " on the classpath while checking the object-cache class " + objectCacheName + " of class " + classDef.getName());
        }
    }

    private void checkProcedures(ClassDescriptorDef classDef, String checkLevel) throws ConstraintException {
        String fieldName;
        String type;
        if ("none".equals(checkLevel)) {
            return;
        }
        Iterator it = classDef.getProcedures();
        while (it.hasNext()) {
            ProcedureDef procDef = (ProcedureDef)it.next();
            type = procDef.getName();
            String name = procDef.getProperty("name");
            if (name == null || name.length() == 0) {
                throw new ConstraintException("The " + type + "-procedure in class " + classDef.getName() + " doesn't have a name");
            }
            fieldName = procDef.getProperty("return-field-ref");
            if (fieldName != null && fieldName.length() > 0 && classDef.getField(fieldName) == null) {
                throw new ConstraintException("The " + type + "-procedure " + name + " in class " + classDef.getName() + " references an unknown or non-persistent return field " + fieldName);
            }
            CommaListIterator argIt = new CommaListIterator(procDef.getProperty("arguments"));
            while (argIt.hasNext()) {
                String argName = argIt.getNext();
                if (classDef.getProcedureArgument(argName) != null) continue;
                throw new ConstraintException("The " + type + "-procedure " + name + " in class " + classDef.getName() + " references an unknown argument " + argName);
            }
        }
        Iterator it2 = classDef.getProcedureArguments();
        while (it2.hasNext()) {
            ProcedureArgumentDef argDef = (ProcedureArgumentDef)it2.next();
            type = argDef.getProperty("type");
            if (!"runtime".equals(type) || (fieldName = argDef.getProperty("field-ref")) == null || fieldName.length() <= 0 || classDef.getField(fieldName) != null) continue;
            throw new ConstraintException("The " + type + "-argument " + argDef.getName() + " in class " + classDef.getName() + " references an unknown or non-persistent return field " + fieldName);
        }
    }
}

