/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.ojb.constraints;

import xdoclet.modules.ojb.CommaListIterator;
import xdoclet.modules.ojb.constraints.ConstraintException;
import xdoclet.modules.ojb.constraints.FeatureDescriptorConstraints;
import xdoclet.modules.ojb.constraints.InheritanceHelper;
import xdoclet.modules.ojb.model.ClassDescriptorDef;
import xdoclet.modules.ojb.model.CollectionDescriptorDef;
import xdoclet.modules.ojb.model.FieldDescriptorDef;
import xdoclet.modules.ojb.model.ModelDef;

public class CollectionDescriptorConstraints
extends FeatureDescriptorConstraints {
    private static final String JAVA_COLLECTION_INTERFACE = "java.util.Collection";
    private static final String MANAGEABLE_COLLECTION_INTERFACE = "org.apache.ojb.broker.ManageableCollection";
    private static final String QUERY_CUSTOMIZER_INTERFACE = "org.apache.ojb.broker.accesslayer.QueryCustomizer";

    public void check(CollectionDescriptorDef collDef, String checkLevel) throws ConstraintException {
        this.ensureElementClassRef(collDef, checkLevel);
        this.checkInheritedForeignkey(collDef, checkLevel);
        this.ensureCollectionClass(collDef, checkLevel);
        this.checkProxyPrefetchingLimit(collDef, checkLevel);
        this.checkOrderby(collDef, checkLevel);
        this.checkQueryCustomizer(collDef, checkLevel);
    }

    private void ensureElementClassRef(CollectionDescriptorDef collDef, String checkLevel) throws ConstraintException {
        String elementClassName;
        ModelDef model;
        ClassDescriptorDef elementClassDef;
        if ("none".equals(checkLevel)) {
            return;
        }
        String arrayElementClassName = collDef.getProperty("array-element-class-ref");
        if (!collDef.hasProperty("element-class-ref")) {
            if (arrayElementClassName != null) {
                collDef.setProperty("element-class-ref", arrayElementClassName);
            } else {
                throw new ConstraintException("Collection " + collDef.getName() + " in class " + collDef.getOwner().getName() + " does not specify its element class");
            }
        }
        if ((elementClassDef = (model = (ModelDef)collDef.getOwner().getOwner()).getClass(elementClassName = collDef.getProperty("element-class-ref"))) == null) {
            throw new ConstraintException("Collection " + collDef.getName() + " in class " + collDef.getOwner().getName() + " references an unknown class " + elementClassName);
        }
        if (!elementClassDef.getBooleanProperty("ojb-persistent", false)) {
            throw new ConstraintException("The element class " + elementClassName + " of the collection " + collDef.getName() + " in class " + collDef.getOwner().getName() + " is not persistent");
        }
        if ("strict".equals(checkLevel) && arrayElementClassName != null) {
            try {
                InheritanceHelper helper = new InheritanceHelper();
                if (!helper.isSameOrSubTypeOf(elementClassDef, arrayElementClassName, true)) {
                    throw new ConstraintException("The element class " + elementClassName + " of the collection " + collDef.getName() + " in class " + collDef.getOwner().getName() + " is not the same or a subtype of the array base type " + arrayElementClassName);
                }
            }
            catch (ClassNotFoundException ex) {
                throw new ConstraintException("Could not find the class " + ex.getMessage() + " on the classpath while checking the collection " + collDef.getName() + " in class " + collDef.getOwner().getName());
            }
        }
    }

    private void checkInheritedForeignkey(CollectionDescriptorDef collDef, String checkLevel) throws ConstraintException {
        if ("none".equals(checkLevel)) {
            return;
        }
        if (!collDef.isInherited() && !collDef.isNested()) {
            return;
        }
        if (!collDef.hasProperty("indirection-table")) {
            return;
        }
        if (!collDef.getProperty("foreignkey").equals(collDef.getOriginal().getProperty("foreignkey"))) {
            throw new ConstraintException("The foreignkey property has been changed for the m:n collection " + collDef.getName() + " in class " + collDef.getOwner().getName());
        }
    }

    private void ensureCollectionClass(CollectionDescriptorDef collDef, String checkLevel) throws ConstraintException {
        if ("none".equals(checkLevel)) {
            return;
        }
        if (collDef.hasProperty("array-element-class-ref")) {
            if (collDef.hasProperty("collection-class")) {
                throw new ConstraintException("Collection " + collDef.getName() + " in class " + collDef.getOwner().getName() + " is an array but does specify collection-class");
            }
            return;
        }
        if ("strict".equals(checkLevel)) {
            InheritanceHelper helper = new InheritanceHelper();
            ModelDef model = (ModelDef)collDef.getOwner().getOwner();
            String specifiedClass = collDef.getProperty("collection-class");
            String variableType = collDef.getProperty("variable-type");
            try {
                if (specifiedClass != null) {
                    if (!helper.isSameOrSubTypeOf(specifiedClass, variableType)) {
                        throw new ConstraintException("The type " + specifiedClass + " specified as collection-class of the collection " + collDef.getName() + " in class " + collDef.getOwner().getName() + " is not a sub type of the variable type " + variableType);
                    }
                    if (!helper.isSameOrSubTypeOf(specifiedClass, MANAGEABLE_COLLECTION_INTERFACE)) {
                        throw new ConstraintException("The type " + specifiedClass + " specified as collection-class of the collection " + collDef.getName() + " in class " + collDef.getOwner().getName() + " does not implement " + MANAGEABLE_COLLECTION_INTERFACE);
                    }
                } else if (helper.isSameOrSubTypeOf(variableType, MANAGEABLE_COLLECTION_INTERFACE)) {
                    collDef.setProperty("collection-class", variableType);
                } else if (!helper.isSameOrSubTypeOf(variableType, JAVA_COLLECTION_INTERFACE)) {
                    throw new ConstraintException("The collection " + collDef.getName() + " in class " + collDef.getOwner().getName() + " needs the collection-class attribute as its variable type does not implement " + JAVA_COLLECTION_INTERFACE);
                }
            }
            catch (ClassNotFoundException ex) {
                throw new ConstraintException("Could not find the class " + ex.getMessage() + " on the classpath while checking the collection " + collDef.getName() + " in class " + collDef.getOwner().getName());
            }
        }
    }

    private void checkOrderby(CollectionDescriptorDef collDef, String checkLevel) throws ConstraintException {
        if ("none".equals(checkLevel)) {
            return;
        }
        String orderbySpec = collDef.getProperty("orderby");
        if (orderbySpec == null || orderbySpec.length() == 0) {
            return;
        }
        ClassDescriptorDef ownerClass = (ClassDescriptorDef)collDef.getOwner();
        ClassDescriptorDef elementClass = ((ModelDef)ownerClass.getOwner()).getClass(collDef.getProperty("element-class-ref"));
        CommaListIterator it = new CommaListIterator(orderbySpec);
        while (it.hasNext()) {
            String ordering;
            String fieldName;
            String token = it.getNext();
            int pos = token.indexOf(61);
            if (pos == -1) {
                fieldName = token;
                ordering = null;
            } else {
                fieldName = token.substring(0, pos);
                ordering = token.substring(pos + 1);
            }
            FieldDescriptorDef fieldDef = elementClass.getField(fieldName);
            if (fieldDef == null) {
                throw new ConstraintException("The field " + fieldName + " specified in the orderby attribute of the collection " + collDef.getName() + " in class " + ownerClass.getName() + " hasn't been found in the element class " + elementClass.getName());
            }
            if (ordering == null || ordering.length() <= 0 || "ASC".equals(ordering) || "DESC".equals(ordering)) continue;
            throw new ConstraintException("The ordering " + ordering + " specified in the orderby attribute of the collection " + collDef.getName() + " in class " + ownerClass.getName() + " is invalid");
        }
    }

    private void checkQueryCustomizer(CollectionDescriptorDef collDef, String checkLevel) throws ConstraintException {
        if (!"strict".equals(checkLevel)) {
            return;
        }
        String queryCustomizerName = collDef.getProperty("query-customizer");
        if (queryCustomizerName == null) {
            return;
        }
        try {
            InheritanceHelper helper = new InheritanceHelper();
            if (!helper.isSameOrSubTypeOf(queryCustomizerName, QUERY_CUSTOMIZER_INTERFACE)) {
                throw new ConstraintException("The class " + queryCustomizerName + " specified as query-customizer of collection " + collDef.getName() + " in class " + collDef.getOwner().getName() + " does not implement the interface " + QUERY_CUSTOMIZER_INTERFACE);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new ConstraintException("The class " + ex.getMessage() + " specified as query-customizer of collection " + collDef.getName() + " in class " + collDef.getOwner().getName() + " was not found on the classpath");
        }
    }
}

