/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.ojb.constraints;

import java.util.HashMap;
import xdoclet.modules.ojb.LogHelper;
import xdoclet.modules.ojb.constraints.ConstraintException;
import xdoclet.modules.ojb.constraints.FeatureDescriptorConstraints;
import xdoclet.modules.ojb.constraints.InheritanceHelper;
import xdoclet.modules.ojb.constraints.JdbcTypeHelper;
import xdoclet.modules.ojb.model.FieldDescriptorDef;

public class FieldDescriptorConstraints
extends FeatureDescriptorConstraints {
    private static final String CONVERSION_INTERFACE = "org.apache.ojb.broker.accesslayer.conversions.FieldConversion";
    private static HashMap _jdbcTypes = new HashMap();
    static /* synthetic */ Class class$xdoclet$modules$ojb$constraints$FieldDescriptorConstraints;

    public void check(FieldDescriptorDef fieldDef, String checkLevel) throws ConstraintException {
        this.ensureColumn(fieldDef, checkLevel);
        this.ensureJdbcType(fieldDef, checkLevel);
        this.ensureConversion(fieldDef, checkLevel);
        this.ensureLength(fieldDef, checkLevel);
        this.ensurePrecisionAndScale(fieldDef, checkLevel);
        this.checkLocking(fieldDef, checkLevel);
        this.checkSequenceName(fieldDef, checkLevel);
        this.checkId(fieldDef, checkLevel);
        this.checkAccess(fieldDef, checkLevel);
    }

    private void ensureColumn(FieldDescriptorDef fieldDef, String checkLevel) {
        if (!fieldDef.hasProperty("column")) {
            int pos;
            String javaname = fieldDef.getName();
            if (fieldDef.isNested() && (pos = javaname.indexOf("::")) > 0) {
                StringBuffer newJavaname = new StringBuffer(javaname.substring(0, pos));
                int lastPos = pos + 2;
                do {
                    pos = javaname.indexOf("::", lastPos);
                    newJavaname.append("_");
                    if (pos > 0) {
                        newJavaname.append(javaname.substring(lastPos, pos));
                        lastPos = pos + 2;
                        continue;
                    }
                    newJavaname.append(javaname.substring(lastPos));
                } while (pos > 0);
                javaname = newJavaname.toString();
            }
            fieldDef.setProperty("column", javaname);
        }
    }

    private void ensureJdbcType(FieldDescriptorDef fieldDef, String checkLevel) throws ConstraintException {
        if (!fieldDef.hasProperty("jdbc-type")) {
            if (!fieldDef.hasProperty("default-jdbc-type")) {
                throw new ConstraintException("No jdbc-type specified for the field " + fieldDef.getName() + " in class " + fieldDef.getOwner().getName());
            }
            fieldDef.setProperty("jdbc-type", fieldDef.getProperty("default-jdbc-type"));
            if (!fieldDef.hasProperty("conversion") && fieldDef.hasProperty("default-conversion")) {
                fieldDef.setProperty("conversion", fieldDef.getProperty("default-conversion"));
            }
        } else {
            String jdbcType = fieldDef.getProperty("jdbc-type");
            if (!_jdbcTypes.containsKey(jdbcType)) {
                throw new ConstraintException("The field " + fieldDef.getName() + " in class " + fieldDef.getOwner().getName() + " specifies the invalid jdbc type " + jdbcType);
            }
        }
    }

    private void ensureConversion(FieldDescriptorDef fieldDef, String checkLevel) throws ConstraintException {
        String conversionClass;
        if ("none".equals(checkLevel)) {
            return;
        }
        if ("java.util.Date".equals(fieldDef.getProperty("java-type")) && !fieldDef.hasProperty("conversion")) {
            LogHelper.warn(true, class$xdoclet$modules$ojb$constraints$FieldDescriptorConstraints == null ? (class$xdoclet$modules$ojb$constraints$FieldDescriptorConstraints = FieldDescriptorConstraints.class$("xdoclet.modules.ojb.constraints.FieldDescriptorConstraints")) : class$xdoclet$modules$ojb$constraints$FieldDescriptorConstraints, "ensureConversion", "The field " + fieldDef.getName() + " in class " + fieldDef.getOwner().getName() + " of type java.util.Date is directly mapped to jdbc-type " + fieldDef.getProperty("jdbc-type") + ". However, most JDBC drivers can't handle java.util.Date directly so you might want to " + " use a conversion for converting it to a JDBC datatype like TIMESTAMP.");
        }
        if (((conversionClass = fieldDef.getProperty("conversion")) == null || conversionClass.length() == 0) && fieldDef.hasProperty("default-conversion") && fieldDef.getProperty("default-jdbc-type").equals(fieldDef.getProperty("jdbc-type"))) {
            conversionClass = fieldDef.getProperty("default-conversion");
            fieldDef.setProperty("conversion", conversionClass);
        }
        if ("strict".equals(checkLevel) && conversionClass != null && conversionClass.length() > 0) {
            InheritanceHelper helper = new InheritanceHelper();
            try {
                if (!helper.isSameOrSubTypeOf(conversionClass, CONVERSION_INTERFACE)) {
                    throw new ConstraintException("The conversion class specified for field " + fieldDef.getName() + " in class " + fieldDef.getOwner().getName() + " does not implement the necessary interface " + CONVERSION_INTERFACE);
                }
            }
            catch (ClassNotFoundException ex) {
                throw new ConstraintException("The class " + ex.getMessage() + " hasn't been found on the classpath while checking the conversion class specified for field " + fieldDef.getName() + " in class " + fieldDef.getOwner().getName());
            }
        }
    }

    private void ensureLength(FieldDescriptorDef fieldDef, String checkLevel) {
        String defaultLength;
        if (!fieldDef.hasProperty("length") && (defaultLength = JdbcTypeHelper.getDefaultLengthFor(fieldDef.getProperty("jdbc-type"))) != null) {
            LogHelper.warn(true, class$xdoclet$modules$ojb$constraints$FieldDescriptorConstraints == null ? (class$xdoclet$modules$ojb$constraints$FieldDescriptorConstraints = FieldDescriptorConstraints.class$("xdoclet.modules.ojb.constraints.FieldDescriptorConstraints")) : class$xdoclet$modules$ojb$constraints$FieldDescriptorConstraints, "ensureLength", "The field " + fieldDef.getName() + " in class " + fieldDef.getOwner().getName() + " has no length setting though its jdbc type requires it (in most databases); using default length of " + defaultLength);
            fieldDef.setProperty("length", defaultLength);
        }
    }

    private void ensurePrecisionAndScale(FieldDescriptorDef fieldDef, String checkLevel) {
        fieldDef.setProperty("default-precision", null);
        fieldDef.setProperty("default-scale", null);
        if (!fieldDef.hasProperty("precision")) {
            String defaultPrecision = JdbcTypeHelper.getDefaultPrecisionFor(fieldDef.getProperty("jdbc-type"));
            if (defaultPrecision != null) {
                LogHelper.warn(true, class$xdoclet$modules$ojb$constraints$FieldDescriptorConstraints == null ? (class$xdoclet$modules$ojb$constraints$FieldDescriptorConstraints = FieldDescriptorConstraints.class$("xdoclet.modules.ojb.constraints.FieldDescriptorConstraints")) : class$xdoclet$modules$ojb$constraints$FieldDescriptorConstraints, "ensureLength", "The field " + fieldDef.getName() + " in class " + fieldDef.getOwner().getName() + " has no precision setting though its jdbc type requires it (in most databases); using default precision of " + defaultPrecision);
                fieldDef.setProperty("default-precision", defaultPrecision);
            } else if (fieldDef.hasProperty("scale")) {
                fieldDef.setProperty("default-precision", "1");
            }
        }
        if (!fieldDef.hasProperty("scale")) {
            String defaultScale = JdbcTypeHelper.getDefaultScaleFor(fieldDef.getProperty("jdbc-type"));
            if (defaultScale != null) {
                LogHelper.warn(true, class$xdoclet$modules$ojb$constraints$FieldDescriptorConstraints == null ? (class$xdoclet$modules$ojb$constraints$FieldDescriptorConstraints = FieldDescriptorConstraints.class$("xdoclet.modules.ojb.constraints.FieldDescriptorConstraints")) : class$xdoclet$modules$ojb$constraints$FieldDescriptorConstraints, "ensureLength", "The field " + fieldDef.getName() + " in class " + fieldDef.getOwner().getName() + " has no scale setting though its jdbc type requires it (in most databases); using default scale of " + defaultScale);
                fieldDef.setProperty("default-scale", defaultScale);
            } else if (fieldDef.hasProperty("precision") || fieldDef.hasProperty("default-precision")) {
                fieldDef.setProperty("default-scale", "0");
            }
        }
    }

    private void checkLocking(FieldDescriptorDef fieldDef, String checkLevel) throws ConstraintException {
        if ("none".equals(checkLevel)) {
            return;
        }
        String jdbcType = fieldDef.getProperty("jdbc-type");
        if (!"TIMESTAMP".equals(jdbcType) && !"INTEGER".equals(jdbcType)) {
            if (fieldDef.getBooleanProperty("locking", false)) {
                throw new ConstraintException("The field " + fieldDef.getName() + " in class " + fieldDef.getOwner().getName() + " has locking set to true though it is not of TIMESTAMP or INTEGER type");
            }
            if (fieldDef.getBooleanProperty("update-lock", false)) {
                throw new ConstraintException("The field " + fieldDef.getName() + " in class " + fieldDef.getOwner().getName() + " has update-lock set to true though it is not of TIMESTAMP or INTEGER type");
            }
        }
    }

    private void checkSequenceName(FieldDescriptorDef fieldDef, String checkLevel) throws ConstraintException {
        if ("none".equals(checkLevel)) {
            return;
        }
        String autoIncr = fieldDef.getProperty("autoincrement");
        String seqName = fieldDef.getProperty("sequence-name");
        if (seqName != null && seqName.length() > 0 && !"ojb".equals(autoIncr) && !"database".equals(autoIncr)) {
            throw new ConstraintException("The field " + fieldDef.getName() + " in class " + fieldDef.getOwner().getName() + " has sequence-name set though it's autoincrement value is not set to 'ojb'");
        }
    }

    private void checkId(FieldDescriptorDef fieldDef, String checkLevel) throws ConstraintException {
        if ("none".equals(checkLevel)) {
            return;
        }
        String id = fieldDef.getProperty("id");
        if (id != null && id.length() > 0) {
            try {
                Integer.parseInt(id);
            }
            catch (NumberFormatException ex) {
                throw new ConstraintException("The id attribute of field " + fieldDef.getName() + " in class " + fieldDef.getOwner().getName() + " is not a valid number");
            }
        }
    }

    private void checkAccess(FieldDescriptorDef fieldDef, String checkLevel) throws ConstraintException {
        if ("none".equals(checkLevel)) {
            return;
        }
        String access = fieldDef.getProperty("access");
        if (fieldDef.isAnonymous()) {
            if (!"anonymous".equals(access)) {
                throw new ConstraintException("The access property of the field " + fieldDef.getName() + " inherited in class " + fieldDef.getOwner().getName() + " cannot be changed");
            }
        } else {
            String autoInc = fieldDef.getProperty("autoincrement");
            if ("database".equals(autoInc) && !"readonly".equals(access)) {
                LogHelper.warn(true, class$xdoclet$modules$ojb$constraints$FieldDescriptorConstraints == null ? (class$xdoclet$modules$ojb$constraints$FieldDescriptorConstraints = FieldDescriptorConstraints.class$("xdoclet.modules.ojb.constraints.FieldDescriptorConstraints")) : class$xdoclet$modules$ojb$constraints$FieldDescriptorConstraints, "checkAccess", "The field " + fieldDef.getName() + " in class " + fieldDef.getOwner().getName() + " is set to database auto-increment. Therefore the field's access is set to 'readonly'.");
                fieldDef.setProperty("access", "readonly");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _jdbcTypes.put("BIT", null);
        _jdbcTypes.put("TINYINT", null);
        _jdbcTypes.put("SMALLINT", null);
        _jdbcTypes.put("INTEGER", null);
        _jdbcTypes.put("BIGINT", null);
        _jdbcTypes.put("DOUBLE", null);
        _jdbcTypes.put("FLOAT", null);
        _jdbcTypes.put("REAL", null);
        _jdbcTypes.put("NUMERIC", null);
        _jdbcTypes.put("DECIMAL", null);
        _jdbcTypes.put("CHAR", null);
        _jdbcTypes.put("VARCHAR", null);
        _jdbcTypes.put("LONGVARCHAR", null);
        _jdbcTypes.put("DATE", null);
        _jdbcTypes.put("TIME", null);
        _jdbcTypes.put("TIMESTAMP", null);
        _jdbcTypes.put("BINARY", null);
        _jdbcTypes.put("VARBINARY", null);
        _jdbcTypes.put("LONGVARBINARY", null);
        _jdbcTypes.put("CLOB", null);
        _jdbcTypes.put("BLOB", null);
        _jdbcTypes.put("STRUCT", null);
        _jdbcTypes.put("ARRAY", null);
        _jdbcTypes.put("REF", null);
        _jdbcTypes.put("BOOLEAN", null);
        _jdbcTypes.put("DATALINK", null);
    }
}

