/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.ojb.constraints;

import java.util.ArrayList;
import java.util.Iterator;
import xdoclet.modules.ojb.model.ClassDescriptorDef;
import xjavadoc.XClass;

public class InheritanceHelper {
    public static Class getClass(String name) throws ClassNotFoundException {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            throw new ClassNotFoundException(name);
        }
    }

    public boolean isSameOrSubTypeOf(XClass type, String baseType, boolean checkActualClasses) throws ClassNotFoundException {
        if (type.getQualifiedName().equals(baseType)) {
            return true;
        }
        ArrayList<Object> queue = new ArrayList<Object>();
        boolean canSpecify = false;
        queue.add(type);
        while (!queue.isEmpty()) {
            XClass curType = (XClass)queue.get(0);
            queue.remove(0);
            if (baseType.equals(curType.getQualifiedName())) {
                return true;
            }
            if (curType.getInterfaces() != null) {
                Iterator it = curType.getInterfaces().iterator();
                while (it.hasNext()) {
                    queue.add(it.next());
                }
            }
            if (curType.isInterface() || curType.getSuperclass() == null) continue;
            queue.add(curType.getSuperclass());
        }
        return checkActualClasses ? this.isSameOrSubTypeOf(type.getName(), baseType) : false;
    }

    public boolean isSameOrSubTypeOf(ClassDescriptorDef type, String baseType, boolean checkActualClasses) throws ClassNotFoundException {
        if (type.getName().equals(baseType)) {
            return true;
        }
        if (type.getOriginalClass() != null) {
            return this.isSameOrSubTypeOf(type.getOriginalClass(), baseType, checkActualClasses);
        }
        return checkActualClasses ? this.isSameOrSubTypeOf(type.getName(), baseType) : false;
    }

    public boolean isSameOrSubTypeOf(String type, String baseType) throws ClassNotFoundException {
        return type.equals(baseType) ? true : this.isSameOrSubTypeOf(InheritanceHelper.getClass(type), baseType);
    }

    public boolean isSameOrSubTypeOf(Class type, String baseType) throws ClassNotFoundException {
        return type.getName().equals(baseType) ? true : InheritanceHelper.getClass(baseType).isAssignableFrom(type);
    }
}

