/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.ojb.constraints;

import java.util.ArrayList;
import java.util.Iterator;
import xdoclet.modules.ojb.CommaListIterator;
import xdoclet.modules.ojb.constraints.ConstraintException;
import xdoclet.modules.ojb.constraints.ConstraintsBase;
import xdoclet.modules.ojb.model.ClassDescriptorDef;
import xdoclet.modules.ojb.model.CollectionDescriptorDef;
import xdoclet.modules.ojb.model.FeatureDescriptorDef;
import xdoclet.modules.ojb.model.FieldDescriptorDef;
import xdoclet.modules.ojb.model.ModelDef;
import xdoclet.modules.ojb.model.PropertyHelper;
import xdoclet.modules.ojb.model.ReferenceDescriptorDef;

public class ModelConstraints
extends ConstraintsBase {
    public void check(ModelDef modelDef, String checkLevel) throws ConstraintException {
        this.checkReferenceForeignkeys(modelDef, checkLevel);
        this.checkCollectionForeignkeys(modelDef, checkLevel);
        this.checkKeyModifications(modelDef, checkLevel);
    }

    private void checkCollectionForeignkeys(ModelDef modelDef, String checkLevel) throws ConstraintException {
        if ("none".equals(checkLevel)) {
            return;
        }
        Iterator it = modelDef.getClasses();
        while (it.hasNext()) {
            ClassDescriptorDef classDef = (ClassDescriptorDef)it.next();
            Iterator collIt = classDef.getCollections();
            while (collIt.hasNext()) {
                CollectionDescriptorDef collDef = (CollectionDescriptorDef)collIt.next();
                if (collDef.hasProperty("indirection-table")) {
                    this.checkIndirectionTable(modelDef, collDef);
                    continue;
                }
                this.checkCollectionForeignkeys(modelDef, collDef);
            }
        }
    }

    private void checkIndirectionTable(ModelDef modelDef, CollectionDescriptorDef collDef) throws ConstraintException {
        String foreignkey = collDef.getProperty("foreignkey");
        if (foreignkey == null || foreignkey.length() == 0) {
            throw new ConstraintException("The collection " + collDef.getName() + " has no foreignkeys");
        }
        ClassDescriptorDef elementClass = modelDef.getClass(collDef.getProperty("element-class-ref"));
        CollectionDescriptorDef remoteCollDef = this.findRemoteCollection(collDef);
        if (remoteCollDef == null) {
            if (!collDef.hasProperty("remote-foreignkey")) {
                throw new ConstraintException("The collection " + collDef.getName() + " in class " + collDef.getOwner().getName() + " must specify remote-foreignkeys as the class on the other side of the m:n association has no corresponding collection");
            }
        } else {
            String remoteKeys2 = remoteCollDef.getProperty("foreignkey");
            if (collDef.hasProperty("remote-foreignkey")) {
                String remoteKeys1 = collDef.getProperty("remote-foreignkey");
                if (!remoteKeys1.equals(remoteKeys2)) {
                    throw new ConstraintException("The remote-foreignkey property specified for collection " + collDef.getName() + " in class " + collDef.getOwner().getName() + " doesn't match the foreignkey property of the corresponding collection " + remoteCollDef.getName() + " in class " + elementClass.getName());
                }
            } else {
                collDef.setProperty("remote-foreignkey", remoteKeys2);
            }
        }
        if (collDef.getOriginal() != null) {
            CollectionDescriptorDef origDef = (CollectionDescriptorDef)collDef.getOriginal();
            CollectionDescriptorDef origRemoteDef = this.findRemoteCollection(origDef);
            origDef.setProperty("relation-name", null);
            origDef.setProperty("inv-relation-name", null);
            if (origRemoteDef != null) {
                origRemoteDef.setProperty("relation-name", null);
                origRemoteDef.setProperty("inv-relation-name", null);
            }
        } else if (!collDef.hasProperty("relation-name")) {
            if (remoteCollDef == null) {
                collDef.setProperty("relation-name", collDef.getName());
                collDef.setProperty("inv-relation-name", "inverse " + collDef.getName());
            } else {
                String relName = collDef.getName() + "-" + remoteCollDef.getName();
                collDef.setProperty("relation-name", relName);
                remoteCollDef.setProperty("inv-relation-name", relName);
                relName = remoteCollDef.getName() + "-" + collDef.getName();
                collDef.setProperty("inv-relation-name", relName);
                remoteCollDef.setProperty("relation-name", relName);
            }
        }
    }

    private CollectionDescriptorDef findRemoteCollection(CollectionDescriptorDef collDef) {
        ModelDef modelDef = (ModelDef)collDef.getOwner().getOwner();
        ClassDescriptorDef elementClass = modelDef.getClass(collDef.getProperty("element-class-ref"));
        String indirTable = collDef.getProperty("indirection-table");
        boolean hasRemoteKey = collDef.hasProperty("remote-foreignkey");
        String remoteKey = collDef.getProperty("remote-foreignkey");
        CollectionDescriptorDef remoteCollDef = null;
        Iterator it = elementClass.getCollections();
        while (it.hasNext()) {
            remoteCollDef = (CollectionDescriptorDef)it.next();
            if (!indirTable.equals(remoteCollDef.getProperty("indirection-table")) || collDef == remoteCollDef || hasRemoteKey && !remoteKey.equals(remoteCollDef.getProperty("foreignkey"))) continue;
            return remoteCollDef;
        }
        return null;
    }

    private void checkCollectionForeignkeys(ModelDef modelDef, CollectionDescriptorDef collDef) throws ConstraintException {
        String foreignkey = collDef.getProperty("foreignkey");
        if (foreignkey == null || foreignkey.length() == 0) {
            throw new ConstraintException("The collection " + collDef.getName() + " has no foreignkeys");
        }
        ClassDescriptorDef ownerClass = (ClassDescriptorDef)collDef.getOwner();
        ArrayList primFields = ownerClass.getPrimaryKeys();
        ArrayList<ClassDescriptorDef> queue = new ArrayList<ClassDescriptorDef>();
        queue.add(modelDef.getClass(collDef.getProperty("element-class-ref")));
        while (!queue.isEmpty()) {
            FieldDescriptorDef keyField;
            int idx;
            ArrayList keyFields;
            ClassDescriptorDef elementClass = (ClassDescriptorDef)queue.get(0);
            queue.remove(0);
            Iterator it = elementClass.getExtentClasses();
            while (it.hasNext()) {
                queue.add((ClassDescriptorDef)it.next());
            }
            if (!elementClass.canBeInstantiated()) continue;
            try {
                keyFields = elementClass.getFields(foreignkey);
            }
            catch (NoSuchFieldException ex) {
                throw new ConstraintException("The collection " + collDef.getName() + " specifies a foreignkey " + ex.getMessage() + " that is not a persistent field in the element class (or its subclass) " + elementClass.getName());
            }
            if (primFields.size() != keyFields.size()) {
                throw new ConstraintException("The number of foreignkeys (" + keyFields.size() + ") of the collection " + collDef.getName() + " doesn't match the number of primarykeys (" + primFields.size() + ") of its owner class " + ownerClass.getName());
            }
            for (idx = 0; idx < keyFields.size(); ++idx) {
                keyField = (FieldDescriptorDef)keyFields.get(idx);
                if (!keyField.getBooleanProperty("ignore", false)) continue;
                throw new ConstraintException("The collection " + collDef.getName() + " in the class " + ownerClass.getName() + " uses the field " + keyField.getName() + " as foreignkey although this field is ignored in the element class (or its subclass) " + elementClass.getName());
            }
            for (idx = 0; idx < primFields.size(); ++idx) {
                String keyType;
                keyField = (FieldDescriptorDef)keyFields.get(idx);
                if (keyField.getBooleanProperty("ignore", false)) {
                    throw new ConstraintException("The collection " + collDef.getName() + " in the class " + ownerClass.getName() + " uses the field " + keyField.getName() + " as foreignkey although this field is ignored in the element class (or its subclass) " + elementClass.getName());
                }
                FieldDescriptorDef primField = (FieldDescriptorDef)primFields.get(idx);
                String primType = primField.getProperty("jdbc-type");
                if (primType.equals(keyType = keyField.getProperty("jdbc-type"))) continue;
                throw new ConstraintException("The jdbc-type of foreignkey " + keyField.getName() + " in the element class (or its subclass) " + elementClass.getName() + " used by the collection " + collDef.getName() + " in class " + ownerClass.getName() + " doesn't match the jdbc-type of the corresponding primarykey " + primField.getName());
            }
        }
    }

    private void checkReferenceForeignkeys(ModelDef modelDef, String checkLevel) throws ConstraintException {
        if ("none".equals(checkLevel)) {
            return;
        }
        Iterator it = modelDef.getClasses();
        while (it.hasNext()) {
            ClassDescriptorDef classDef = (ClassDescriptorDef)it.next();
            Iterator refIt = classDef.getReferences();
            while (refIt.hasNext()) {
                this.checkReferenceForeignkeys(modelDef, (ReferenceDescriptorDef)refIt.next());
            }
        }
    }

    private void checkReferenceForeignkeys(ModelDef modelDef, ReferenceDescriptorDef refDef) throws ConstraintException {
        FieldDescriptorDef keyField;
        ArrayList keyFields;
        String foreignkey = refDef.getProperty("foreignkey");
        if (foreignkey == null || foreignkey.length() == 0) {
            throw new ConstraintException("The reference " + refDef.getName() + " has no foreignkeys");
        }
        ClassDescriptorDef ownerClass = (ClassDescriptorDef)refDef.getOwner();
        try {
            keyFields = ownerClass.getFields(foreignkey);
        }
        catch (NoSuchFieldException ex) {
            throw new ConstraintException("The reference " + refDef.getName() + " specifies a foreignkey " + ex.getMessage() + " that is not a persistent field in its owner class " + ownerClass.getName());
        }
        for (int idx = 0; idx < keyFields.size(); ++idx) {
            keyField = (FieldDescriptorDef)keyFields.get(idx);
            if (!keyField.getBooleanProperty("ignore", false)) continue;
            throw new ConstraintException("The reference " + refDef.getName() + " in the class " + ownerClass.getName() + " uses the field " + keyField.getName() + " as foreignkey although this field is ignored in this class");
        }
        ArrayList<ClassDescriptorDef> queue = new ArrayList<ClassDescriptorDef>();
        queue.add(modelDef.getClass(refDef.getProperty("class-ref")));
        while (!queue.isEmpty()) {
            ClassDescriptorDef referencedClass = (ClassDescriptorDef)queue.get(0);
            queue.remove(0);
            Iterator it = referencedClass.getExtentClasses();
            while (it.hasNext()) {
                queue.add((ClassDescriptorDef)it.next());
            }
            if (!referencedClass.canBeInstantiated()) continue;
            ArrayList primFields = referencedClass.getPrimaryKeys();
            if (primFields.size() != keyFields.size()) {
                throw new ConstraintException("The number of foreignkeys (" + keyFields.size() + ") of the reference " + refDef.getName() + " doesn't match the number of primarykeys (" + primFields.size() + ") of the referenced class (or its subclass) " + referencedClass.getName());
            }
            for (int idx = 0; idx < primFields.size(); ++idx) {
                String keyType;
                keyField = (FieldDescriptorDef)keyFields.get(idx);
                FieldDescriptorDef primField = (FieldDescriptorDef)primFields.get(idx);
                String primType = primField.getProperty("jdbc-type");
                if (primType.equals(keyType = keyField.getProperty("jdbc-type"))) continue;
                throw new ConstraintException("The jdbc-type of foreignkey " + keyField.getName() + " of the reference " + refDef.getName() + " doesn't match the jdbc-type of the corresponding primarykey " + primField.getName() + " of the referenced class (or its subclass) " + referencedClass.getName());
            }
        }
    }

    private void checkKeyModifications(ModelDef modelDef, String checkLevel) throws ConstraintException {
        if ("none".equals(checkLevel)) {
            return;
        }
        Iterator classIt = modelDef.getClasses();
        while (classIt.hasNext()) {
            ClassDescriptorDef classDef = (ClassDescriptorDef)classIt.next();
            Iterator fieldIt = classDef.getFields();
            while (fieldIt.hasNext()) {
                FieldDescriptorDef fieldDef = (FieldDescriptorDef)fieldIt.next();
                if (!fieldDef.isInherited()) continue;
                this.checkKeyModifications(modelDef, fieldDef);
            }
        }
    }

    private void checkKeyModifications(ModelDef modelDef, FieldDescriptorDef keyDef) throws ConstraintException {
        boolean changesPrimary;
        FieldDescriptorDef baseFieldDef = (FieldDescriptorDef)keyDef.getOriginal();
        boolean isIgnored = keyDef.getBooleanProperty("ignore", false);
        boolean changesJdbcType = !baseFieldDef.getProperty("jdbc-type").equals(keyDef.getProperty("jdbc-type"));
        boolean bl = changesPrimary = baseFieldDef.getBooleanProperty("primarykey", false) != keyDef.getBooleanProperty("primarykey", false);
        if (isIgnored || changesJdbcType || changesPrimary) {
            FeatureDescriptorDef usingFeature = null;
            do {
                if ((usingFeature = this.usedByReference(modelDef, baseFieldDef)) != null) {
                    if (isIgnored) {
                        throw new ConstraintException("Cannot ignore field " + keyDef.getName() + " in class " + keyDef.getOwner().getName() + " because it is used in class " + baseFieldDef.getOwner().getName() + " by the reference " + usingFeature.getName() + " from class " + usingFeature.getOwner().getName());
                    }
                    if (changesJdbcType) {
                        throw new ConstraintException("Modification of the jdbc-type for the field " + keyDef.getName() + " in class " + keyDef.getOwner().getName() + " is not allowed because it is used in class " + baseFieldDef.getOwner().getName() + " by the reference " + usingFeature.getName() + " from class " + usingFeature.getOwner().getName());
                    }
                    throw new ConstraintException("Cannot change the primarykey status of field " + keyDef.getName() + " in class " + keyDef.getOwner().getName() + " as primarykeys are used in class " + baseFieldDef.getOwner().getName() + " by the reference " + usingFeature.getName() + " from class " + usingFeature.getOwner().getName());
                }
                usingFeature = this.usedByCollection(modelDef, baseFieldDef, changesPrimary);
                if (usingFeature == null) continue;
                if (isIgnored) {
                    throw new ConstraintException("Cannot ignore field " + keyDef.getName() + " in class " + keyDef.getOwner().getName() + " because it is used in class " + baseFieldDef.getOwner().getName() + " as a foreignkey of the collection " + usingFeature.getName() + " from class " + usingFeature.getOwner().getName());
                }
                if (changesJdbcType) {
                    throw new ConstraintException("Modification of the jdbc-type for the field " + keyDef.getName() + " in class " + keyDef.getOwner().getName() + " is not allowed because it is used in class " + baseFieldDef.getOwner().getName() + " as a foreignkey of the collecton " + usingFeature.getName() + " from class " + usingFeature.getOwner().getName());
                }
                throw new ConstraintException("Cannot change the primarykey status of field " + keyDef.getName() + " in class " + keyDef.getOwner().getName() + " as primarykeys are used in class " + baseFieldDef.getOwner().getName() + " by the collection " + usingFeature.getName() + " from class " + usingFeature.getOwner().getName());
            } while ((baseFieldDef = (FieldDescriptorDef)baseFieldDef.getOriginal()) != null);
        }
    }

    private CollectionDescriptorDef usedByCollection(ModelDef modelDef, FieldDescriptorDef fieldDef, boolean elementClassSuffices) {
        ClassDescriptorDef ownerClass = (ClassDescriptorDef)fieldDef.getOwner();
        String name = fieldDef.getName();
        Iterator classIt = modelDef.getClasses();
        while (classIt.hasNext()) {
            ClassDescriptorDef classDef = (ClassDescriptorDef)classIt.next();
            Iterator collIt = classDef.getCollections();
            while (collIt.hasNext()) {
                CollectionDescriptorDef collDef = (CollectionDescriptorDef)collIt.next();
                if (!ownerClass.getName().equals(collDef.getProperty("element-class-ref")) || !(collDef.hasProperty("indirection-table") ? elementClassSuffices : new CommaListIterator(collDef.getProperty("foreignkey")).contains(name))) continue;
                return collDef;
            }
        }
        return null;
    }

    private ReferenceDescriptorDef usedByReference(ModelDef modelDef, FieldDescriptorDef fieldDef) {
        String ownerClassName = fieldDef.getOwner().getName();
        if (PropertyHelper.toBoolean(fieldDef.getProperty("primarykey"), false)) {
            Iterator classIt = modelDef.getClasses();
            while (classIt.hasNext()) {
                ClassDescriptorDef classDef = (ClassDescriptorDef)classIt.next();
                Iterator refIt = classDef.getReferences();
                while (refIt.hasNext()) {
                    ReferenceDescriptorDef refDef = (ReferenceDescriptorDef)refIt.next();
                    if (!ownerClassName.equals(refDef.getProperty("class-ref"))) continue;
                    return refDef;
                }
            }
        }
        return null;
    }
}

