/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.ojb.constraints;

import xdoclet.modules.ojb.constraints.ConstraintException;
import xdoclet.modules.ojb.constraints.FeatureDescriptorConstraints;
import xdoclet.modules.ojb.constraints.InheritanceHelper;
import xdoclet.modules.ojb.model.ClassDescriptorDef;
import xdoclet.modules.ojb.model.ModelDef;
import xdoclet.modules.ojb.model.ReferenceDescriptorDef;

public class ReferenceDescriptorConstraints
extends FeatureDescriptorConstraints {
    public void check(ReferenceDescriptorDef refDef, String checkLevel) throws ConstraintException {
        this.ensureClassRef(refDef, checkLevel);
        this.checkProxyPrefetchingLimit(refDef, checkLevel);
    }

    private void ensureClassRef(ReferenceDescriptorDef refDef, String checkLevel) throws ConstraintException {
        String targetClassName;
        ClassDescriptorDef ownerClassDef;
        ModelDef model;
        ClassDescriptorDef targetClassDef;
        if ("none".equals(checkLevel)) {
            return;
        }
        if (!refDef.hasProperty("class-ref")) {
            if (refDef.hasProperty("default-class-ref")) {
                refDef.setProperty("class-ref", refDef.getProperty("default-class-ref"));
            } else {
                throw new ConstraintException("Reference " + refDef.getName() + " in class " + refDef.getOwner().getName() + " does not reference any class");
            }
        }
        if ((targetClassDef = (model = (ModelDef)(ownerClassDef = (ClassDescriptorDef)refDef.getOwner()).getOwner()).getClass(targetClassName = refDef.getProperty("class-ref"))) == null) {
            throw new ConstraintException("The class " + targetClassName + " referenced by " + refDef.getName() + " in class " + ownerClassDef.getName() + " is unknown or not persistent");
        }
        if (!targetClassDef.getBooleanProperty("ojb-persistent", false)) {
            throw new ConstraintException("The class " + targetClassName + " referenced by " + refDef.getName() + " in class " + ownerClassDef.getName() + " is not persistent");
        }
        if ("strict".equals(checkLevel)) {
            try {
                InheritanceHelper helper = new InheritanceHelper();
                if (refDef.isAnonymous()) {
                    if (!helper.isSameOrSubTypeOf(ownerClassDef, targetClassDef.getName(), true)) {
                        throw new ConstraintException("The class " + targetClassName + " referenced by the anonymous reference " + refDef.getName() + " in class " + ownerClassDef.getName() + " is not a basetype of the class");
                    }
                } else {
                    String varType = refDef.getProperty("variable-type");
                    if (!helper.isSameOrSubTypeOf(targetClassDef, varType, true)) {
                        throw new ConstraintException("The class " + targetClassName + " referenced by " + refDef.getName() + " in class " + ownerClassDef.getName() + " is not the same or a subtype of the variable type " + varType);
                    }
                }
            }
            catch (ClassNotFoundException ex) {
                throw new ConstraintException("Could not find the class " + ex.getMessage() + " on the classpath while checking the reference " + refDef.getName() + " in class " + refDef.getOwner().getName());
            }
        }
    }
}

