/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.ojb.model;

import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import xdoclet.modules.ojb.constraints.ConstraintException;
import xdoclet.modules.ojb.constraints.ModelConstraints;
import xdoclet.modules.ojb.model.ClassDescriptorDef;
import xdoclet.modules.ojb.model.DefBase;

public class ModelDef
extends DefBase {
    private SortedMap _classDefs = new TreeMap();
    private SortedMap _tableDefs = new TreeMap();

    public ModelDef() {
        super("");
    }

    public ClassDescriptorDef getClass(String qualifiedName) {
        return (ClassDescriptorDef)this._classDefs.get(qualifiedName);
    }

    public Iterator getClasses() {
        return this._classDefs.values().iterator();
    }

    public int getNumClasses() {
        return this._classDefs.size();
    }

    public boolean hasClass(String qualifiedName) {
        return this._classDefs.containsKey(qualifiedName);
    }

    public void addClass(ClassDescriptorDef classDef) {
        classDef.setOwner(this);
        this._classDefs.put(classDef.getName(), classDef);
    }

    public void process() throws ConstraintException {
        Iterator it = this.getClasses();
        while (it.hasNext()) {
            ClassDescriptorDef classDef = (ClassDescriptorDef)it.next();
            if (classDef.hasBeenProcessed()) continue;
            classDef.process();
        }
    }

    public void checkConstraints(String checkLevel) throws ConstraintException {
        Iterator it = this.getClasses();
        while (it.hasNext()) {
            ((ClassDescriptorDef)it.next()).checkConstraints(checkLevel);
        }
        new ModelConstraints().check(this, checkLevel);
    }
}

