/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.ojb.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import xdoclet.modules.ojb.CommaListIterator;
import xdoclet.modules.ojb.model.ClassDescriptorDef;
import xdoclet.modules.ojb.model.CollectionDescriptorDef;
import xdoclet.modules.ojb.model.ColumnDef;
import xdoclet.modules.ojb.model.DefBase;
import xdoclet.modules.ojb.model.FieldDescriptorDef;
import xdoclet.modules.ojb.model.ForeignkeyDef;
import xdoclet.modules.ojb.model.IndexDef;
import xdoclet.modules.ojb.model.IndexDescriptorDef;
import xdoclet.modules.ojb.model.ModelDef;
import xdoclet.modules.ojb.model.ReferenceDescriptorDef;
import xdoclet.modules.ojb.model.TableDef;

public class TorqueModelDef
extends DefBase {
    private SortedMap _tableDefs = new TreeMap();

    public TorqueModelDef(String dbName, ModelDef ojbModel) {
        super(dbName);
        Iterator classIt = ojbModel.getClasses();
        while (classIt.hasNext()) {
            ClassDescriptorDef classDef = (ClassDescriptorDef)classIt.next();
            if (!classDef.getBooleanProperty("ojb-persistent", false) || !classDef.getBooleanProperty("generate-table-info", true)) continue;
            this.addTableFor(classDef);
        }
    }

    public Iterator getTables() {
        return this._tableDefs.values().iterator();
    }

    public TableDef getTable(String name) {
        return (TableDef)this._tableDefs.get(name);
    }

    private void addTableFor(ClassDescriptorDef classDef) {
        String name = classDef.getProperty("table");
        TableDef tableDef = this.getTable(name);
        if (tableDef == null) {
            tableDef = new TableDef(name);
            this.addTable(tableDef);
            if (classDef.hasProperty("documentation")) {
                tableDef.setProperty("documentation", classDef.getProperty("documentation"));
            }
        }
        Iterator fieldIt = classDef.getFields();
        while (fieldIt.hasNext()) {
            FieldDescriptorDef fieldDef = (FieldDescriptorDef)fieldIt.next();
            if (fieldDef.getBooleanProperty("ignore", false)) continue;
            ColumnDef columnDef = this.addColumnFor(fieldDef, tableDef);
            if (!fieldDef.getBooleanProperty("indexed", false)) continue;
            IndexDef indexDef = tableDef.getIndex(null);
            if (indexDef == null) {
                indexDef = new IndexDef(null, false);
                tableDef.addIndex(indexDef);
            }
            indexDef.addColumn(columnDef.getName());
        }
        Iterator refIt = classDef.getReferences();
        while (refIt.hasNext()) {
            ReferenceDescriptorDef refDef = (ReferenceDescriptorDef)refIt.next();
            if (refDef.getBooleanProperty("ignore", false)) continue;
            this.addForeignkeys(refDef, tableDef);
        }
        Iterator collIt = classDef.getCollections();
        while (collIt.hasNext()) {
            CollectionDescriptorDef collDef = (CollectionDescriptorDef)collIt.next();
            if (collDef.getBooleanProperty("ignore", false) || !collDef.hasProperty("indirection-table")) continue;
            this.addIndirectionTable(collDef);
        }
        Iterator indexIt = classDef.getIndexDescriptors();
        while (indexIt.hasNext()) {
            this.addIndex((IndexDescriptorDef)indexIt.next(), tableDef);
        }
    }

    private ColumnDef addColumnFor(FieldDescriptorDef fieldDef, TableDef tableDef) {
        String name = fieldDef.getProperty("column");
        ColumnDef columnDef = tableDef.getColumn(name);
        if (columnDef == null) {
            columnDef = new ColumnDef(name);
            tableDef.addColumn(columnDef);
        }
        if (!fieldDef.isNested()) {
            columnDef.setProperty("javaName", fieldDef.getName());
        }
        columnDef.setProperty("type", fieldDef.getProperty("jdbc-type"));
        columnDef.setProperty("id", fieldDef.getProperty("id"));
        if (fieldDef.getBooleanProperty("primarykey", false)) {
            columnDef.setProperty("primaryKey", "true");
            columnDef.setProperty("required", "true");
        } else if (!fieldDef.getBooleanProperty("nullable", true)) {
            columnDef.setProperty("required", "true");
        }
        if ("database".equals(fieldDef.getProperty("autoincrement"))) {
            columnDef.setProperty("autoIncrement", "true");
        }
        columnDef.setProperty("size", fieldDef.getSizeConstraint());
        if (fieldDef.hasProperty("documentation")) {
            columnDef.setProperty("documentation", fieldDef.getProperty("documentation"));
        }
        return columnDef;
    }

    private void addForeignkeys(ReferenceDescriptorDef refDef, TableDef tableDef) {
        ClassDescriptorDef ownerClassDef = (ClassDescriptorDef)refDef.getOwner();
        ClassDescriptorDef referencedClassDef = ((ModelDef)ownerClassDef.getOwner()).getClass(refDef.getProperty("class-ref"));
        if (!referencedClassDef.getBooleanProperty("generate-table-info", true)) {
            return;
        }
        try {
            String name = refDef.getName();
            String tableName = referencedClassDef.getProperty("table");
            ArrayList localFields = ownerClassDef.getFields(refDef.getProperty("foreignkey"));
            ArrayList remoteFields = referencedClassDef.getPrimaryKeys();
            ForeignkeyDef foreignkeyDef = new ForeignkeyDef(name, tableName);
            for (int idx = 0; idx < localFields.size(); ++idx) {
                FieldDescriptorDef localField = (FieldDescriptorDef)localFields.get(idx);
                FieldDescriptorDef remoteField = (FieldDescriptorDef)remoteFields.get(idx);
                foreignkeyDef.addColumnPair(localField.getProperty("column"), remoteField.getProperty("column"));
            }
            tableDef.addForeignkey(foreignkeyDef);
        }
        catch (NoSuchFieldException ex) {
            // empty catch block
        }
    }

    private void addIndex(IndexDescriptorDef indexDescDef, TableDef tableDef) {
        IndexDef indexDef = tableDef.getIndex(indexDescDef.getName());
        if (indexDef == null) {
            indexDef = new IndexDef(indexDescDef.getName(), indexDescDef.getBooleanProperty("unique", false));
            tableDef.addIndex(indexDef);
        }
        try {
            String fieldNames = indexDescDef.getProperty("fields");
            ArrayList fields = ((ClassDescriptorDef)indexDescDef.getOwner()).getFields(fieldNames);
            Iterator it = fields.iterator();
            while (it.hasNext()) {
                FieldDescriptorDef fieldDef = (FieldDescriptorDef)it.next();
                indexDef.addColumn(fieldDef.getProperty("column"));
            }
        }
        catch (NoSuchFieldException ex) {
            // empty catch block
        }
    }

    private void addIndirectionTable(CollectionDescriptorDef collDef) {
        ColumnDef columnDef;
        String name;
        FieldDescriptorDef fieldDef;
        String tableName = collDef.getProperty("indirection-table");
        TableDef tableDef = this.getTable(tableName);
        if (tableDef == null) {
            tableDef = new TableDef(tableName);
            this.addTable(tableDef);
        }
        ClassDescriptorDef ownerClassDef = (ClassDescriptorDef)collDef.getOwner();
        ClassDescriptorDef elementClassDef = ((ModelDef)ownerClassDef.getOwner()).getClass(collDef.getProperty("element-class-ref"));
        ArrayList localPrimFields = ownerClassDef.getPrimaryKeys();
        ArrayList remotePrimFields = elementClassDef.getPrimaryKeys();
        String ownerTable = ownerClassDef.getProperty("table");
        String elementTable = elementClassDef.getProperty("table");
        CommaListIterator localKeys = new CommaListIterator(collDef.getProperty("foreignkey"));
        CommaListIterator remoteKeys = new CommaListIterator(collDef.getProperty("remote-foreignkey"));
        ForeignkeyDef foreignkey = null;
        String relationName = collDef.getProperty("relation-name");
        if (relationName != null && (foreignkey = tableDef.getForeignkey(relationName, ownerTable)) == null) {
            foreignkey = new ForeignkeyDef(relationName, ownerTable);
            tableDef.addForeignkey(foreignkey);
        }
        int idx = 0;
        while (localKeys.hasNext()) {
            fieldDef = (FieldDescriptorDef)localPrimFields.get(idx);
            name = localKeys.getNext();
            columnDef = tableDef.getColumn(name);
            if (columnDef == null) {
                columnDef = new ColumnDef(name);
                tableDef.addColumn(columnDef);
            }
            columnDef.setProperty("type", fieldDef.getProperty("jdbc-type"));
            columnDef.setProperty("size", fieldDef.getSizeConstraint());
            if (foreignkey != null) {
                foreignkey.addColumnPair(name, fieldDef.getProperty("column"));
            }
            ++idx;
        }
        relationName = collDef.getProperty("inv-relation-name");
        if (relationName != null && (foreignkey = tableDef.getForeignkey(relationName, elementTable)) == null) {
            foreignkey = new ForeignkeyDef(relationName, elementTable);
            tableDef.addForeignkey(foreignkey);
        }
        idx = 0;
        while (remoteKeys.hasNext()) {
            fieldDef = (FieldDescriptorDef)remotePrimFields.get(idx);
            name = remoteKeys.getNext();
            columnDef = tableDef.getColumn(name);
            if (columnDef == null) {
                columnDef = new ColumnDef(name);
                tableDef.addColumn(columnDef);
            }
            columnDef.setProperty("type", fieldDef.getProperty("jdbc-type"));
            columnDef.setProperty("size", fieldDef.getSizeConstraint());
            if (foreignkey != null) {
                foreignkey.addColumnPair(name, fieldDef.getProperty("column"));
            }
            ++idx;
        }
    }

    private void addTable(TableDef table) {
        table.setOwner(this);
        this._tableDefs.put(table.getName(), table);
    }
}

