/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.xmlio.out;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.apache.commons.xmlio.out.XMLWriter;

public class XMLOutputStreamWriter
extends XMLWriter {
    public static String ENCODING_UTF_8 = "UTF-8";
    public static String ENCODING_UTF_16 = "UTF-16";
    public static String ENCODING_ISO_8859_1 = "ISO-8859-1";
    public static String ENCODING_STANDARD = ENCODING_UTF_8;
    public static String ENCODING_ISO_LATIN1 = ENCODING_ISO_8859_1;
    protected OutputStream os;
    protected String encodingName;

    public XMLOutputStreamWriter(OutputStream os, String encodingName) throws UnsupportedEncodingException {
        super(new OutputStreamWriter(os, encodingName));
        this.encodingName = encodingName;
        this.os = os;
    }

    public XMLOutputStreamWriter(OutputStream os) throws UnsupportedEncodingException {
        this(os, ENCODING_STANDARD);
    }

    public String getEncodingName() {
        return this.encodingName;
    }

    public void writeXMLDeclaration() throws IOException {
        String xmlDecl = "<?xml version=\"1.0\" encoding=\"" + this.getEncodingName() + "\"?>\n";
        byte[] xmlDeclBytes = xmlDecl.getBytes("US-ASCII");
        this.flush();
        this.os.write(xmlDeclBytes);
    }
}

