/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.xmlio.out;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.xmlio.out.XMLEncode;
import org.xml.sax.Attributes;

public class XMLWriter
extends FilterWriter {
    public static final boolean NEWLINE = true;
    public static final boolean NO_NEWLINE = false;
    protected int tabWidth = 2;
    protected int depth = 0;
    protected int indent = 0;
    protected boolean prettyPrintMode = true;
    protected boolean nlAfterEmptyTag = true;
    protected boolean nlAfterStartTag = true;
    protected boolean nlAfterEndTag = true;
    protected boolean xmlDeclWritten = false;
    private boolean needsIndent = false;
    private boolean indentStringCacheValid = true;
    private String indentStringCache = "";

    public static final String createEndTag(String tagName) {
        return "</" + tagName + ">";
    }

    public static final String createStartTag(String tagName) {
        return "<" + tagName + ">";
    }

    public static final String createEmptyTag(String tagName) {
        return "<" + tagName + "/>";
    }

    public static final String createStartTag(String tagName, String[] attrNames, String[] attrValues, boolean isEmpty) {
        return XMLWriter.createStartTag(tagName, attrNames, attrValues, isEmpty, true, '\"');
    }

    public static final String createStartTag(String tagName, String[] attrNames, String[] attrValues) {
        return XMLWriter.createStartTag(tagName, attrNames, attrValues, false);
    }

    public static final String createEmptyTag(String tagName, String[] attrNames, String[] attrValues) {
        return XMLWriter.createStartTag(tagName, attrNames, attrValues, true);
    }

    public static final String createStartTag(String tagName, String attrName, String attrValue, boolean isEmpty) {
        return XMLWriter.createStartTag(tagName, new String[]{attrName}, new String[]{attrValue}, isEmpty);
    }

    public static final String createStartTag(String tagName, String attrName, String attrValue) {
        return XMLWriter.createStartTag(tagName, attrName, attrValue, false);
    }

    public static final String createEmptyTag(String tagName, String attrName, String attrValue) {
        return XMLWriter.createStartTag(tagName, attrName, attrValue, true);
    }

    public static final String createStartTag(String tagName, String[] attrNames, String[] attrValues, boolean isEmpty, boolean encodeAttrs, char quoteChar) {
        StringBuffer buf = new StringBuffer((attrNames.length + 1) * 15);
        buf.append('<').append(tagName);
        if (attrNames.length != 0 && attrNames.length <= attrValues.length) {
            for (int i = 0; i < attrNames.length; ++i) {
                String name = attrNames[i];
                String value = attrValues[i];
                if (value == null) continue;
                if (encodeAttrs) {
                    value = XMLEncode.xmlEncodeTextForAttribute(value, quoteChar);
                }
                buf.append(' ').append(name).append('=').append(value);
            }
        }
        if (isEmpty) {
            buf.append("/>");
        } else {
            buf.append('>');
        }
        return buf.toString();
    }

    public static final String createStartTag(String tagName, String[][] attrPairs, boolean isEmpty) {
        return XMLWriter.createStartTag(tagName, attrPairs, isEmpty, true, '\"');
    }

    public static final String createStartTag(String tagName, String[][] attrPairs) {
        return XMLWriter.createStartTag(tagName, attrPairs, false);
    }

    public static final String createEmptyTag(String tagName, String[][] attrPairs) {
        return XMLWriter.createStartTag(tagName, attrPairs, true);
    }

    public static final String createStartTag(String tagName, String[][] attrPairs, boolean isEmpty, boolean encodeAttrs, char quoteChar) {
        StringBuffer buf = new StringBuffer((attrPairs.length + 1) * 15);
        buf.append('<').append(tagName);
        for (int i = 0; i < attrPairs.length; ++i) {
            String name = attrPairs[i][0];
            String value = attrPairs[i][1];
            if (value == null) continue;
            if (encodeAttrs) {
                value = XMLEncode.xmlEncodeTextForAttribute(value, quoteChar);
            }
            buf.append(' ').append(name).append('=').append(value);
        }
        if (isEmpty) {
            buf.append("/>");
        } else {
            buf.append('>');
        }
        return buf.toString();
    }

    public static final String createEmptyTag(String tagName, Attributes attributes) {
        return XMLWriter.createStartTag(tagName, attributes, true);
    }

    public static final String createStartTag(String tagName, Attributes attributes) {
        return XMLWriter.createStartTag(tagName, attributes, false);
    }

    public static final String createStartTag(String tagName, Attributes attributes, boolean isEmpty) {
        return XMLWriter.createStartTag(tagName, attributes, isEmpty, true, '\"');
    }

    public static final String createStartTag(String tagName, Attributes attributes, boolean isEmpty, boolean encodeAttrs, char quoteChar) {
        StringBuffer buf = new StringBuffer((attributes.getLength() + 1) * 15);
        buf.append('<').append(tagName);
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i);
            if (encodeAttrs) {
                value = XMLEncode.xmlEncodeTextForAttribute(value, quoteChar);
            }
            buf.append(' ').append(name).append('=').append(value);
        }
        if (isEmpty) {
            buf.append("/>");
        } else {
            buf.append('>');
        }
        return buf.toString();
    }

    public static final void generateAndWriteElementWithCData(XMLWriter xmlWriter, String tagName, String[][] attrPairs, String cData) throws IOException {
        String startTag = XMLWriter.createStartTag(tagName, attrPairs);
        String endTag = XMLWriter.createEndTag(tagName);
        xmlWriter.writeElementWithCData(startTag, cData, endTag);
    }

    public static final void generateAndWriteElementWithCData(XMLWriter xmlWriter, String tagName, String[] attrNames, String[] attrValues, String cData) throws IOException {
        String startTag = XMLWriter.createStartTag(tagName, attrNames, attrValues);
        String endTag = XMLWriter.createEndTag(tagName);
        xmlWriter.writeElementWithCData(startTag, cData, endTag);
    }

    public XMLWriter(Writer writer) {
        super(writer);
    }

    public void setPrettyPrintMode(boolean prettyPrintMode) {
        this.prettyPrintMode = prettyPrintMode;
    }

    public boolean getPrettyPrintMode() {
        return this.prettyPrintMode;
    }

    public void setTabWidth(int tabWidth) {
        this.tabWidth = tabWidth;
    }

    public int getTabWidth() {
        return this.tabWidth;
    }

    public void setNlAfterEmptyTag(boolean nlAfterEmptyTag) {
        this.nlAfterEmptyTag = nlAfterEmptyTag;
    }

    public boolean getNlAfterEmptyTag() {
        return this.nlAfterEmptyTag;
    }

    public void setNlAfterEndTag(boolean nlAfterEndTag) {
        this.nlAfterEndTag = nlAfterEndTag;
    }

    public boolean getNlAfterEndTag() {
        return this.nlAfterEndTag;
    }

    public void setNlAfterStartTag(boolean nlAfterStartTag) {
        this.nlAfterStartTag = nlAfterStartTag;
    }

    public boolean getNlAfterStartTag() {
        return this.nlAfterStartTag;
    }

    public void writeXMLDeclaration() throws IOException {
        this.xmlDeclWritten = true;
        this.needsIndent = false;
        this.write("<?xml version=\"1.0\"?>\n");
    }

    public boolean isXMLDeclarationWritten() {
        return this.xmlDeclWritten;
    }

    public void setXMLDeclarationWritten(boolean xmlDeclWritten) {
        this.xmlDeclWritten = xmlDeclWritten;
    }

    public void writeProlog(String prolog) throws IOException {
        this.needsIndent = false;
        this.write(prolog);
        this.writeNl();
    }

    public void writeNl() throws IOException {
        this.needsIndent = true;
        this.write(10);
    }

    public void writeComment(String comment) throws IOException {
        this.needsIndent = false;
        this.write("<!-- ");
        this.write(comment);
        this.write(" -->");
    }

    public void writePI(String target, String data) throws IOException {
        this.needsIndent = false;
        this.write("<?" + target + " " + data + "?>");
    }

    public void writeStartTag(String startTag, boolean nl) throws IOException {
        this.writeTag(startTag, nl);
        this.depthPlus();
    }

    public void writeStartTag(String startTag) throws IOException {
        this.writeStartTag(startTag, this.nlAfterStartTag);
    }

    public void writeEndTag(String endTag, boolean nl) throws IOException {
        this.depthMinus();
        this.writeTag(endTag, nl);
    }

    public void writeEndTag(String endTag) throws IOException {
        this.writeEndTag(endTag, this.nlAfterEndTag);
    }

    public void writeEmptyElement(String emptyTag, boolean nl) throws IOException {
        this.writeTag(emptyTag, nl);
    }

    public void writeEmptyElement(String emptyTag) throws IOException {
        this.writeEmptyElement(emptyTag, this.nlAfterEmptyTag);
    }

    public void writeCData(String cData) throws IOException {
        String encoded = XMLEncode.xmlEncodeText(cData);
        this.writePCData(encoded);
    }

    public void writePCData(String pcData) throws IOException {
        this.needsIndent = false;
        this.write(pcData);
    }

    public void writeElementWithCData(String startTag, String cData, String endTag) throws IOException {
        this.writeStartTag(startTag, false);
        this.writeCData(cData);
        this.writeEndTag(endTag);
    }

    public void writeElementWithPCData(String startTag, String pcData, String endTag) throws IOException {
        this.writeStartTag(startTag, false);
        this.writePCData(pcData);
        this.writeEndTag(endTag);
    }

    private void writeTag(String tag, boolean nl) throws IOException {
        this.writeIndent();
        this.needsIndent = false;
        if (nl) {
            if (this.getPrettyPrintMode()) {
                this.write(tag);
                this.writeNl();
            } else {
                int length = tag.length();
                int pos = tag.indexOf("/>");
                if (pos != -1) {
                    this.write(tag, 0, pos);
                    this.write(10);
                    this.write(tag, pos, length - pos);
                } else {
                    pos = tag.indexOf(">");
                    if (pos != -1) {
                        this.write(tag, 0, pos);
                        this.write(10);
                        this.write(tag, pos, length - pos);
                    } else {
                        this.write(tag);
                        this.write(10);
                    }
                }
            }
        } else {
            this.write(tag);
        }
    }

    private void writeIndent() throws IOException {
        if (!this.needsIndent) {
            return;
        }
        if (!this.getPrettyPrintMode()) {
            return;
        }
        if (this.indent == 0) {
            return;
        }
        if (!this.indentStringCacheValid) {
            StringBuffer buf = new StringBuffer(this.indent);
            for (int i = 0; i < this.indent; ++i) {
                buf.append(' ');
            }
            this.indentStringCache = buf.toString();
            this.indentStringCacheValid = true;
        }
        this.write(this.indentStringCache);
    }

    private void depthPlus() {
        this.indent += this.tabWidth;
        ++this.depth;
        this.indentStringCacheValid = false;
    }

    private void depthMinus() {
        this.indent -= this.tabWidth;
        if (this.indent < 0) {
            this.indent = 0;
        }
        --this.depth;
        this.indentStringCacheValid = false;
    }
}

