/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.xmlio.in;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.xmlio.in.Item;

public class SimplePath {
    protected final String path;
    protected final Item[] pathList;

    public static final String stripEndingSlash(String path) {
        if (path != null && path.length() > 0 && path.charAt(path.length() - 1) == '/') {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public SimplePath(String path) {
        this(path, null);
    }

    public SimplePath(String path, Item[] pathList) {
        this.path = SimplePath.stripEndingSlash(path);
        this.pathList = pathList;
    }

    public SimplePath(SimplePath path) {
        this.path = SimplePath.stripEndingSlash(path.toString());
        this.pathList = new Item[path.pathList.length];
        System.arraycopy(path.pathList, 0, this.pathList, 0, path.pathList.length);
    }

    public boolean matches(Item name) {
        return this.pathList != null && this.pathList.length > 0 && this.pathList[this.pathList.length - 1].equals(name);
    }

    public boolean matches(Item[] path, boolean isRelative) {
        if (this.pathList == null || path == null || path.length > this.pathList.length || !isRelative && path.length != this.pathList.length) {
            return false;
        }
        for (int i = path.length - 1; i >= 0; --i) {
            if (this.pathList[i].equals(path[i])) continue;
            return false;
        }
        return true;
    }

    public boolean matchesFromRoot(Item[] path) {
        if (this.pathList == null || path == null || path.length > this.pathList.length) {
            return false;
        }
        for (int i = 0; i < path.length; ++i) {
            if (this.pathList[i].equals(path[i])) continue;
            return false;
        }
        return true;
    }

    public boolean matches(Item[] path) {
        return this.matches(path, true);
    }

    public boolean matches(SimplePath matchPath) {
        return this.matches(matchPath.toString());
    }

    public boolean matches(String matchPath) {
        String matchString = SimplePath.stripEndingSlash(matchPath);
        if (matchString != null && matchString.length() > 0 && matchString.charAt(0) != '/') {
            return this.path.endsWith(matchString);
        }
        return this.path.equals(matchString);
    }

    public boolean matchsAny(Collection paths) {
        Iterator it = paths.iterator();
        while (it.hasNext()) {
            SimplePath matchPath = (SimplePath)it.next();
            if (!this.matches(matchPath)) continue;
            return true;
        }
        return false;
    }

    public boolean matchsAny(String[] paths) {
        for (int i = 0; i < paths.length; ++i) {
            if (!this.matches(paths[i])) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (o instanceof String) {
            return this.path.equals(o);
        }
        if (o instanceof SimplePath) {
            return this.path.equals(((SimplePath)o).toString());
        }
        return false;
    }
}

