/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.custommonkey.xmlunit.Transform;
import org.w3c.dom.Node;

public class NodeInputStream
extends InputStream {
    private final Node rootNode;
    private final ByteArrayOutputStream nodeContentBytes;
    private final Properties outputProperties;
    private int atPos = 0;

    public NodeInputStream(Node node) {
        this(node, null);
    }

    public NodeInputStream(Node node, Properties properties) {
        this.rootNode = node;
        this.nodeContentBytes = new ByteArrayOutputStream();
        this.outputProperties = properties;
    }

    private void ensureContentAvailable() throws IOException {
        if (this.nodeContentBytes.size() > 0) {
            return;
        }
        try {
            Transform transform = new Transform(new DOMSource(this.rootNode));
            if (this.outputProperties != null) {
                transform.setOutputProperties(this.outputProperties);
            }
            StreamResult streamResult = new StreamResult(this.nodeContentBytes);
            transform.transformTo(streamResult);
        }
        catch (Exception exception) {
            throw new IOException("Unable to serialize document to outputstream: " + exception.toString());
        }
    }

    public int read() throws IOException {
        this.ensureContentAvailable();
        if (this.reallyAvailable() == 0) {
            return -1;
        }
        byte by = this.nodeContentBytes.toByteArray()[this.atPos];
        ++this.atPos;
        return by;
    }

    public void close() throws IOException {
        this.atPos = 0;
    }

    public int available() throws IOException {
        this.ensureContentAvailable();
        return this.reallyAvailable();
    }

    private int reallyAvailable() {
        return this.nodeContentBytes.size() - this.atPos;
    }
}

