/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.NodeTest;
import org.custommonkey.xmlunit.NodeTestException;
import org.custommonkey.xmlunit.NodeTester;
import org.custommonkey.xmlunit.SimpleXpathEngine;
import org.custommonkey.xmlunit.Validator;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLTestCase
extends TestCase {
    public XMLTestCase(String string) {
        super(string);
    }

    public void setIgnoreWhitespace(boolean bl) {
        XMLUnit.setIgnoreWhitespace(bl);
    }

    public void setControlParser(String string) {
        XMLUnit.setControlParser(string);
    }

    public void setTestParser(String string) {
        XMLUnit.setTestParser(string);
    }

    public Diff compareXML(Reader reader, Reader reader2) throws SAXException, IOException, ParserConfigurationException {
        return new Diff(reader, reader2);
    }

    public Diff compareXML(String string, Reader reader) throws SAXException, IOException, ParserConfigurationException {
        return new Diff(new StringReader(string), reader);
    }

    public Diff compareXML(Reader reader, String string) throws SAXException, IOException, ParserConfigurationException {
        return new Diff(reader, new StringReader(string));
    }

    public Diff compareXML(String string, String string2) throws SAXException, IOException, ParserConfigurationException {
        return new Diff(string, string2);
    }

    public Diff compareXML(Document document, Document document2) {
        return new Diff(document, document2);
    }

    public void assertXMLEqual(Diff diff, boolean bl) {
        Assert.assertEquals((String)diff.toString(), (boolean)bl, (boolean)diff.similar());
    }

    public void assertXMLEqual(Diff diff, boolean bl, String string) {
        Assert.assertEquals((String)(string + ", " + diff.toString()), (boolean)bl, (boolean)diff.similar());
    }

    public void assertXMLIdentical(Diff diff, boolean bl) {
        Assert.assertEquals((String)diff.toString(), (boolean)bl, (boolean)diff.identical());
    }

    public void assertXMLIdentical(Diff diff, boolean bl, String string) {
        Assert.assertEquals((String)(string + ", " + diff.toString()), (boolean)bl, (boolean)diff.identical());
    }

    public void assertXMLEqual(String string, String string2) throws SAXException, IOException, ParserConfigurationException {
        Diff diff = this.compareXML(string, string2);
        this.assertXMLEqual(diff, true);
    }

    public void assertXMLEqual(Reader reader, Reader reader2) throws SAXException, IOException, ParserConfigurationException {
        Diff diff = this.compareXML(reader, reader2);
        this.assertXMLEqual(diff, true);
    }

    public void assertXMLEqual(String string, String string2, String string3) throws SAXException, IOException, ParserConfigurationException {
        Diff diff = this.compareXML(string2, string3);
        this.assertXMLEqual(diff, true, string);
    }

    public void assertXMLEqual(String string, Reader reader, Reader reader2) throws SAXException, IOException, ParserConfigurationException {
        Diff diff = this.compareXML(reader, reader2);
        this.assertXMLEqual(diff, true, string);
    }

    public void assertXMLNotEqual(String string, String string2) throws SAXException, IOException, ParserConfigurationException {
        Diff diff = this.compareXML(string, string2);
        this.assertXMLEqual(diff, false);
    }

    public void assertXMLNotEqual(String string, String string2, String string3) throws SAXException, IOException, ParserConfigurationException {
        Diff diff = this.compareXML(string2, string3);
        this.assertXMLEqual(diff, false, string);
    }

    public void assertXMLNotEqual(Reader reader, Reader reader2) throws SAXException, IOException, ParserConfigurationException {
        Diff diff = this.compareXML(reader, reader2);
        this.assertXMLEqual(diff, false);
    }

    public void assertXMLNotEqual(String string, Reader reader, Reader reader2) throws SAXException, IOException, ParserConfigurationException {
        Diff diff = this.compareXML(reader, reader2);
        this.assertXMLEqual(diff, false, string);
    }

    public void assertXpathsEqual(String string, String string2, Document document) throws TransformerException {
        this.assertXpathsEqual(string, document, string2, document);
    }

    public void assertXpathsEqual(String string, String string2, String string3) throws SAXException, ParserConfigurationException, TransformerException, IOException {
        this.assertXpathsEqual(string, string2, XMLUnit.buildControlDocument(string3));
    }

    public void assertXpathsEqual(String string, String string2, String string3, String string4) throws SAXException, ParserConfigurationException, IOException, TransformerException {
        this.assertXpathsEqual(string, XMLUnit.buildControlDocument(string2), string3, XMLUnit.buildTestDocument(string4));
    }

    public void assertXpathsEqual(String string, Document document, String string2, Document document2) throws TransformerException {
        SimpleXpathEngine simpleXpathEngine = new SimpleXpathEngine();
        Diff diff = new Diff(simpleXpathEngine.getXPathResultAsDocument(string, document), simpleXpathEngine.getXPathResultAsDocument(string2, document2));
        this.assertXMLEqual(diff, true);
    }

    public void assertXpathsNotEqual(String string, String string2, Document document) throws TransformerException {
        this.assertXpathsNotEqual(string, document, string2, document);
    }

    public void assertXpathsNotEqual(String string, String string2, String string3) throws SAXException, ParserConfigurationException, TransformerException, IOException {
        this.assertXpathsNotEqual(string, string2, XMLUnit.buildControlDocument(string3));
    }

    public void assertXpathsNotEqual(String string, String string2, String string3, String string4) throws SAXException, ParserConfigurationException, IOException, TransformerException {
        this.assertXpathsNotEqual(string, XMLUnit.buildControlDocument(string2), string3, XMLUnit.buildTestDocument(string4));
    }

    public void assertXpathsNotEqual(String string, Document document, String string2, Document document2) throws TransformerException {
        SimpleXpathEngine simpleXpathEngine = new SimpleXpathEngine();
        Diff diff = new Diff(simpleXpathEngine.getXPathResultAsDocument(string, document), simpleXpathEngine.getXPathResultAsDocument(string2, document2));
        this.assertXMLEqual(diff, false);
    }

    public void assertXpathValuesEqual(String string, String string2, Document document) throws TransformerException, TransformerConfigurationException {
        this.assertXpathValuesEqual(string, document, string2, document);
    }

    public void assertXpathValuesEqual(String string, String string2, String string3) throws SAXException, ParserConfigurationException, IOException, TransformerException, TransformerConfigurationException {
        this.assertXpathValuesEqual(string, string2, XMLUnit.buildControlDocument(string3));
    }

    public void assertXpathValuesEqual(String string, String string2, String string3, String string4) throws SAXException, ParserConfigurationException, IOException, TransformerException, TransformerConfigurationException {
        this.assertXpathValuesEqual(string, XMLUnit.buildControlDocument(string2), string3, XMLUnit.buildTestDocument(string4));
    }

    public void assertXpathValuesEqual(String string, Document document, String string2, Document document2) throws TransformerException, TransformerConfigurationException {
        SimpleXpathEngine simpleXpathEngine = new SimpleXpathEngine();
        Assert.assertEquals((Object)simpleXpathEngine.evaluate(string, document), (Object)simpleXpathEngine.evaluate(string2, document2));
    }

    public void assertXpathValuesNotEqual(String string, String string2, String string3) throws SAXException, ParserConfigurationException, IOException, TransformerException, TransformerConfigurationException {
        this.assertXpathValuesNotEqual(string, string2, XMLUnit.buildControlDocument(string3));
    }

    public void assertXpathValuesNotEqual(String string, String string2, Document document) throws TransformerException, TransformerConfigurationException {
        this.assertXpathValuesNotEqual(string, document, string2, document);
    }

    public void assertXpathValuesNotEqual(String string, String string2, String string3, String string4) throws SAXException, ParserConfigurationException, IOException, TransformerException, TransformerConfigurationException {
        this.assertXpathValuesNotEqual(string, XMLUnit.buildControlDocument(string2), string3, XMLUnit.buildTestDocument(string4));
    }

    public void assertXpathValuesNotEqual(String string, Document document, String string2, Document document2) throws TransformerException, TransformerConfigurationException {
        SimpleXpathEngine simpleXpathEngine = new SimpleXpathEngine();
        String string3 = simpleXpathEngine.evaluate(string, document);
        String string4 = simpleXpathEngine.evaluate(string2, document2);
        if (string3 != null) {
            if (string3.equals(string4)) {
                Assert.fail((String)("Expected test value NOT to be equal to control but both were " + string4));
            }
        } else {
            Assert.assertNull((String)"control evaluated to null", (Object)string4);
        }
    }

    public void assertXpathEvaluatesTo(String string, String string2, String string3) throws SAXException, IOException, ParserConfigurationException, TransformerException, TransformerConfigurationException {
        Document document = XMLUnit.buildControlDocument(string3);
        this.assertXpathEvaluatesTo(string, string2, document);
    }

    public void assertXpathEvaluatesTo(String string, String string2, Document document) throws TransformerException, TransformerConfigurationException {
        SimpleXpathEngine simpleXpathEngine = new SimpleXpathEngine();
        Assert.assertEquals((Object)string, (Object)simpleXpathEngine.evaluate(string2, document));
    }

    public void assertXMLValid(String string) throws SAXException, ParserConfigurationException {
        this.assertXMLValid(new Validator(new StringReader(string)));
    }

    public void assertXMLValid(String string, String string2) throws SAXException, ParserConfigurationException {
        this.assertXMLValid(new Validator(new StringReader(string), string2));
    }

    public void assertXMLValid(String string, String string2, String string3) throws SAXException, ParserConfigurationException {
        this.assertXMLValid(new Validator(new StringReader(string), string2, string3));
    }

    public void assertXMLValid(Validator validator) {
        Assert.assertEquals((String)validator.toString(), (boolean)true, (boolean)validator.isValid());
    }

    public void assertNodeTestPasses(String string, NodeTester nodeTester, short s) throws SAXException, ParserConfigurationException, IOException {
        NodeTest nodeTest = new NodeTest(new StringReader(string));
        this.assertNodeTestPasses(nodeTest, nodeTester, new short[]{s}, true);
    }

    public void assertNodeTestPasses(NodeTest nodeTest, NodeTester nodeTester, short[] sArray, boolean bl) {
        block3: {
            try {
                nodeTest.performTest(nodeTester, sArray);
                if (!bl) {
                    Assert.fail((String)"Expected node test to fail, but it passed!");
                }
            }
            catch (NodeTestException nodeTestException) {
                if (!bl) break block3;
                Assert.fail((String)("Expected node test to pass, but it failed! " + nodeTestException.getMessage()));
            }
        }
    }
}

