/*
 * Decompiled with CFR 0.152.
 */
package org.easymock;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import junit.framework.AssertionFailedError;
import org.easymock.InvalidMockUsageException;
import org.easymock.MockControl;
import org.easymock.MockControlState;

abstract class AbstractMockControl
implements MockControl,
InvocationHandler {
    protected MockControlState state;
    private Object mock;
    private Class interfaceToMock;

    AbstractMockControl(Class clazz) {
        Class[] classArray = new Class[]{clazz};
        ClassLoader classLoader = clazz.getClassLoader();
        this.interfaceToMock = clazz;
        this.mock = Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)this);
        this.reset();
    }

    public Object getMock() {
        return this.mock;
    }

    Class getInterfaceToMock() {
        return this.interfaceToMock;
    }

    public void activate() {
        try {
            this.state = this.state.activate();
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }

    public abstract void reset();

    public void verify() {
        try {
            this.state.verify();
        }
        catch (AssertionFailedError assertionFailedError) {
            throw new AssertionFailedError(this.mock.toString() + ": Expectation failure on verify: " + assertionFailedError.getMessage());
        }
        catch (RuntimeException runtimeException) {
            throw (RuntimeException)runtimeException.fillInStackTrace();
        }
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        try {
            return this.state.invoke(object, method, objectArray);
        }
        catch (AssertionFailedError assertionFailedError) {
            throw new AssertionFailedError(this.mock.toString() + ": " + assertionFailedError.getMessage());
        }
        catch (Throwable throwable) {
            throw throwable.fillInStackTrace();
        }
    }

    public void setVoidCallable() {
        try {
            this.state.setVoidCallable();
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }

    public void setThrowable(Throwable throwable) {
        try {
            this.state.setThrowable(throwable);
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }

    public void setReturnValue(boolean bl) {
        try {
            this.state.setReturnValue(bl);
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }

    public void setReturnValue(byte by) {
        try {
            this.state.setReturnValue(by);
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }

    public void setReturnValue(short s) {
        try {
            this.state.setReturnValue(s);
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }

    public void setReturnValue(char c) {
        try {
            this.state.setReturnValue(c);
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }

    public void setReturnValue(int n) {
        try {
            this.state.setReturnValue(n);
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }

    public void setReturnValue(long l) {
        try {
            this.state.setReturnValue(l);
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }

    public void setReturnValue(float f) {
        try {
            this.state.setReturnValue(f);
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }

    public void setReturnValue(double d) {
        try {
            this.state.setReturnValue(d);
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }

    public void setReturnValue(Object object) {
        try {
            this.state.setReturnValue(object);
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }

    public void setVoidCallable(int n) {
        try {
            this.state.setVoidCallable(n);
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }

    public void setThrowable(Throwable throwable, int n) {
        try {
            this.state.setThrowable(throwable, n);
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }

    public void setReturnValue(boolean bl, int n) {
        try {
            this.state.setReturnValue(bl, n);
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }

    public void setReturnValue(byte by, int n) {
        try {
            this.state.setReturnValue(by, n);
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }

    public void setReturnValue(short s, int n) {
        try {
            this.state.setReturnValue(s, n);
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }

    public void setReturnValue(char c, int n) {
        try {
            this.state.setReturnValue(c, n);
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }

    public void setReturnValue(int n, int n2) {
        try {
            this.state.setReturnValue(n, n2);
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }

    public void setReturnValue(long l, int n) {
        try {
            this.state.setReturnValue(l, n);
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }

    public void setReturnValue(float f, int n) {
        try {
            this.state.setReturnValue(f, n);
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }

    public void setReturnValue(double d, int n) {
        try {
            this.state.setReturnValue(d, n);
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }

    public void setReturnValue(Object object, int n) {
        try {
            this.state.setReturnValue(object, n);
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }

    public void setDefaultVoidCallable() {
        try {
            this.state.setDefaultVoidCallable();
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }

    public void setDefaultThrowable(Throwable throwable) {
        try {
            this.state.setDefaultThrowable(throwable);
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }

    public void setDefaultReturnValue(boolean bl) {
        try {
            this.state.setDefaultReturnValue(bl);
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }

    public void setDefaultReturnValue(byte by) {
        try {
            this.state.setDefaultReturnValue(by);
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }

    public void setDefaultReturnValue(short s) {
        try {
            this.state.setDefaultReturnValue(s);
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }

    public void setDefaultReturnValue(char c) {
        try {
            this.state.setDefaultReturnValue(c);
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }

    public void setDefaultReturnValue(int n) {
        try {
            this.state.setDefaultReturnValue(n);
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }

    public void setDefaultReturnValue(long l) {
        try {
            this.state.setDefaultReturnValue(l);
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }

    public void setDefaultReturnValue(float f) {
        try {
            this.state.setDefaultReturnValue(f);
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }

    public void setDefaultReturnValue(double d) {
        try {
            this.state.setDefaultReturnValue(d);
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }

    public void setDefaultReturnValue(Object object) {
        try {
            this.state.setDefaultReturnValue(object);
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw (InvalidMockUsageException)invalidMockUsageException.fillInStackTrace();
        }
    }
}

