/*
 * Decompiled with CFR 0.152.
 */
package org.easymock;

import java.util.ArrayList;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.easymock.Behavior;
import org.easymock.InvalidMockUsageException;

class BehaviorList {
    private int position = 0;
    private List behavior = new ArrayList();

    BehaviorList() {
    }

    boolean isEmpty() {
        return this.behavior.isEmpty();
    }

    boolean isClosed() {
        if (this.isEmpty()) {
            return false;
        }
        Behavior behavior = (Behavior)this.behavior.get(this.behavior.size() - 1);
        return 0 == behavior.getTimes();
    }

    void addThrowable(Throwable throwable, int n) {
        if (this.isClosed()) {
            throw new InvalidMockUsageException("method already has an unlimited call count");
        }
        this.behavior.add(Behavior.throwBehavior(throwable, n));
    }

    void addValue(Object object, int n) {
        if (this.isClosed()) {
            throw new InvalidMockUsageException("method already has an unlimited call count");
        }
        this.behavior.add(Behavior.valueBehavior(object, n));
    }

    Behavior next() {
        int n = 0;
        int n2 = this.position;
        while (n < this.behavior.size()) {
            Behavior behavior = this.getBehavior(n);
            if ((n2 -= behavior.getTimes()) < 0 || behavior.getTimes() <= 0) {
                ++this.position;
                return behavior;
            }
            ++n;
        }
        throw new AssertionFailedError("calls expected: " + this.position + ", received: " + (this.position + 1));
    }

    private Behavior getBehavior(int n) {
        return (Behavior)this.behavior.get(n);
    }

    public void verify() {
        if (this.behavior.isEmpty()) {
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.behavior.size()) {
            n += this.getBehavior(n2).getTimes();
            ++n2;
        }
        if (this.position < n || this.position == 0) {
            throw new AssertionFailedError("calls expected: " + (this.isClosed() ? "at least " : "") + (this.isClosed() ? n + 1 : n) + ", received: " + this.position);
        }
    }

    private static class Interval {
        private Behavior behavior;
        private int start;
        private int end;

        public Interval(Behavior behavior, int n, int n2) {
            this.behavior = behavior;
            this.start = n;
            this.end = n2;
        }

        public Behavior getBehavior() {
            return this.behavior;
        }

        public boolean contains(int n) {
            if (this.end <= 0) {
                return true;
            }
            return this.start <= n && n <= this.end;
        }

        public boolean isClosed() {
            return this.end > 0;
        }
    }
}

