/*
 * Decompiled with CFR 0.152.
 */
package org.easymock;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.easymock.Arguments;
import org.easymock.Behavior;
import org.easymock.BehaviorList;
import org.easymock.InvalidMockUsageException;

class MethodBehavior {
    private Map behaviors = new HashMap();
    private Behavior defaultBehavior = null;
    private Method method;

    MethodBehavior(Method method) {
        this.method = method;
    }

    void setVoidCallable(Arguments arguments, int n) {
        this.requireVoidMethod();
        this.getBehavior(arguments).addValue(null, n);
    }

    void setReturnValue(Arguments arguments, Object object, Class clazz, int n) {
        this.requireAssignable(object, clazz);
        this.getBehavior(arguments).addValue(object, n);
    }

    void setThrowable(Arguments arguments, Throwable throwable, int n) {
        this.requireValidThrowable(throwable);
        this.getBehavior(arguments).addThrowable(throwable, n);
    }

    void setDefaultVoidCallable() {
        this.requireVoidMethod();
        this.defaultBehavior = Behavior.valueBehavior(null, 0);
    }

    void setDefaultReturnValue(Object object, Class clazz) {
        this.requireAssignable(object, clazz);
        this.defaultBehavior = Behavior.valueBehavior(object, 0);
    }

    void setDefaultThrowable(Throwable throwable) {
        this.requireValidThrowable(throwable);
        this.defaultBehavior = Behavior.throwBehavior(throwable, 0);
    }

    private void requireVoidMethod() {
        this.require(this.method.getReturnType().equals(Void.TYPE), "method has to return void");
    }

    private void requireAssignable(Object object, Class clazz) {
        Class<?> clazz2 = this.method.getReturnType();
        this.require(object == null || clazz2.isAssignableFrom(clazz), "return value is not allowed");
    }

    private void requireValidThrowable(Throwable throwable) {
        this.require(throwable != null, "null cannot be thrown");
        this.require(this.isValidThrowable(throwable), "invalid Throwable type");
    }

    private void require(boolean bl, String string) {
        if (bl) {
            return;
        }
        throw new InvalidMockUsageException(string);
    }

    private boolean isValidThrowable(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return true;
        }
        if (throwable instanceof Error) {
            return true;
        }
        Class<?>[] classArray = this.method.getExceptionTypes();
        Class<?> clazz = throwable.getClass();
        int n = 0;
        while (n < classArray.length) {
            if (classArray[n].isAssignableFrom(clazz)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    BehaviorList getBehavior(Arguments arguments) {
        if (!this.behaviors.containsKey(arguments)) {
            this.behaviors.put(arguments, new BehaviorList());
        }
        return (BehaviorList)this.behaviors.get(arguments);
    }

    Behavior next(Arguments arguments) {
        if (!this.getBehavior(arguments).isEmpty()) {
            try {
                return this.getBehavior(arguments).next();
            }
            catch (AssertionFailedError assertionFailedError) {
                throw new AssertionFailedError(this.addMethodCallToMessage(arguments, assertionFailedError));
            }
        }
        if (this.defaultBehavior != null) {
            return this.defaultBehavior;
        }
        throw new AssertionFailedError("\n  Unexpected " + this.methodCallString(arguments));
    }

    private String methodCallString(Arguments arguments) {
        return "method call " + this.method.getName() + "(" + arguments.toString() + ")";
    }

    void verify() {
        String string = "";
        boolean bl = false;
        Iterator iterator = this.behaviors.keySet().iterator();
        while (iterator.hasNext()) {
            Arguments arguments = (Arguments)iterator.next();
            BehaviorList behaviorList = this.getBehavior(arguments);
            try {
                behaviorList.verify();
            }
            catch (AssertionFailedError assertionFailedError) {
                bl = true;
                string = string + this.addMethodCallToMessage(arguments, assertionFailedError);
            }
        }
        if (!bl) {
            return;
        }
        throw new AssertionFailedError(string);
    }

    private String addMethodCallToMessage(Arguments arguments, AssertionFailedError assertionFailedError) {
        return "\n  " + this.methodCallString(arguments) + ": " + assertionFailedError.getMessage();
    }
}

