/*
 * Decompiled with CFR 0.152.
 */
package org.easymock;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.easymock.Arguments;
import org.easymock.Behavior;
import org.easymock.MethodBehavior;

class MockBehavior {
    private Map methodBehaviours = new HashMap();

    MockBehavior(Class clazz) {
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            Method method = methodArray[n];
            this.methodBehaviours.put(method, new MethodBehavior(method));
            ++n;
        }
    }

    void setVoidCallable(Method method, Arguments arguments, int n) {
        this.behaviorFor(method).setVoidCallable(arguments, n);
    }

    void setReturnValue(Method method, Arguments arguments, Object object, Class clazz, int n) {
        this.behaviorFor(method).setReturnValue(arguments, object, clazz, n);
    }

    void setThrowable(Method method, Arguments arguments, Throwable throwable, int n) {
        this.behaviorFor(method).setThrowable(arguments, throwable, n);
    }

    void setDefaultVoidCallable(Method method) {
        this.behaviorFor(method).setDefaultVoidCallable();
    }

    void setDefaultReturnValue(Method method, Object object, Class clazz) {
        this.behaviorFor(method).setDefaultReturnValue(object, clazz);
    }

    void setDefaultThrowable(Method method, Throwable throwable) {
        this.behaviorFor(method).setDefaultThrowable(throwable);
    }

    protected boolean methodCallClosed(Method method, Arguments arguments) {
        return this.behaviorFor(method).getBehavior(arguments).isClosed();
    }

    Behavior next(Method method, Arguments arguments) {
        return this.behaviorFor(method).next(arguments);
    }

    private MethodBehavior behaviorFor(Method method) {
        return (MethodBehavior)this.methodBehaviours.get(method);
    }

    public void verify() {
        String string = "";
        boolean bl = false;
        Iterator iterator = this.methodBehaviours.keySet().iterator();
        while (iterator.hasNext()) {
            MethodBehavior methodBehavior = this.behaviorFor((Method)iterator.next());
            try {
                methodBehavior.verify();
            }
            catch (AssertionFailedError assertionFailedError) {
                bl = true;
                string = string + assertionFailedError.getMessage();
            }
        }
        if (!bl) {
            return;
        }
        throw new AssertionFailedError(string);
    }
}

