/*
 * Decompiled with CFR 0.152.
 */
package org.easymock;

import java.lang.reflect.Method;
import org.easymock.AbstractState;
import org.easymock.ActiveState;
import org.easymock.Arguments;
import org.easymock.InvalidMockUsageException;
import org.easymock.MockBehavior;
import org.easymock.MockControlState;

class SetupState
extends AbstractState
implements MockControlState {
    private Method lastMethod = null;
    private Arguments lastArguments = null;
    private boolean behaviorDefinedForLastMethod = true;
    private MockBehavior expectations;

    SetupState(Class clazz) {
        this.expectations = new MockBehavior(clazz);
    }

    public Object invoke(Object object, Method method, Object[] objectArray) {
        this.closeVoidMethod();
        if (this.isEqualsMethod(method)) {
            throw new InvalidMockUsageException("equals not allowed in setup state");
        }
        if (this.isHashCodeMethod(method)) {
            throw new InvalidMockUsageException("hashCode not allowed in setup state");
        }
        if (this.isToStringMethod(method)) {
            throw new InvalidMockUsageException("toString not allowed in setup state");
        }
        this.lastMethod = method;
        this.lastArguments = new Arguments(objectArray);
        this.behaviorDefinedForLastMethod = false;
        if (this.expectations.methodCallClosed(this.lastMethod, this.lastArguments)) {
            throw new InvalidMockUsageException("method already has an unlimited call count set");
        }
        return this.emptyValueFor(method.getReturnType());
    }

    MockBehavior expectations() {
        return this.expectations;
    }

    Object emptyValueFor(Class clazz) {
        if (!clazz.isPrimitive()) {
            return null;
        }
        if (clazz == Void.TYPE) {
            return null;
        }
        if (clazz == Boolean.TYPE) {
            return new Boolean(false);
        }
        if (clazz == Byte.TYPE) {
            return new Byte(0);
        }
        if (clazz == Short.TYPE) {
            return new Short(0);
        }
        if (clazz == Character.TYPE) {
            return new Character('\u0000');
        }
        if (clazz == Integer.TYPE) {
            return new Integer(0);
        }
        if (clazz == Long.TYPE) {
            return new Long(0L);
        }
        if (clazz == Float.TYPE) {
            return new Float(0.0f);
        }
        if (clazz == Double.TYPE) {
            return new Double(0.0);
        }
        throw new RuntimeException("bug: no return value generated");
    }

    public void verify() {
        throw new InvalidMockUsageException("calling verify is not allowed in setup state");
    }

    public void setVoidCallable() {
        this.setVoidCallable(0);
    }

    public void setThrowable(Throwable throwable) {
        this.setThrowable(throwable, 0);
    }

    public void setReturnValue(boolean bl) {
        this.setReturnValue(bl, 0);
    }

    public void setReturnValue(byte by) {
        this.setReturnValue(by, 0);
    }

    public void setReturnValue(short s) {
        this.setReturnValue(s, 0);
    }

    public void setReturnValue(char c) {
        this.setReturnValue(c, 0);
    }

    public void setReturnValue(int n) {
        this.setReturnValue(n, 0);
    }

    public void setReturnValue(long l) {
        this.setReturnValue(l, 0);
    }

    public void setReturnValue(float f) {
        this.setReturnValue(f, 0);
    }

    public void setReturnValue(double d) {
        this.setReturnValue(d, 0);
    }

    public void setReturnValue(Object object) {
        this.setReturnValue(object, 0);
    }

    public void setReturnValue(boolean bl, int n) {
        this.setReturnValue(new Boolean(bl), Boolean.TYPE, n);
    }

    public void setReturnValue(byte by, int n) {
        this.setReturnValue(new Byte(by), Byte.TYPE, n);
    }

    public void setReturnValue(short s, int n) {
        this.setReturnValue(new Short(s), Short.TYPE, n);
    }

    public void setReturnValue(char c, int n) {
        this.setReturnValue(new Character(c), Character.TYPE, n);
    }

    public void setReturnValue(int n, int n2) {
        this.setReturnValue(new Integer(n), Integer.TYPE, n2);
    }

    public void setReturnValue(long l, int n) {
        this.setReturnValue(new Long(l), Long.TYPE, n);
    }

    public void setReturnValue(float f, int n) {
        this.setReturnValue(new Float(f), Float.TYPE, n);
    }

    public void setReturnValue(double d, int n) {
        this.setReturnValue(new Double(d), Double.TYPE, n);
    }

    public void setReturnValue(Object object, int n) {
        Class<?> clazz = object == null ? null : object.getClass();
        this.setReturnValue(object, clazz, n);
    }

    private void setReturnValue(Object object, Class clazz, int n) {
        this.checkLastMethodNotNull("return value");
        this.expectations.setReturnValue(this.lastMethod, this.lastArguments, object, clazz, n);
        this.behaviorDefinedForLastMethod = true;
    }

    public void setVoidCallable(int n) {
        this.checkLastMethodNotNull("void call");
        this.expectations.setVoidCallable(this.lastMethod, this.lastArguments, n);
        this.behaviorDefinedForLastMethod = true;
    }

    public void setThrowable(Throwable throwable, int n) {
        this.checkLastMethodNotNull("Throwable");
        this.expectations.setThrowable(this.lastMethod, this.lastArguments, throwable, n);
        this.behaviorDefinedForLastMethod = true;
    }

    private void checkLastMethodNotNull(String string) {
        if (this.lastMethod != null) {
            return;
        }
        throw new InvalidMockUsageException("method missing for specifying " + string);
    }

    public MockControlState activate() {
        this.closeVoidMethod();
        return new ActiveState(this.expectations());
    }

    private void closeVoidMethod() {
        if (this.behaviorDefinedForLastMethod) {
            return;
        }
        try {
            this.setVoidCallable();
        }
        catch (InvalidMockUsageException invalidMockUsageException) {
            throw new InvalidMockUsageException("undefined behaviour for last method call");
        }
    }

    public void setDefaultReturnValue(float f) {
        this.setDefaultReturnValue(new Float(f), Float.TYPE);
    }

    public void setDefaultReturnValue(short s) {
        this.setDefaultReturnValue(new Short(s), Short.TYPE);
    }

    public void setDefaultReturnValue(boolean bl) {
        this.setDefaultReturnValue(new Boolean(bl), Boolean.TYPE);
    }

    public void setDefaultReturnValue(long l) {
        this.setDefaultReturnValue(new Long(l), Long.TYPE);
    }

    public void setDefaultReturnValue(double d) {
        this.setDefaultReturnValue(new Double(d), Double.TYPE);
    }

    public void setDefaultReturnValue(int n) {
        this.setDefaultReturnValue(new Integer(n), Integer.TYPE);
    }

    public void setDefaultReturnValue(char c) {
        this.setDefaultReturnValue(new Character(c), Character.TYPE);
    }

    public void setDefaultReturnValue(byte by) {
        this.setDefaultReturnValue(new Byte(by), Byte.TYPE);
    }

    public void setDefaultReturnValue(Object object) {
        Class<?> clazz = object == null ? null : object.getClass();
        this.setDefaultReturnValue(object, clazz);
    }

    public void setDefaultThrowable(Throwable throwable) {
        this.checkLastMethodNotNull("Throwable");
        this.expectations.setDefaultThrowable(this.lastMethod, throwable);
        this.behaviorDefinedForLastMethod = true;
    }

    private void setDefaultReturnValue(Object object, Class clazz) {
        this.checkLastMethodNotNull("return value");
        this.expectations.setDefaultReturnValue(this.lastMethod, object, clazz);
        this.behaviorDefinedForLastMethod = true;
    }

    public void setDefaultVoidCallable() {
        this.checkLastMethodNotNull("void call");
        this.expectations.setDefaultVoidCallable(this.lastMethod);
        this.behaviorDefinedForLastMethod = true;
    }
}

