/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.accesslayer.RelationshipPrefetcherImpl;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.core.proxy.CollectionProxyDefaultImpl;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.FieldHelper;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.collections.RemovalAwareCollection;

public class CollectionPrefetcher
extends RelationshipPrefetcherImpl {
    public CollectionPrefetcher(PersistenceBrokerImpl persistenceBrokerImpl, ObjectReferenceDescriptor objectReferenceDescriptor) {
        super(persistenceBrokerImpl, objectReferenceDescriptor);
    }

    protected Query[] buildPrefetchQueries(Collection collection, Collection collection2) {
        ClassDescriptor classDescriptor = this.getOwnerClassDescriptor();
        Class clazz = this.getBroker().getTopLevelClass(classDescriptor.getClassOfObject());
        BrokerHelper brokerHelper = this.getBroker().serviceBrokerHelper();
        ArrayList<Query> arrayList = new ArrayList<Query>(collection.size());
        HashSet<Identity> hashSet = new HashSet<Identity>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Object[] objectArray = brokerHelper.extractValueArray(brokerHelper.getKeyValues(classDescriptor, e));
            Identity identity = new Identity(null, clazz, objectArray);
            hashSet.add(identity);
            if (hashSet.size() != this.pkLimit) continue;
            arrayList.add(this.buildPrefetchQuery(hashSet));
            hashSet.clear();
        }
        if (hashSet.size() > 0) {
            arrayList.add(this.buildPrefetchQuery(hashSet));
        }
        return arrayList.toArray(new Query[arrayList.size()]);
    }

    protected Query buildPrefetchQuery(Collection collection) {
        CollectionDescriptor collectionDescriptor = this.getCollectionDescriptor();
        QueryByCriteria queryByCriteria = this.buildPrefetchQuery(collection, collectionDescriptor.getForeignKeyFieldDescriptors(this.getItemClassDescriptor()));
        if (!collectionDescriptor.getOrderBy().isEmpty()) {
            Iterator iterator = collectionDescriptor.getOrderBy().iterator();
            while (iterator.hasNext()) {
                queryByCriteria.addOrderBy((FieldHelper)iterator.next());
            }
        }
        return queryByCriteria;
    }

    protected void associateBatched(Collection collection, Collection collection2) {
        Object object;
        Object object2;
        Object[] objectArray;
        ClassDescriptor classDescriptor;
        Object object3;
        CollectionDescriptor collectionDescriptor = this.getCollectionDescriptor();
        PersistentField persistentField = collectionDescriptor.getPersistentField();
        PersistenceBrokerImpl persistenceBrokerImpl = this.getBroker();
        Class clazz = persistenceBrokerImpl.getTopLevelClass(this.getOwnerClassDescriptor().getClassOfObject());
        Class clazz2 = collectionDescriptor.getCollectionClass();
        HashMap hashMap = new HashMap(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object3 = iterator.next();
            hashMap.put(new Identity(object3, persistenceBrokerImpl), new ArrayList());
        }
        iterator = collection2.iterator();
        while (iterator.hasNext()) {
            object3 = iterator.next();
            objectArray = collectionDescriptor.getForeignKeyValues(object3, classDescriptor = this.getDescriptorRepository().getDescriptorFor(ProxyHelper.getRealClass(object3)));
            object2 = new Identity(null, clazz, objectArray);
            object = (List)hashMap.get(object2);
            if (object == null) continue;
            object.add(object3);
        }
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object4;
            classDescriptor = iterator.next();
            objectArray = new Identity(classDescriptor, persistenceBrokerImpl);
            object2 = (List)hashMap.get(objectArray);
            if (clazz2 == null && persistentField.getType().isArray()) {
                int n = object2.size();
                object4 = persistentField.getType().getComponentType();
                object3 = Array.newInstance(object4, n);
                for (int i = 0; i < n; ++i) {
                    Array.set(object3, i, object2.get(i));
                }
            } else {
                object = this.createCollection(clazz2);
                object4 = object2.iterator();
                while (object4.hasNext()) {
                    object.ojbAdd(object4.next());
                }
                object3 = object;
            }
            if ((object = persistentField.get(classDescriptor)) instanceof CollectionProxyDefaultImpl && object3 instanceof Collection) {
                ((CollectionProxyDefaultImpl)object).setData((Collection)object3);
                continue;
            }
            persistentField.set(classDescriptor, object3);
        }
    }

    protected ManageableCollection createCollection(Class clazz) {
        ManageableCollection manageableCollection;
        if (clazz == null) {
            manageableCollection = new RemovalAwareCollection();
        } else {
            try {
                manageableCollection = (ManageableCollection)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new OJBRuntimeException("Can't create new Collection for owner", exception);
            }
        }
        return manageableCollection;
    }

    protected CollectionDescriptor getCollectionDescriptor() {
        return (CollectionDescriptor)this.getObjectReferenceDescriptor();
    }
}

