/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.ojb.broker.accesslayer.ConnectionFactory;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.platforms.PlatformException;
import org.apache.ojb.broker.platforms.PlatformFactory;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public abstract class ConnectionFactoryAbstractImpl
implements ConnectionFactory {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$accesslayer$ConnectionFactoryAbstractImpl == null ? (class$org$apache$ojb$broker$accesslayer$ConnectionFactoryAbstractImpl = ConnectionFactoryAbstractImpl.class$("org.apache.ojb.broker.accesslayer.ConnectionFactoryAbstractImpl")) : class$org$apache$ojb$broker$accesslayer$ConnectionFactoryAbstractImpl);
    private Map dataSourceCache = new HashMap();
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$ConnectionFactoryAbstractImpl;

    public abstract Connection getConnectionFromPool(JdbcConnectionDescriptor var1) throws LookupException;

    public abstract void returnConnectionToPool(JdbcConnectionDescriptor var1, Connection var2) throws LookupException;

    public void releaseConnection(JdbcConnectionDescriptor jdbcConnectionDescriptor, Connection connection) {
        if (connection == null) {
            return;
        }
        if (jdbcConnectionDescriptor.isDataSource()) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                this.log.error("Closing connection failed", sQLException);
            }
        } else {
            try {
                this.returnConnectionToPool(jdbcConnectionDescriptor, connection);
            }
            catch (LookupException lookupException) {
                this.log.error("Unexpected exception when return connection " + connection + " to pool using " + jdbcConnectionDescriptor, (Throwable)((Object)lookupException));
            }
        }
    }

    public Connection lookupConnection(JdbcConnectionDescriptor jdbcConnectionDescriptor) throws LookupException {
        Connection connection;
        if (jdbcConnectionDescriptor.isDataSource()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("do datasource lookup, name: " + jdbcConnectionDescriptor.getDatasourceName() + ", user: " + jdbcConnectionDescriptor.getUserName());
            }
            connection = this.newConnectionFromDataSource(jdbcConnectionDescriptor);
        } else {
            connection = this.getConnectionFromPool(jdbcConnectionDescriptor);
            try {
                if (connection == null || connection.isClosed()) {
                    this.log.error("Connection for JdbcConnectionDiscriptor (" + (jdbcConnectionDescriptor.getDatasourceName() != null ? "datasource: " + jdbcConnectionDescriptor.getDatasourceName() : "db-url: " + this.getDbURL(jdbcConnectionDescriptor) + ", user: " + jdbcConnectionDescriptor.getUserName()) + ") was not valid, either *closed* or *null*");
                    throw new LookupException("Could not lookup valid connection from pool/DB, connection was " + connection);
                }
            }
            catch (SQLException sQLException) {
                this.log.error("Error during sanity check of new DB Connection, either it was closed", sQLException);
                throw new LookupException("Connection check failed", sQLException);
            }
        }
        return connection;
    }

    protected void initializeJdbcConnection(Connection connection, JdbcConnectionDescriptor jdbcConnectionDescriptor) throws LookupException {
        try {
            PlatformFactory.getPlatformFor(jdbcConnectionDescriptor).initializeJdbcConnection(jdbcConnectionDescriptor, connection);
        }
        catch (PlatformException platformException) {
            throw new LookupException("Platform dependent initialization of connection failed", (Throwable)((Object)platformException));
        }
    }

    public synchronized void releaseAllResources() {
        this.dataSourceCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection newConnectionFromDataSource(JdbcConnectionDescriptor jdbcConnectionDescriptor) throws LookupException {
        Connection connection = null;
        DataSource dataSource = (DataSource)this.dataSourceCache.get(jdbcConnectionDescriptor.getDatasourceName());
        try {
            if (dataSource == null) {
                Map map = this.dataSourceCache;
                synchronized (map) {
                    InitialContext initialContext = new InitialContext();
                    dataSource = (DataSource)initialContext.lookup(jdbcConnectionDescriptor.getDatasourceName());
                    this.dataSourceCache.put(jdbcConnectionDescriptor.getDatasourceName(), dataSource);
                }
            }
            connection = jdbcConnectionDescriptor.getUserName() == null ? dataSource.getConnection() : dataSource.getConnection(jdbcConnectionDescriptor.getUserName(), jdbcConnectionDescriptor.getPassWord());
        }
        catch (SQLException sQLException) {
            this.log.error("SQLException thrown while trying to get Connection from Datasource (" + jdbcConnectionDescriptor.getDatasourceName() + ")", sQLException);
            throw new LookupException("SQLException thrown while trying to get Connection from Datasource (" + jdbcConnectionDescriptor.getDatasourceName() + ")", sQLException);
        }
        catch (NamingException namingException) {
            this.log.error("Naming Exception while looking up DataSource (" + jdbcConnectionDescriptor.getDatasourceName() + ")", namingException);
            throw new LookupException("Naming Exception while looking up DataSource (" + jdbcConnectionDescriptor.getDatasourceName() + ")", namingException);
        }
        this.initializeJdbcConnection(connection, jdbcConnectionDescriptor);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Create new connection using DataSource: " + connection);
        }
        return connection;
    }

    protected Connection newConnectionFromDriverManager(JdbcConnectionDescriptor jdbcConnectionDescriptor) throws LookupException {
        Connection connection = null;
        String string = jdbcConnectionDescriptor.getDriver();
        String string2 = this.getDbURL(jdbcConnectionDescriptor);
        try {
            ClassHelper.getClass(string, true);
            connection = jdbcConnectionDescriptor.getUserName() == null ? DriverManager.getConnection(string2) : DriverManager.getConnection(string2, jdbcConnectionDescriptor.getUserName(), jdbcConnectionDescriptor.getPassWord());
        }
        catch (SQLException sQLException) {
            this.log.error("Error getting Connection from DriverManager with url (" + string2 + ") and driver (" + string + ")", sQLException);
            throw new LookupException("Error getting Connection from DriverManager with url (" + string2 + ") and driver (" + string + ")", sQLException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log.error(classNotFoundException);
            throw new LookupException("A class was not found", classNotFoundException);
        }
        catch (Exception exception) {
            this.log.error("Instantiation of jdbc driver failed", exception);
            throw new LookupException("Instantiation of jdbc driver failed", exception);
        }
        this.initializeJdbcConnection(connection, jdbcConnectionDescriptor);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Create new connection using DriverManager: " + connection);
        }
        return connection;
    }

    protected String getDbURL(JdbcConnectionDescriptor jdbcConnectionDescriptor) {
        return jdbcConnectionDescriptor.isDataSource() ? jdbcConnectionDescriptor.getDatasourceName() : jdbcConnectionDescriptor.getProtocol() + ":" + jdbcConnectionDescriptor.getSubProtocol() + ":" + jdbcConnectionDescriptor.getDbAlias();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

