/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.RowReader;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class RowReaderDefaultImpl
implements RowReader {
    private static final Object[] NO_ARGS = new Object[0];
    private ClassDescriptor m_cld;
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$RowReaderDefaultImpl;

    public RowReaderDefaultImpl(ClassDescriptor classDescriptor) {
        this.m_cld = classDescriptor;
    }

    public Object readObjectFrom(Map map) throws PersistenceBrokerException {
        ClassDescriptor classDescriptor = this.selectClassDescriptor(map);
        return this.buildOrRefreshObject(map, classDescriptor, null);
    }

    public void refreshObject(Object object, Map map) {
        ClassDescriptor classDescriptor = this.selectClassDescriptor(map);
        this.buildOrRefreshObject(map, classDescriptor, object);
    }

    protected Object buildOrRefreshObject(Map map, ClassDescriptor classDescriptor, Object object) {
        Method method;
        Object object2 = object;
        FieldDescriptor fieldDescriptor = null;
        if (object == null) {
            object2 = ClassHelper.buildNewObjectInstance(classDescriptor);
        }
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getFieldDescriptions();
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            fieldDescriptor = fieldDescriptorArray[i];
            fieldDescriptor.getPersistentField().set(object2, map.get(fieldDescriptor.getColumnName()));
        }
        if (object == null && (method = classDescriptor.getInitializationMethod()) != null) {
            try {
                method.invoke(object2, NO_ARGS);
            }
            catch (Exception exception) {
                throw new PersistenceBrokerException("Unable to invoke initialization method:" + method.getName() + " for class:" + this.m_cld.getClassOfObject(), exception);
            }
        }
        return object2;
    }

    public void readObjectArrayFrom(ResultSet resultSet, Map map) {
        FieldDescriptor[] fieldDescriptorArray = null;
        fieldDescriptorArray = this.m_cld.getSuperClass() != null ? this.m_cld.getFieldDescriptorsInHeirarchy() : this.m_cld.getRepository().getFieldDescriptorsForMultiMappedTable(this.m_cld);
        this.readValuesFrom(resultSet, map, fieldDescriptorArray);
    }

    public void readPkValuesFrom(ResultSet resultSet, Map map) {
        FieldDescriptor[] fieldDescriptorArray = this.m_cld.getPkFields();
        this.readValuesFrom(resultSet, map, fieldDescriptorArray);
    }

    protected void readValuesFrom(ResultSet resultSet, Map map, FieldDescriptor[] fieldDescriptorArray) {
        int n = fieldDescriptorArray.length;
        Object object = null;
        FieldDescriptor fieldDescriptor = null;
        try {
            for (int i = 0; i < n; ++i) {
                fieldDescriptor = fieldDescriptorArray[i];
                if (map.containsKey(fieldDescriptor.getColumnName())) continue;
                object = fieldDescriptor.getJdbcType().getObjectFromColumn(resultSet, fieldDescriptor.getColumnName());
                map.put(fieldDescriptor.getColumnName(), fieldDescriptor.getFieldConversion().sqlToJava(object));
            }
        }
        catch (SQLException sQLException) {
            throw new PersistenceBrokerException("Error reading class type: " + this.m_cld.getClassNameOfObject() + " from result set, current read field was " + (fieldDescriptor != null ? fieldDescriptor.getPersistentField().getName() : null), sQLException);
        }
    }

    protected ClassDescriptor selectClassDescriptor(Map map) throws PersistenceBrokerException {
        FieldDescriptor fieldDescriptor = this.m_cld.getOjbConcreteClassField();
        if (fieldDescriptor == null) {
            return this.m_cld;
        }
        try {
            String string = (String)map.get(fieldDescriptor.getColumnName());
            if (string == null || string.trim().length() == 0) {
                throw new PersistenceBrokerException("ojbConcreteClass field returned null or 0-length string");
            }
            string = string.trim();
            ClassDescriptor classDescriptor = this.m_cld.getRepository().getDescriptorFor(string);
            if (classDescriptor == null) {
                LoggerFactory.getDefaultLogger().warn("[" + (class$org$apache$ojb$broker$accesslayer$RowReaderDefaultImpl == null ? (class$org$apache$ojb$broker$accesslayer$RowReaderDefaultImpl = RowReaderDefaultImpl.class$("org.apache.ojb.broker.accesslayer.RowReaderDefaultImpl")) : class$org$apache$ojb$broker$accesslayer$RowReaderDefaultImpl).getName() + "] Can not find class-descriptor for ojbConcreteClass " + string + ", use given class-descriptor '" + this.m_cld.getClassNameOfObject() + "' instead");
                classDescriptor = this.m_cld;
            }
            return classDescriptor;
        }
        catch (PBFactoryException pBFactoryException) {
            throw new PersistenceBrokerException((Throwable)((Object)pBFactoryException));
        }
    }

    public void setClassDescriptor(ClassDescriptor classDescriptor) {
        this.m_cld = classDescriptor;
    }

    public ClassDescriptor getClassDescriptor() {
        return this.m_cld;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

