/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer.sql;

import java.util.ArrayList;
import java.util.List;
import org.apache.ojb.broker.accesslayer.sql.SqlPkStatement;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.util.logging.Logger;

public class SqlInsertStatement
extends SqlPkStatement {
    public SqlInsertStatement(ClassDescriptor classDescriptor, Logger logger) {
        super(classDescriptor, logger);
    }

    public String getStatement() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        ClassDescriptor classDescriptor = this.getClassDescriptor();
        stringBuffer.append("INSERT INTO ");
        this.appendTable(classDescriptor, stringBuffer);
        stringBuffer.append(" (");
        this.appendListOfColumns(classDescriptor, stringBuffer);
        stringBuffer.append(")");
        this.appendListOfValues(classDescriptor, stringBuffer);
        return stringBuffer.toString();
    }

    private List appendListOfColumns(ClassDescriptor classDescriptor, StringBuffer stringBuffer) {
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getAllRwFields();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(fieldDescriptorArray[i].getColumnName());
            arrayList.add(fieldDescriptorArray[i].getAttributeName());
        }
        return arrayList;
    }

    private void appendListOfValues(ClassDescriptor classDescriptor, StringBuffer stringBuffer) {
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getAllRwFields();
        if (fieldDescriptorArray.length == 0) {
            return;
        }
        stringBuffer.append(" VALUES (");
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            stringBuffer.append("?");
            if (i >= fieldDescriptorArray.length - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(") ");
    }
}

