/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class InternalCache
implements ObjectCache {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$cache$InternalCache == null ? (class$org$apache$ojb$broker$cache$InternalCache = InternalCache.class$("org.apache.ojb.broker.cache.InternalCache")) : class$org$apache$ojb$broker$cache$InternalCache);
    private ObjectCache realCache;
    private HashMap localCache;
    private boolean enabledReadCache;
    static /* synthetic */ Class class$org$apache$ojb$broker$cache$InternalCache;

    public InternalCache(ObjectCache objectCache) {
        this.realCache = objectCache;
        this.localCache = new HashMap();
        this.enabledReadCache = false;
    }

    public void enableMaterializationCache() {
        this.enabledReadCache = true;
    }

    public void disableMaterializationCache() {
        this.enabledReadCache = false;
        this.pushToRealCache();
    }

    private void pushToRealCache() {
        Iterator iterator = this.localCache.keySet().iterator();
        while (iterator.hasNext()) {
            Identity identity = (Identity)iterator.next();
            this.realCache.cache(identity, this.localCache.get(identity));
        }
        this.localCache.clear();
    }

    public void cache(Identity identity, Object object) {
        if (this.enabledReadCache) {
            this.localCache.put(identity, object);
        } else {
            this.realCache.cache(identity, object);
        }
    }

    public Object lookup(Identity identity) {
        Object object = null;
        if (this.enabledReadCache) {
            object = this.localCache.get(identity);
        }
        if (object == null) {
            object = this.realCache.lookup(identity);
        }
        return object;
    }

    public void remove(Identity identity) {
        if (this.enabledReadCache && !this.localCache.isEmpty()) {
            this.localCache.remove(identity);
        }
        this.realCache.remove(identity);
    }

    public void localClear() {
        if (this.localCache.size() > 0) {
            log.warn("Found " + this.localCache.size() + " abandoned objects in local cache, check code to force" + " push to real ObjectCache");
        }
        this.localCache.clear();
    }

    public void clear() {
        this.localCache.clear();
        this.realCache.clear();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

