/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBStateEvent;
import org.apache.ojb.broker.PBStateListener;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class ObjectCacheDefaultImpl
implements ObjectCache,
PBStateListener {
    public static final String TIMEOUT_PROP = "timeout";
    public static final String AUTOSYNC_PROP = "autoSync";
    public static final String CACHING_KEY_TYPE_PROP = "cachingKeyType";
    protected static Map objectTable = new Hashtable();
    private static ReferenceQueue queue = new ReferenceQueue();
    private static long hitCount = 0L;
    private static long failCount = 0L;
    private static long gcCount = 0L;
    protected PersistenceBroker broker;
    private List identitiesInWork;
    private boolean useAutoSync;
    private long timeout = 900000L;
    private int cachingKeyType;
    static /* synthetic */ Class class$org$apache$ojb$broker$cache$ObjectCacheDefaultImpl;

    public ObjectCacheDefaultImpl(PersistenceBroker persistenceBroker, Properties properties) {
        this.broker = persistenceBroker;
        this.timeout = properties == null ? this.timeout : Long.parseLong(properties.getProperty(TIMEOUT_PROP, "900")) * 1000L;
        this.cachingKeyType = properties == null ? 0 : Integer.parseInt(properties.getProperty(CACHING_KEY_TYPE_PROP, "0"));
        boolean bl = this.useAutoSync = properties == null ? false : Boolean.valueOf(properties.getProperty(AUTOSYNC_PROP, "false").trim());
        if (this.useAutoSync && persistenceBroker != null) {
            persistenceBroker.addListener(this, true);
        }
        if (this.useAutoSync && persistenceBroker == null) {
            LoggerFactory.getDefaultLogger().info("[" + (class$org$apache$ojb$broker$cache$ObjectCacheDefaultImpl == null ? (class$org$apache$ojb$broker$cache$ObjectCacheDefaultImpl = ObjectCacheDefaultImpl.class$("org.apache.ojb.broker.cache.ObjectCacheDefaultImpl")) : class$org$apache$ojb$broker$cache$ObjectCacheDefaultImpl).getName() + "] Can't enable " + AUTOSYNC_PROP + ", because given PB instance is null");
        }
        this.identitiesInWork = new ArrayList();
    }

    public void clear() {
        this.processQueue();
        objectTable.clear();
        this.identitiesInWork.clear();
    }

    public void cache(Identity identity, Object object) {
        this.processQueue();
        if (object != null) {
            this.traceIdentity(identity);
            objectTable.put(this.buildKey(identity), new CacheEntry(object, identity, queue));
        }
    }

    public Object lookup(Identity identity) {
        this.processQueue();
        ++hitCount;
        Object var2_2 = null;
        CacheEntry cacheEntry = (CacheEntry)objectTable.get(this.buildKey(identity));
        if (cacheEntry != null && cacheEntry.oid.getObjectsTopLevelClass().equals(identity.getObjectsTopLevelClass())) {
            var2_2 = cacheEntry.get();
            if (var2_2 == null || cacheEntry.lifetime < System.currentTimeMillis()) {
                ++gcCount;
                this.remove(identity);
                var2_2 = null;
            } else {
                this.traceIdentity(identity);
            }
        } else {
            ++failCount;
        }
        return var2_2;
    }

    public void remove(Identity identity) {
        this.processQueue();
        if (identity != null) {
            this.removeTracedIdentity(identity);
            objectTable.remove(this.buildKey(identity));
        }
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE);
        toStringBuilder.append("Count of cached objects", objectTable.keySet().size());
        toStringBuilder.append("Lookup hits", hitCount);
        toStringBuilder.append("Failures", failCount);
        toStringBuilder.append("Reclaimed", gcCount);
        return toStringBuilder.toString();
    }

    protected void finalize() {
        LoggerFactory.getDefaultLogger().debug("Finalize ObjectCache: " + this.toString());
    }

    private void traceIdentity(Identity identity) {
        if (this.useAutoSync && this.broker != null && this.broker.isInTransaction()) {
            this.identitiesInWork.add(identity);
        }
    }

    private void removeTracedIdentity(Identity identity) {
        this.identitiesInWork.remove(identity);
    }

    private void synchronizeWithTracedObjects() {
        LoggerFactory.getDefaultLogger().info("[" + this.getClass().getName() + "] tx was aborted," + " remove " + this.identitiesInWork.size() + " traced (potentially modified) objects from cache");
        Iterator iterator = this.identitiesInWork.iterator();
        while (iterator.hasNext()) {
            Identity identity = (Identity)iterator.next();
            objectTable.remove(this.buildKey(identity));
        }
    }

    private Integer buildKey(Identity identity) {
        int n = 0;
        switch (this.cachingKeyType) {
            case 0: {
                n = identity.hashCode();
                break;
            }
            case 1: {
                n = new HashCodeBuilder().append(this.broker.getPBKey().getAlias().hashCode()).append(identity.hashCode()).toHashCode();
                break;
            }
            case 2: {
                n = new HashCodeBuilder().append(this.broker.getDescriptorRepository().hashCode()).append(identity.hashCode()).toHashCode();
                break;
            }
            case 3: {
                n = new HashCodeBuilder().append(this.broker.getDescriptorRepository().hashCode()).append(this.broker.getPBKey().getAlias().hashCode()).append(identity.hashCode()).toHashCode();
                break;
            }
            default: {
                throw new OJBRuntimeException("Unexpected error, 'cacheType =" + this.cachingKeyType + "' was not supported");
            }
        }
        return new Integer(n);
    }

    public void beforeRollback(PBStateEvent pBStateEvent) {
        this.synchronizeWithTracedObjects();
    }

    public void beforeCommit(PBStateEvent pBStateEvent) {
        this.identitiesInWork.clear();
    }

    public void beforeClose(PBStateEvent pBStateEvent) {
        this.identitiesInWork.clear();
    }

    public void afterRollback(PBStateEvent pBStateEvent) {
    }

    public void afterCommit(PBStateEvent pBStateEvent) {
    }

    public void afterBegin(PBStateEvent pBStateEvent) {
    }

    public void beforeBegin(PBStateEvent pBStateEvent) {
    }

    public void afterOpen(PBStateEvent pBStateEvent) {
    }

    private void processQueue() {
        CacheEntry cacheEntry;
        while ((cacheEntry = (CacheEntry)queue.poll()) != null) {
            this.removeTracedIdentity(cacheEntry.oid);
            objectTable.remove(this.buildKey(cacheEntry.oid));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class CacheEntry
    extends SoftReference {
        private final long lifetime;
        private final Identity oid;

        public CacheEntry(Object object, Identity identity, ReferenceQueue referenceQueue) {
            super(object, referenceQueue);
            this.oid = identity;
            this.lifetime = ObjectCacheDefaultImpl.this.timeout < 0L ? Long.MAX_VALUE : System.currentTimeMillis() + ObjectCacheDefaultImpl.this.timeout;
        }
    }
}

