/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PBStateEvent;
import org.apache.ojb.broker.PBStateListener;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.ObjectCache;

public class ObjectCachePerBrokerImpl
implements ObjectCache,
PBStateListener {
    protected Map objectTable = new HashMap();

    public ObjectCachePerBrokerImpl(PersistenceBroker persistenceBroker, Properties properties) {
        persistenceBroker.addListener(this, true);
    }

    public void clear() {
        this.objectTable.clear();
    }

    public void cache(Identity identity, Object object) {
        if (object != null) {
            SoftReference<Object> softReference = new SoftReference<Object>(object);
            this.objectTable.put(identity, softReference);
        }
    }

    public Object lookup(Identity identity) {
        Object var2_2 = null;
        SoftReference softReference = (SoftReference)this.objectTable.get(identity);
        if (softReference != null && (var2_2 = softReference.get()) == null) {
            this.objectTable.remove(identity);
        }
        return var2_2;
    }

    public void remove(Identity identity) {
        if (identity != null) {
            this.objectTable.remove(identity);
        }
    }

    public void beforeClose(PBStateEvent pBStateEvent) {
        this.clear();
    }

    public void afterOpen(PBStateEvent pBStateEvent) {
    }

    public void beforeBegin(PBStateEvent pBStateEvent) {
    }

    public void afterBegin(PBStateEvent pBStateEvent) {
    }

    public void beforeCommit(PBStateEvent pBStateEvent) {
    }

    public void afterCommit(PBStateEvent pBStateEvent) {
    }

    public void beforeRollback(PBStateEvent pBStateEvent) {
    }

    public void afterRollback(PBStateEvent pBStateEvent) {
        this.clear();
    }
}

