/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import org.apache.ojb.broker.PBLifeCycleEvent;
import org.apache.ojb.broker.PBLifeCycleListener;
import org.apache.ojb.broker.PBListener;
import org.apache.ojb.broker.PBStateEvent;
import org.apache.ojb.broker.PBStateListener;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerEvent;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public abstract class PersistenceBrokerAbstractImpl
implements PersistenceBroker {
    private static final PBStateListener[] NO_STATE_LISTENERS = new PBStateListener[0];
    private static final PBLifeCycleListener[] NO_LIFECYCLE_LISTENERS = new PBLifeCycleListener[0];
    private PBStateListener[] permanentStateListeners = NO_STATE_LISTENERS;
    private PBStateListener[] temporaryStateListeners = NO_STATE_LISTENERS;
    private PBLifeCycleListener[] permanentLifeCycleListeners = NO_LIFECYCLE_LISTENERS;
    private PBLifeCycleListener[] temporaryLifeCycleListeners = NO_LIFECYCLE_LISTENERS;
    protected final PBStateEvent AFTER_OPEN_EVENT = new PBStateEvent(this, PBStateEvent.Type.AFTER_OPEN);
    protected final PBStateEvent AFTER_BEGIN_EVENT = new PBStateEvent(this, PBStateEvent.Type.AFTER_BEGIN);
    protected final PBStateEvent AFTER_COMMIT_EVENT = new PBStateEvent(this, PBStateEvent.Type.AFTER_COMMIT);
    protected final PBStateEvent AFTER_ROLLBACK_EVENT = new PBStateEvent(this, PBStateEvent.Type.AFTER_ROLLBACK);
    protected final PBStateEvent BEFORE_BEGIN_EVENT = new PBStateEvent(this, PBStateEvent.Type.BEFORE_BEGIN);
    protected final PBStateEvent BEFORE_COMMIT_EVENT = new PBStateEvent(this, PBStateEvent.Type.BEFORE_COMMIT);
    protected final PBStateEvent BEFORE_ROLLBACK_EVENT = new PBStateEvent(this, PBStateEvent.Type.BEFORE_ROLLBACK);
    protected final PBStateEvent BEFORE_CLOSE_EVENT = new PBStateEvent(this, PBStateEvent.Type.BEFORE_CLOSE);
    protected PBLifeCycleEvent BEFORE_STORE_EVENT = new PBLifeCycleEvent(this, PBLifeCycleEvent.Type.BEFORE_INSERT);
    protected PBLifeCycleEvent AFTER_STORE_EVENT = new PBLifeCycleEvent(this, PBLifeCycleEvent.Type.AFTER_INSERT);
    protected PBLifeCycleEvent BEFORE_DELETE_EVENT = new PBLifeCycleEvent(this, PBLifeCycleEvent.Type.BEFORE_DELETE);
    protected PBLifeCycleEvent AFTER_DELETE_EVENT = new PBLifeCycleEvent(this, PBLifeCycleEvent.Type.AFTER_DELETE);
    protected PBLifeCycleEvent AFTER_LOOKUP_EVENT = new PBLifeCycleEvent(this, PBLifeCycleEvent.Type.AFTER_LOOKUP);
    protected PBLifeCycleEvent BEFORE_UPDATE_EVENT = new PBLifeCycleEvent(this, PBLifeCycleEvent.Type.BEFORE_UPDATE);
    protected PBLifeCycleEvent AFTER_UPDATE_EVENT = new PBLifeCycleEvent(this, PBLifeCycleEvent.Type.AFTER_UPDATE);
    static /* synthetic */ Class class$org$apache$ojb$broker$core$PersistenceBrokerAbstractImpl;

    public void configure(Configuration configuration) throws ConfigurationException {
    }

    public void addListener(PBListener pBListener) throws PersistenceBrokerException {
        this.addListener(pBListener, false);
    }

    public void addListener(PBListener pBListener, boolean bl) throws PersistenceBrokerException {
        PBListener[] pBListenerArray;
        if (pBListener instanceof PBStateListener) {
            if (bl) {
                if (!this.contains(this.permanentStateListeners, pBListener)) {
                    pBListenerArray = new PBStateListener[this.permanentStateListeners.length + 1];
                    System.arraycopy(this.permanentStateListeners, 0, pBListenerArray, 0, this.permanentStateListeners.length);
                    pBListenerArray[pBListenerArray.length - 1] = (PBStateListener)pBListener;
                    this.permanentStateListeners = pBListenerArray;
                }
            } else if (!this.contains(this.temporaryStateListeners, pBListener)) {
                pBListenerArray = new PBStateListener[this.temporaryStateListeners.length + 1];
                System.arraycopy(this.temporaryStateListeners, 0, pBListenerArray, 0, this.temporaryStateListeners.length);
                pBListenerArray[pBListenerArray.length - 1] = (PBStateListener)pBListener;
                this.temporaryStateListeners = pBListenerArray;
            }
        }
        if (pBListener instanceof PBLifeCycleListener) {
            if (bl) {
                if (!this.contains(this.permanentLifeCycleListeners, pBListener)) {
                    pBListenerArray = new PBLifeCycleListener[this.permanentLifeCycleListeners.length + 1];
                    System.arraycopy(this.permanentLifeCycleListeners, 0, pBListenerArray, 0, this.permanentLifeCycleListeners.length);
                    pBListenerArray[pBListenerArray.length - 1] = (PBLifeCycleListener)pBListener;
                    this.permanentLifeCycleListeners = pBListenerArray;
                }
            } else if (!this.contains(this.temporaryLifeCycleListeners, pBListener)) {
                pBListenerArray = new PBLifeCycleListener[this.temporaryLifeCycleListeners.length + 1];
                System.arraycopy(this.temporaryLifeCycleListeners, 0, pBListenerArray, 0, this.temporaryLifeCycleListeners.length);
                pBListenerArray[pBListenerArray.length - 1] = (PBLifeCycleListener)pBListener;
                this.temporaryLifeCycleListeners = pBListenerArray;
            }
        }
    }

    public void removeListener(PBListener pBListener) throws PersistenceBrokerException {
        int n;
        int n2;
        PBListener[] pBListenerArray;
        if (pBListener instanceof PBStateListener) {
            if (this.contains(this.permanentStateListeners, pBListener)) {
                pBListenerArray = new PBStateListener[this.permanentStateListeners.length - 1];
                n2 = 0;
                for (n = 0; n < this.permanentStateListeners.length; ++n) {
                    if (this.permanentStateListeners[n] == pBListener) continue;
                    pBListenerArray[n2++] = this.permanentStateListeners[n];
                }
                this.permanentStateListeners = pBListenerArray;
            }
            if (this.contains(this.temporaryStateListeners, pBListener)) {
                pBListenerArray = new PBStateListener[this.temporaryStateListeners.length - 1];
                n2 = 0;
                for (n = 0; n < this.temporaryStateListeners.length; ++n) {
                    if (this.temporaryStateListeners[n] == pBListener) continue;
                    pBListenerArray[n2++] = this.temporaryStateListeners[n];
                }
                this.temporaryStateListeners = pBListenerArray;
            }
        }
        if (pBListener instanceof PBLifeCycleListener) {
            if (this.contains(this.permanentLifeCycleListeners, pBListener)) {
                pBListenerArray = new PBLifeCycleListener[this.permanentLifeCycleListeners.length - 1];
                n2 = 0;
                for (n = 0; n < this.permanentLifeCycleListeners.length; ++n) {
                    if (this.permanentLifeCycleListeners[n] == pBListener) continue;
                    pBListenerArray[n2++] = this.permanentLifeCycleListeners[n];
                }
                this.permanentLifeCycleListeners = pBListenerArray;
            }
            if (this.contains(this.temporaryLifeCycleListeners, pBListener)) {
                pBListenerArray = new PBLifeCycleListener[this.temporaryLifeCycleListeners.length - 1];
                n2 = 0;
                for (n = 0; n < this.temporaryLifeCycleListeners.length; ++n) {
                    if (this.temporaryLifeCycleListeners[n] == pBListener) continue;
                    pBListenerArray[n2++] = this.temporaryLifeCycleListeners[n];
                }
                this.temporaryLifeCycleListeners = pBListenerArray;
            }
        }
    }

    protected boolean contains(PBListener[] pBListenerArray, PBListener pBListener) {
        for (int i = pBListenerArray.length - 1; i >= 0; --i) {
            if (pBListenerArray[i] != pBListener) continue;
            return true;
        }
        return false;
    }

    public void removeAllListeners(boolean bl) throws PersistenceBrokerException {
        if (bl) {
            this.permanentStateListeners = NO_STATE_LISTENERS;
            this.permanentLifeCycleListeners = NO_LIFECYCLE_LISTENERS;
        }
        this.temporaryStateListeners = NO_STATE_LISTENERS;
        this.temporaryLifeCycleListeners = NO_LIFECYCLE_LISTENERS;
    }

    public void removeAllListeners() throws PersistenceBrokerException {
        this.removeAllListeners(false);
    }

    public void fireBrokerEvent(PersistenceBrokerEvent persistenceBrokerEvent) {
        if (persistenceBrokerEvent instanceof PBLifeCycleEvent) {
            this.fireBrokerEvent((PBLifeCycleEvent)persistenceBrokerEvent);
        } else if (persistenceBrokerEvent instanceof PBStateEvent) {
            this.fireBrokerEvent((PBStateEvent)persistenceBrokerEvent);
        } else {
            LoggerFactory.getDefaultLogger().error((class$org$apache$ojb$broker$core$PersistenceBrokerAbstractImpl == null ? (class$org$apache$ojb$broker$core$PersistenceBrokerAbstractImpl = PersistenceBrokerAbstractImpl.class$("org.apache.ojb.broker.core.PersistenceBrokerAbstractImpl")) : class$org$apache$ojb$broker$core$PersistenceBrokerAbstractImpl).getName() + ": Unkown PersistenceBrokerEvent was fired " + persistenceBrokerEvent);
        }
    }

    public void fireBrokerEvent(PBLifeCycleEvent pBLifeCycleEvent) {
        int n;
        if (pBLifeCycleEvent.getPersitenceBrokerAware() != null) {
            this.performCallBack(pBLifeCycleEvent);
        }
        PBLifeCycleListener[] pBLifeCycleListenerArray = this.permanentLifeCycleListeners;
        PBLifeCycleListener[] pBLifeCycleListenerArray2 = this.temporaryLifeCycleListeners;
        for (n = pBLifeCycleListenerArray.length - 1; n >= 0; --n) {
            this.notifiyObjectLifeCycleListener(pBLifeCycleListenerArray[n], pBLifeCycleEvent);
        }
        for (n = pBLifeCycleListenerArray2.length - 1; n >= 0; --n) {
            this.notifiyObjectLifeCycleListener(pBLifeCycleListenerArray2[n], pBLifeCycleEvent);
        }
    }

    public void fireBrokerEvent(PBStateEvent pBStateEvent) {
        int n;
        PBStateListener[] pBStateListenerArray = this.permanentStateListeners;
        PBStateListener[] pBStateListenerArray2 = this.temporaryStateListeners;
        for (n = pBStateListenerArray.length - 1; n >= 0; --n) {
            this.notifiyStateListener(pBStateListenerArray[n], pBStateEvent);
        }
        for (n = pBStateListenerArray2.length - 1; n >= 0; --n) {
            this.notifiyStateListener(pBStateListenerArray2[n], pBStateEvent);
        }
    }

    private void performCallBack(PBLifeCycleEvent pBLifeCycleEvent) {
        if (pBLifeCycleEvent.getPersitenceBrokerAware() == null) {
            return;
        }
        switch (pBLifeCycleEvent.getEventType().typeId()) {
            case 6: {
                pBLifeCycleEvent.getPersitenceBrokerAware().afterLookup(pBLifeCycleEvent.getTriggeringBroker());
                break;
            }
            case 3: {
                pBLifeCycleEvent.getPersitenceBrokerAware().beforeUpdate(pBLifeCycleEvent.getTriggeringBroker());
                break;
            }
            case 4: {
                pBLifeCycleEvent.getPersitenceBrokerAware().afterUpdate(pBLifeCycleEvent.getTriggeringBroker());
                break;
            }
            case 1: {
                pBLifeCycleEvent.getPersitenceBrokerAware().beforeInsert(pBLifeCycleEvent.getTriggeringBroker());
                break;
            }
            case 7: {
                pBLifeCycleEvent.getPersitenceBrokerAware().afterInsert(pBLifeCycleEvent.getTriggeringBroker());
                break;
            }
            case 2: {
                pBLifeCycleEvent.getPersitenceBrokerAware().beforeDelete(pBLifeCycleEvent.getTriggeringBroker());
                break;
            }
            case 5: {
                pBLifeCycleEvent.getPersitenceBrokerAware().afterDelete(pBLifeCycleEvent.getTriggeringBroker());
            }
        }
    }

    private void notifiyStateListener(PBStateListener pBStateListener, PBStateEvent pBStateEvent) {
        switch (pBStateEvent.getEventType().typeId()) {
            case 3: {
                pBStateListener.beforeCommit(pBStateEvent);
                break;
            }
            case 6: {
                pBStateListener.afterCommit(pBStateEvent);
                break;
            }
            case 2: {
                pBStateListener.beforeBegin(pBStateEvent);
                break;
            }
            case 5: {
                pBStateListener.afterBegin(pBStateEvent);
                break;
            }
            case 1: {
                pBStateListener.beforeClose(pBStateEvent);
                break;
            }
            case 7: {
                pBStateListener.afterOpen(pBStateEvent);
                break;
            }
            case 8: {
                pBStateListener.afterRollback(pBStateEvent);
                break;
            }
            case 4: {
                pBStateListener.beforeRollback(pBStateEvent);
            }
        }
    }

    private void notifiyObjectLifeCycleListener(PBLifeCycleListener pBLifeCycleListener, PBLifeCycleEvent pBLifeCycleEvent) {
        switch (pBLifeCycleEvent.getEventType().typeId()) {
            case 6: {
                pBLifeCycleListener.afterLookup(pBLifeCycleEvent);
                break;
            }
            case 3: {
                pBLifeCycleListener.beforeUpdate(pBLifeCycleEvent);
                break;
            }
            case 4: {
                pBLifeCycleListener.afterUpdate(pBLifeCycleEvent);
                break;
            }
            case 1: {
                pBLifeCycleListener.beforeInsert(pBLifeCycleEvent);
                break;
            }
            case 7: {
                pBLifeCycleListener.afterInsert(pBLifeCycleEvent);
                break;
            }
            case 2: {
                pBLifeCycleListener.beforeDelete(pBLifeCycleEvent);
                break;
            }
            case 5: {
                pBLifeCycleListener.afterDelete(pBLifeCycleEvent);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

